/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ComposeShader;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;

public class LightweightThemeDrawable
extends Drawable {
    private Paint mPaint;
    private Paint mColorPaint;
    private Bitmap mBitmap;
    private Resources mResources;
    private int mStartColor;
    private int mEndColor;

    public LightweightThemeDrawable(Resources resources, Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.mResources = resources;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(0.0f);
    }

    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.initializeBitmapShader();
    }

    public void draw(Canvas canvas) {
        if (this.mColorPaint != null) {
            canvas.drawPaint(this.mColorPaint);
        }
        canvas.drawPaint(this.mPaint);
    }

    public int getOpacity() {
        return -3;
    }

    public void setAlpha(int n) {
        this.mPaint.setAlpha(n);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public void setColor(int n) {
        this.mColorPaint = new Paint(this.mPaint);
        this.mColorPaint.setColor(n);
    }

    public void setColorWithFilter(int n, int n2) {
        this.mColorPaint = new Paint(this.mPaint);
        this.mColorPaint.setColor(n);
        this.mColorPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(n2, PorterDuff.Mode.SRC_OVER));
    }

    public void setAlpha(int n, int n2) {
        this.mStartColor = n << 24;
        this.mEndColor = n2 << 24;
        this.initializeBitmapShader();
    }

    private void initializeBitmapShader() {
        BitmapShader bitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        LinearGradient linearGradient = new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.mBitmap.getHeight(), this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
        this.mPaint.setShader((Shader)new ComposeShader((Shader)bitmapShader, (Shader)linearGradient, PorterDuff.Mode.DST_IN));
    }
}

