/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import org.mozilla.gecko.background.BackgroundService;
import org.mozilla.gecko.background.common.GlobalConstants;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.HealthReportConstants;
import org.mozilla.gecko.background.healthreport.prune.HealthReportPruneService;
import org.mozilla.gecko.background.healthreport.upload.HealthReportUploadService;
import org.mozilla.gecko.background.healthreport.upload.ObsoleteDocumentTracker;

public class HealthReportBroadcastService
extends BackgroundService {
    public static final String LOG_TAG = HealthReportBroadcastService.class.getSimpleName();
    public static final String WORKER_THREAD_NAME = LOG_TAG + "Worker";

    public HealthReportBroadcastService() {
        super(WORKER_THREAD_NAME);
    }

    protected SharedPreferences getSharedPreferences() {
        return this.getSharedPreferences("background", 0);
    }

    public long getSubmissionPollInterval() {
        return this.getSharedPreferences().getLong("healthreport_submission_intent_interval_msec", 3600000L);
    }

    public void setSubmissionPollInterval(long l) {
        this.getSharedPreferences().edit().putLong("healthreport_submission_intent_interval_msec", l).commit();
    }

    public long getPrunePollInterval() {
        return this.getSharedPreferences().getLong("healthreport_prune_intent_interval_msec", 86400000L);
    }

    public void setPrunePollInterval(long l) {
        this.getSharedPreferences().edit().putLong("healthreport_prune_intent_interval_msec", l).commit();
    }

    protected void toggleSubmissionAlarm(Context context, String string2, String string3, boolean bl, boolean bl2) {
        Class<HealthReportUploadService> clazz = HealthReportUploadService.class;
        Logger.info(LOG_TAG, (bl2 ? "R" : "Unr") + "egistering " + clazz.getSimpleName() + ".");
        Intent intent = new Intent(context, clazz);
        intent.setAction("upload");
        intent.putExtra("uploadEnabled", bl);
        intent.putExtra("profileName", string2);
        intent.putExtra("profilePath", string3);
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x10000000);
        if (!bl2) {
            this.cancelAlarm(pendingIntent);
            return;
        }
        long l = this.getSubmissionPollInterval();
        this.scheduleAlarm(l, pendingIntent);
    }

    protected void onHandleIntent(Intent intent) {
        Logger.setThreadLogTag("GeckoHealth");
        boolean bl = this.attemptHandleIntentForUpload(intent);
        boolean bl2 = bl = this.attemptHandleIntentForPrune(intent) ? true : bl;
        if (!bl) {
            Logger.warn(LOG_TAG, "Unhandled intent with action " + intent.getAction() + ".");
        }
    }

    protected boolean attemptHandleIntentForUpload(Intent intent) {
        if (HealthReportConstants.UPLOAD_FEATURE_DISABLED) {
            Logger.debug(LOG_TAG, "Health report upload feature is compile-time disabled; not handling intent.");
            return false;
        }
        String string2 = intent.getAction();
        Logger.debug(LOG_TAG, "Health report upload feature is compile-time enabled; attempting to handle intent with action " + string2 + ".");
        if ("org.mozilla.fennec.HEALTHREPORT_UPLOAD_PREF".equals(string2)) {
            this.handleUploadPrefIntent(intent);
            return true;
        }
        if ("android.intent.action.BOOT_COMPLETED".equals(string2) || "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(string2)) {
            BackgroundService.reflectContextToFennec((Context)this, GlobalConstants.GECKO_PREFERENCES_CLASS, GlobalConstants.GECKO_BROADCAST_HEALTHREPORT_UPLOAD_PREF_METHOD);
            return true;
        }
        return false;
    }

    protected void handleUploadPrefIntent(Intent intent) {
        if (!intent.hasExtra("enabled")) {
            Logger.warn(LOG_TAG, "Got org.mozilla.fennec.HEALTHREPORT_UPLOAD_PREF intent without enabled. Ignoring.");
            return;
        }
        boolean bl = intent.getBooleanExtra("enabled", true);
        Logger.debug(LOG_TAG, intent.getStringExtra("branch") + "/" + intent.getStringExtra("pref") + " = " + (intent.hasExtra("enabled") ? Boolean.valueOf(bl) : ""));
        String string2 = intent.getStringExtra("profileName");
        String string3 = intent.getStringExtra("profilePath");
        if (string2 == null || string3 == null) {
            Logger.warn(LOG_TAG, "Got org.mozilla.fennec.HEALTHREPORT_UPLOAD_PREF intent without profilePath or profileName. Ignoring.");
            return;
        }
        Logger.pii(LOG_TAG, "Updating health report upload alarm for profile " + string2 + " at " + string3 + ".");
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        ObsoleteDocumentTracker obsoleteDocumentTracker = new ObsoleteDocumentTracker(sharedPreferences);
        boolean bl2 = obsoleteDocumentTracker.hasObsoleteIds();
        if (!bl) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove("healthreport_last_upload_document_id");
            if (bl2) {
                Logger.debug(LOG_TAG, "Health report upload disabled; scheduling deletion of " + obsoleteDocumentTracker.numberOfObsoleteIds() + " documents.");
                obsoleteDocumentTracker.limitObsoleteIds();
            } else {
                Logger.debug(LOG_TAG, "Health report upload disabled and no deletes to schedule: clearing prefs.");
                editor.remove("healthreport_first_run");
                editor.remove("healthreport_next_submission");
            }
            editor.commit();
        }
        boolean bl3 = bl2 || bl;
        this.toggleSubmissionAlarm((Context)this, string2, string3, bl, bl3);
    }

    protected boolean attemptHandleIntentForPrune(Intent intent) {
        String string2 = intent.getAction();
        Logger.debug(LOG_TAG, "Prune: Attempting to handle intent with action, " + string2 + ".");
        if ("org.mozilla.fennec.HEALTHREPORT_PRUNE".equals(string2)) {
            this.handlePruneIntent(intent);
            return true;
        }
        if ("android.intent.action.BOOT_COMPLETED".equals(string2) || "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(string2)) {
            BackgroundService.reflectContextToFennec((Context)this, GlobalConstants.GECKO_PREFERENCES_CLASS, GlobalConstants.GECKO_BROADCAST_HEALTHREPORT_PRUNE_METHOD);
            return true;
        }
        return false;
    }

    protected void handlePruneIntent(Intent intent) {
        String string2 = intent.getStringExtra("profileName");
        String string3 = intent.getStringExtra("profilePath");
        if (string2 == null || string3 == null) {
            Logger.warn(LOG_TAG, "Got org.mozilla.fennec.HEALTHREPORT_PRUNE intent without profilePath or profileName. Ignoring.");
            return;
        }
        Class<HealthReportPruneService> clazz = HealthReportPruneService.class;
        Intent intent2 = new Intent((Context)this, clazz);
        intent2.setAction("prune");
        intent2.putExtra("profileName", string2);
        intent2.putExtra("profilePath", string3);
        PendingIntent pendingIntent = PendingIntent.getService((Context)this, (int)0, (Intent)intent2, (int)0x10000000);
        Logger.info(LOG_TAG, "Registering " + clazz.getSimpleName() + ".");
        long l = this.getPrunePollInterval();
        this.scheduleAlarm(l, pendingIntent);
    }
}

