/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport.prune;

import android.content.ContentProviderClient;
import android.content.Context;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.Environment;
import org.mozilla.gecko.background.healthreport.EnvironmentBuilder;
import org.mozilla.gecko.background.healthreport.HealthReportDatabaseStorage;
import org.mozilla.gecko.background.healthreport.ProfileInformationCache;
import org.mozilla.gecko.background.healthreport.prune.PrunePolicyStorage;

public class PrunePolicyDatabaseStorage
implements PrunePolicyStorage {
    public static final String LOG_TAG = PrunePolicyDatabaseStorage.class.getSimpleName();
    private final Context context;
    private final String profilePath;
    private ContentProviderClient client;
    private HealthReportDatabaseStorage storage;
    private int currentEnvironmentID;

    public PrunePolicyDatabaseStorage(Context context, String string2) {
        this.context = context;
        this.profilePath = string2;
        this.currentEnvironmentID = -1;
    }

    public void pruneEvents(int n) {
        this.getStorage().pruneEvents(n);
    }

    public void pruneEnvironments(int n) {
        this.getStorage().pruneEnvironments(n);
    }

    public int deleteDataBefore(long l) {
        return this.getStorage().deleteDataBefore(l, this.getCurrentEnvironmentID());
    }

    public void cleanup() {
        HealthReportDatabaseStorage healthReportDatabaseStorage = this.getStorage();
        healthReportDatabaseStorage.disableAutoVacuuming();
        healthReportDatabaseStorage.vacuum();
    }

    public int getEventCount() {
        return this.getStorage().getEventCount();
    }

    public int getEnvironmentCount() {
        return this.getStorage().getEnvironmentCount();
    }

    public void close() {
        if (this.client != null) {
            this.client.release();
            this.client = null;
        }
    }

    protected HealthReportDatabaseStorage getStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        this.client = EnvironmentBuilder.getContentProviderClient(this.context);
        if (this.client == null) {
            Logger.warn(LOG_TAG, "Unable to get ContentProviderClient - throwing.");
            throw new IllegalStateException("Unable to get ContentProviderClient.");
        }
        try {
            this.storage = EnvironmentBuilder.getStorage(this.client, this.profilePath);
            if (this.storage == null) {
                Logger.warn(LOG_TAG, "Unable to get HealthReportDatabaseStorage for " + this.profilePath + " - throwing.");
                throw new IllegalStateException("Unable to get HealthReportDatabaseStorage for " + this.profilePath + " (== null).");
            }
        }
        catch (ClassCastException classCastException) {
            Logger.warn(LOG_TAG, "Unable to get HealthReportDatabaseStorage for " + this.profilePath + this.profilePath + " (ClassCastException).");
            throw new IllegalStateException("Unable to get HealthReportDatabaseStorage for " + this.profilePath + ".", classCastException);
        }
        return this.storage;
    }

    protected int getCurrentEnvironmentID() {
        if (this.currentEnvironmentID < 0) {
            ProfileInformationCache profileInformationCache = new ProfileInformationCache(this.profilePath);
            if (!profileInformationCache.restoreUnlessInitialized()) {
                throw new IllegalStateException("Current environment unknown.");
            }
            Environment environment = EnvironmentBuilder.getCurrentEnvironment(profileInformationCache);
            this.currentEnvironmentID = environment.register();
        }
        return this.currentEnvironmentID;
    }
}

