/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.PerProfileDatabases;

public class TabsProvider
extends ContentProvider {
    private static final String LOGTAG = "GeckoTabsProvider";
    private Context mContext;
    private PerProfileDatabases<TabsDatabaseHelper> mDatabases;
    static final String DATABASE_NAME = "tabs.db";
    static final int DATABASE_VERSION = 2;
    static final String TABLE_TABS = "tabs";
    static final String TABLE_CLIENTS = "clients";
    static final int TABS = 600;
    static final int TABS_ID = 601;
    static final int CLIENTS = 602;
    static final int CLIENTS_ID = 603;
    static final String DEFAULT_TABS_SORT_ORDER = "last_modified DESC, last_used DESC";
    static final String DEFAULT_CLIENTS_SORT_ORDER = "last_modified DESC";
    static final String INDEX_TABS_GUID = "tabs_guid_index";
    static final String INDEX_TABS_POSITION = "tabs_position_index";
    static final String INDEX_CLIENTS_GUID = "clients_guid_index";
    static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    static final Map<String, String> TABS_PROJECTION_MAP;
    static final Map<String, String> CLIENTS_PROJECTION_MAP;
    private static boolean logDebug;
    private static boolean logVerbose;

    static final String selectColumn(String string2, String string3) {
        return string2 + "." + string3 + " = ?";
    }

    protected static void trace(String string2) {
        if (logVerbose) {
            Log.v((String)LOGTAG, (String)string2);
        }
    }

    protected static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }

    private SQLiteDatabase getReadableDatabase(Uri uri) {
        TabsProvider.trace("Getting readable database for URI: " + uri);
        String string2 = null;
        if (uri != null) {
            string2 = uri.getQueryParameter("profile");
        }
        return this.mDatabases.getDatabaseHelperForProfile(string2).getReadableDatabase();
    }

    private SQLiteDatabase getWritableDatabase(Uri uri) {
        TabsProvider.trace("Getting writable database for URI: " + uri);
        String string2 = null;
        if (uri != null) {
            string2 = uri.getQueryParameter("profile");
        }
        return this.mDatabases.getDatabaseHelperForProfile(string2).getWritableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onCreate() {
        TabsProvider.debug("Creating TabsProvider");
        TabsProvider tabsProvider = this;
        synchronized (tabsProvider) {
            this.mContext = this.getContext();
            this.mDatabases = new PerProfileDatabases<TabsDatabaseHelper>(this.getContext(), DATABASE_NAME, new PerProfileDatabases.DatabaseHelperFactory<TabsDatabaseHelper>(){

                @Override
                public TabsDatabaseHelper makeDatabaseHelper(Context context, String string2) {
                    return new TabsDatabaseHelper(context, string2);
                }
            });
        }
        return true;
    }

    public String getType(Uri uri) {
        int n = URI_MATCHER.match(uri);
        TabsProvider.trace("Getting URI type: " + uri);
        switch (n) {
            case 600: {
                TabsProvider.trace("URI is TABS: " + uri);
                return "vnd.android.cursor.dir/tab";
            }
            case 601: {
                TabsProvider.trace("URI is TABS_ID: " + uri);
                return "vnd.android.cursor.item/tab";
            }
            case 602: {
                TabsProvider.trace("URI is CLIENTS: " + uri);
                return "vnd.android.cursor.dir/client";
            }
            case 603: {
                TabsProvider.trace("URI is CLIENTS_ID: " + uri);
                return "vnd.android.cursor.item/client";
            }
        }
        TabsProvider.debug("URI has unrecognized type: " + uri);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Uri uri, String string2, String[] stringArray) {
        TabsProvider.trace("Calling delete on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        if (Build.VERSION.SDK_INT >= 11) {
            TabsProvider.trace("Beginning delete transaction: " + uri);
            sQLiteDatabase.beginTransaction();
            try {
                n = this.deleteInTransaction(uri, string2, stringArray);
                sQLiteDatabase.setTransactionSuccessful();
                TabsProvider.trace("Successful delete transaction: " + uri);
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        } else {
            n = this.deleteInTransaction(uri, string2, stringArray);
        }
        if (n > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return n;
    }

    public int deleteInTransaction(Uri uri, String string2, String[] stringArray) {
        TabsProvider.trace("Calling delete in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        int n2 = 0;
        switch (n) {
            case 603: {
                TabsProvider.trace("Delete on CLIENTS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_CLIENTS, "rowid"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 602: {
                TabsProvider.trace("Delete on CLIENTS: " + uri);
                this.deleteValues(uri, string2, stringArray, TABLE_TABS);
                n2 = this.deleteValues(uri, string2, stringArray, TABLE_CLIENTS);
                break;
            }
            case 601: {
                TabsProvider.trace("Delete on TABS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_TABS, "_id"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 600: {
                TabsProvider.trace("Deleting on TABS: " + uri);
                n2 = this.deleteValues(uri, string2, stringArray, TABLE_TABS);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown delete URI " + uri);
            }
        }
        TabsProvider.debug("Deleted " + n2 + " rows for URI: " + uri);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insert(Uri uri, ContentValues contentValues) {
        TabsProvider.trace("Calling insert on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        Uri uri2 = null;
        if (Build.VERSION.SDK_INT >= 11) {
            TabsProvider.trace("Beginning insert transaction: " + uri);
            sQLiteDatabase.beginTransaction();
            try {
                uri2 = this.insertInTransaction(uri, contentValues);
                sQLiteDatabase.setTransactionSuccessful();
                TabsProvider.trace("Successful insert transaction: " + uri);
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        } else {
            uri2 = this.insertInTransaction(uri, contentValues);
        }
        if (uri2 != null) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return uri2;
    }

    public Uri insertInTransaction(Uri uri, ContentValues contentValues) {
        TabsProvider.trace("Calling insert in transaction on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = URI_MATCHER.match(uri);
        long l = -1L;
        switch (n) {
            case 602: {
                String string2 = contentValues.getAsString("guid");
                TabsProvider.debug("Inserting client in database with GUID: " + string2);
                l = sQLiteDatabase.insertOrThrow(TABLE_CLIENTS, "guid", contentValues);
                break;
            }
            case 600: {
                String string3 = contentValues.getAsString("url");
                TabsProvider.debug("Inserting tab in database with URL: " + string3);
                l = sQLiteDatabase.insertOrThrow(TABLE_TABS, "title", contentValues);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown insert URI " + uri);
            }
        }
        TabsProvider.debug("Inserted ID in database: " + l);
        if (l >= 0L) {
            return ContentUris.withAppendedId((Uri)uri, (long)l);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        TabsProvider.trace("Calling update on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        if (Build.VERSION.SDK_INT >= 11) {
            TabsProvider.trace("Beginning update transaction: " + uri);
            sQLiteDatabase.beginTransaction();
            try {
                n = this.updateInTransaction(uri, contentValues, string2, stringArray);
                sQLiteDatabase.setTransactionSuccessful();
                TabsProvider.trace("Successful update transaction: " + uri);
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        } else {
            n = this.updateInTransaction(uri, contentValues, string2, stringArray);
        }
        if (n > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return n;
    }

    public int updateInTransaction(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        TabsProvider.trace("Calling update in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        int n2 = 0;
        switch (n) {
            case 603: {
                TabsProvider.trace("Update on CLIENTS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_CLIENTS, "rowid"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 602: {
                TabsProvider.trace("Update on CLIENTS: " + uri);
                n2 = this.updateValues(uri, contentValues, string2, stringArray, TABLE_CLIENTS);
                break;
            }
            case 601: {
                TabsProvider.trace("Update on TABS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_TABS, "_id"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 600: {
                TabsProvider.trace("Update on TABS: " + uri);
                n2 = this.updateValues(uri, contentValues, string2, stringArray, TABLE_TABS);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown update URI " + uri);
            }
        }
        TabsProvider.debug("Updated " + n2 + " rows for URI: " + uri);
        return n2;
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        SQLiteDatabase sQLiteDatabase = this.getReadableDatabase(uri);
        int n = URI_MATCHER.match(uri);
        SQLiteQueryBuilder sQLiteQueryBuilder = new SQLiteQueryBuilder();
        String string4 = uri.getQueryParameter("limit");
        switch (n) {
            case 601: {
                TabsProvider.trace("Query is on TABS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_TABS, "_id"));
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 600: {
                TabsProvider.trace("Query is on TABS: " + uri);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_TABS_SORT_ORDER;
                } else {
                    TabsProvider.debug("Using sort order " + string3 + ".");
                }
                sQLiteQueryBuilder.setProjectionMap(TABS_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables("tabs LEFT OUTER JOIN clients ON (tabs.client_guid = clients.guid)");
                break;
            }
            case 603: {
                TabsProvider.trace("Query is on CLIENTS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_CLIENTS, "rowid"));
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 602: {
                TabsProvider.trace("Query is on CLIENTS: " + uri);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_CLIENTS_SORT_ORDER;
                } else {
                    TabsProvider.debug("Using sort order " + string3 + ".");
                }
                sQLiteQueryBuilder.setProjectionMap(CLIENTS_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables(TABLE_CLIENTS);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown query URI " + uri);
            }
        }
        TabsProvider.trace("Running built query.");
        Cursor cursor = sQLiteQueryBuilder.query(sQLiteDatabase, stringArray, string2, stringArray2, null, null, string3, string4);
        cursor.setNotificationUri(this.getContext().getContentResolver(), BrowserContract.TABS_AUTHORITY_URI);
        return cursor;
    }

    int updateValues(Uri uri, ContentValues contentValues, String string2, String[] stringArray, String string3) {
        TabsProvider.trace("Updating tabs on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        return sQLiteDatabase.update(string3, contentValues, string2, stringArray);
    }

    int deleteValues(Uri uri, String string2, String[] stringArray, String string3) {
        TabsProvider.debug("Deleting tabs for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        return sQLiteDatabase.delete(string3, string2, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        if (contentValuesArray == null) {
            return 0;
        }
        int n = contentValuesArray.length;
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        sQLiteDatabase.beginTransaction();
        try {
            for (int i = 0; i < n; ++i) {
                try {
                    this.insertInTransaction(uri, contentValuesArray[i]);
                    ++n2;
                    continue;
                }
                catch (SQLException sQLException) {
                    Log.e((String)LOGTAG, (String)"SQLException in bulkInsert", (Throwable)sQLException);
                    sQLiteDatabase.setTransactionSuccessful();
                    sQLiteDatabase.endTransaction();
                    sQLiteDatabase.beginTransaction();
                }
            }
            TabsProvider.trace("Flushing DB bulkinsert...");
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        if (n2 > 0) {
            this.mContext.getContentResolver().notifyChange(uri, null);
        }
        return n2;
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.db.tabs", TABLE_TABS, 600);
        URI_MATCHER.addURI("org.mozilla.fennec.db.tabs", "tabs/#", 601);
        URI_MATCHER.addURI("org.mozilla.fennec.db.tabs", TABLE_CLIENTS, 602);
        URI_MATCHER.addURI("org.mozilla.fennec.db.tabs", "clients/#", 603);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("_id", "_id");
        hashMap.put("title", "title");
        hashMap.put("url", "url");
        hashMap.put("history", "history");
        hashMap.put("favicon", "favicon");
        hashMap.put("last_used", "last_used");
        hashMap.put("position", "position");
        hashMap.put("guid", "guid");
        hashMap.put("name", "name");
        hashMap.put("last_modified", "last_modified");
        TABS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        hashMap.put("guid", "guid");
        hashMap.put("name", "name");
        hashMap.put("last_modified", "last_modified");
        CLIENTS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        logDebug = Log.isLoggable((String)LOGTAG, (int)3);
        logVerbose = Log.isLoggable((String)LOGTAG, (int)2);
    }

    final class TabsDatabaseHelper
    extends SQLiteOpenHelper {
        public TabsDatabaseHelper(Context context, String string2) {
            super(context, string2, null, 2);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            TabsProvider.debug("Creating tabs.db: " + sQLiteDatabase.getPath());
            TabsProvider.debug("Creating tabs table");
            sQLiteDatabase.execSQL("CREATE TABLE tabs(_id INTEGER PRIMARY KEY AUTOINCREMENT,client_guid TEXT,title TEXT,url TEXT,history TEXT,favicon TEXT,last_used INTEGER,position INTEGER);");
            sQLiteDatabase.execSQL("CREATE INDEX tabs_guid_index ON tabs(client_guid)");
            sQLiteDatabase.execSQL("CREATE INDEX tabs_position_index ON tabs(position)");
            TabsProvider.debug("Creating clients table");
            sQLiteDatabase.execSQL("CREATE TABLE clients(guid TEXT PRIMARY KEY,name TEXT,last_modified INTEGER);");
            sQLiteDatabase.execSQL("CREATE INDEX clients_guid_index ON clients(guid)");
            this.createLocalClient(sQLiteDatabase);
        }

        private void createLocalClient(SQLiteDatabase sQLiteDatabase) {
            TabsProvider.debug("Inserting local Fennec client into clients table");
            ContentValues contentValues = new ContentValues();
            contentValues.put("last_modified", Long.valueOf(System.currentTimeMillis()));
            sQLiteDatabase.insertOrThrow(TabsProvider.TABLE_CLIENTS, null, contentValues);
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            TabsProvider.debug("Upgrading tabs.db: " + sQLiteDatabase.getPath() + " from " + n + " to " + n2);
            for (int i = n + 1; i <= n2; ++i) {
                switch (i) {
                    case 2: {
                        this.createLocalClient(sQLiteDatabase);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            TabsProvider.debug("Opening tabs.db: " + sQLiteDatabase.getPath());
            Cursor cursor = null;
            try {
                cursor = sQLiteDatabase.rawQuery("PRAGMA synchronous=OFF", null);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            if (Build.VERSION.SDK_INT >= 11) {
                sQLiteDatabase.enableWriteAheadLogging();
                sQLiteDatabase.setLockingEnabled(false);
            } else {
                cursor = null;
                try {
                    cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=PERSIST", null);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        }
    }
}

