/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.decoders;

import android.graphics.Bitmap;
import android.util.Base64;
import android.util.Log;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mozilla.gecko.favicons.decoders.ICODecoder;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.gfx.BitmapUtils;

public class FaviconDecoder {
    private static final String LOG_TAG = "GeckoFaviconDecoder";

    private static boolean isDecodableByAndroid(byte[] byArray, int n) {
        for (ImageMagicNumbers imageMagicNumbers : ImageMagicNumbers.values()) {
            if (!FaviconDecoder.bufferStartsWith(byArray, imageMagicNumbers.value, n)) continue;
            return true;
        }
        return false;
    }

    static boolean bufferStartsWith(byte[] byArray, byte[] byArray2, int n) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static LoadFaviconResult decodeFavicon(byte[] byArray, int n, int n2) {
        if (FaviconDecoder.isDecodableByAndroid(byArray, n)) {
            LoadFaviconResult loadFaviconResult = new LoadFaviconResult();
            loadFaviconResult.mOffset = n;
            loadFaviconResult.mLength = n2;
            loadFaviconResult.mIsICO = false;
            loadFaviconResult.mBitmapsDecoded = new SingleBitmapIterator(BitmapUtils.decodeByteArray(byArray, n, n2));
            loadFaviconResult.mFaviconBytes = byArray;
            return loadFaviconResult;
        }
        ICODecoder iCODecoder = new ICODecoder(byArray, n, n2);
        LoadFaviconResult loadFaviconResult = iCODecoder.decode();
        if (loadFaviconResult == null) {
            return null;
        }
        return loadFaviconResult;
    }

    public static LoadFaviconResult decodeDataURI(String string2) {
        if (string2 == null) {
            Log.w((String)LOG_TAG, (String)"Can't decode null data: URI.");
            return null;
        }
        if (!string2.startsWith("data:image/")) {
            Log.w((String)LOG_TAG, (String)"Can't decode non-image data: URI.");
            return null;
        }
        int n = string2.indexOf(44) + 1;
        if (n == 0) {
            Log.w((String)LOG_TAG, (String)"No ',' in data: URI; malformed?");
            return null;
        }
        try {
            String string3 = string2.substring(n);
            byte[] byArray = Base64.decode((String)string3, (int)0);
            return FaviconDecoder.decodeFavicon(byArray);
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Couldn't decode data: URI.", (Throwable)exception);
            return null;
        }
    }

    public static LoadFaviconResult decodeFavicon(byte[] byArray) {
        return FaviconDecoder.decodeFavicon(byArray, 0, byArray.length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingleBitmapIterator
    implements Iterator<Bitmap> {
        private Bitmap mBitmap;

        public SingleBitmapIterator(Bitmap bitmap) {
            this.mBitmap = bitmap;
        }

        public Bitmap peek() {
            return this.mBitmap;
        }

        @Override
        public boolean hasNext() {
            return this.mBitmap != null;
        }

        @Override
        public Bitmap next() {
            if (this.mBitmap == null) {
                throw new NoSuchElementException("Element already returned from SingleBitmapIterator.");
            }
            Bitmap bitmap = this.mBitmap;
            this.mBitmap = null;
            return bitmap;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported on SingleBitmapIterator.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ImageMagicNumbers {
        PNG(new byte[]{-119, 80, 78, 71, 13, 10, 26, 10}),
        GIF(new byte[]{71, 73, 70, 56}),
        JPEG(new byte[]{-1, -40, -1, -32}),
        BMP(new byte[]{66, 77}),
        WEB(new byte[]{87, 69, 66, 80, 10});

        public byte[] value;

        private ImageMagicNumbers(byte[] byArray) {
            this.value = byArray;
        }
    }
}

