/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountSetupTask;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.fxa.login.Separated;
import org.mozilla.gecko.fxa.login.State;

public class FxAccountUpdateCredentialsActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountUpdateCredentialsActivity.class.getSimpleName();
    protected AndroidFxAccount fxAccount;
    protected Separated accountState;

    public FxAccountUpdateCredentialsActivity() {
        super(2);
    }

    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_update_credentials);
        this.emailEdit = (EditText)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.remoteErrorTextView = (TextView)this.ensureFindViewById(null, R.id.remote_error, "remote error text view");
        this.button = (Button)this.ensureFindViewById(null, R.id.button, "update credentials");
        this.progressBar = (ProgressBar)this.ensureFindViewById(null, R.id.progress, "progress bar");
        this.minimumPasswordLength = 1;
        this.createButton();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        this.emailEdit.setEnabled(false);
    }

    public void onResume() {
        super.onResume();
        Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)this);
        if (accountArray.length < 1 || accountArray[0] == null) {
            Logger.warn(LOG_TAG, "No Android accounts.");
            this.setResult(0);
            this.finish();
            return;
        }
        this.fxAccount = new AndroidFxAccount((Context)this, accountArray[0]);
        if (this.fxAccount == null) {
            Logger.warn(LOG_TAG, "Could not get Firefox Account from Android account.");
            this.setResult(0);
            this.finish();
            return;
        }
        State state = this.fxAccount.getState();
        if (state.getStateLabel() != State.StateLabel.Separated) {
            Logger.warn(LOG_TAG, "Could not get state from Firefox Account.");
            this.setResult(0);
            this.finish();
            return;
        }
        this.accountState = (Separated)state;
        this.emailEdit.setText((CharSequence)this.fxAccount.getAndroidAccount().name);
    }

    public void updateCredentials(String string2, String string3) {
        String string4 = "https://api-accounts.dev.lcip.org";
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        try {
            this.hideRemoteError();
            UpdateCredentialsDelegate updateCredentialsDelegate = new UpdateCredentialsDelegate(string2, string3, string4);
            new FxAccountSetupTask.FxAccountSignInTask((Context)this, this, string2, string3, fxAccountClient20, updateCredentialsDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception updating credentials for account.", exception);
            this.showRemoteError(exception, R.string.fxaccount_update_credentials_unknown_error);
        }
    }

    protected void createButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = FxAccountUpdateCredentialsActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountUpdateCredentialsActivity.this.passwordEdit.getText().toString();
                FxAccountUpdateCredentialsActivity.this.updateCredentials(string2, string3);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UpdateCredentialsDelegate
    implements FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse> {
        public final String email;
        public final String password;
        public final String serverURI;
        public final byte[] quickStretchedPW;

        public UpdateCredentialsDelegate(String string2, String string3, String string4) throws UnsupportedEncodingException, GeneralSecurityException {
            this.email = string2;
            this.password = string3;
            this.serverURI = string4;
            this.quickStretchedPW = FxAccountUtils.generateQuickStretchedPW(string2.getBytes("UTF-8"), string3.getBytes("UTF-8"));
        }

        @Override
        public void handleError(Exception exception) {
            FxAccountUpdateCredentialsActivity.this.showRemoteError(exception, R.string.fxaccount_update_credentials_unknown_error);
        }

        @Override
        public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            FxAccountUpdateCredentialsActivity.this.showRemoteError(fxAccountClientRemoteException, R.string.fxaccount_update_credentials_unknown_error);
        }

        @Override
        public void handleSuccess(FxAccountClient20.LoginResponse loginResponse) {
            byte[] byArray;
            Logger.info(LOG_TAG, "Got success signing in.");
            if (FxAccountUpdateCredentialsActivity.this.fxAccount == null) {
                this.handleError(new IllegalStateException("fxAccount must not be null"));
                return;
            }
            try {
                byArray = FxAccountUtils.generateUnwrapBKey(this.quickStretchedPW);
            }
            catch (Exception exception) {
                this.handleError(exception);
                return;
            }
            FxAccountUpdateCredentialsActivity.this.fxAccount.setState(new Engaged(this.email, loginResponse.uid, loginResponse.verified, byArray, loginResponse.sessionToken, loginResponse.keyFetchToken));
            if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                FxAccountUpdateCredentialsActivity.this.fxAccount.dump();
            }
            FxAccountUpdateCredentialsActivity.this.redirectToActivity(FxAccountStatusActivity.class);
        }
    }
}

