/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.menu.MenuItemActionBar;
import org.mozilla.gecko.menu.MenuItemDefault;

public class MenuItemActionView
extends LinearLayout
implements GeckoMenuItem.Layout {
    private static final String LOGTAG = "GeckoMenuItemActionView";
    private MenuItemDefault mMenuItem;
    private MenuItemActionBar mMenuButton;
    private List<ImageButton> mActionButtons;
    private View.OnClickListener mActionButtonListener;

    public MenuItemActionView(Context context) {
        this(context, null);
    }

    public MenuItemActionView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.menuItemActionViewStyle);
    }

    @TargetApi(value=11)
    public MenuItemActionView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        LayoutInflater.from((Context)context).inflate(R.layout.menu_item_action_view, (ViewGroup)this);
        this.mMenuItem = (MenuItemDefault)this.findViewById(R.id.menu_item);
        this.mMenuButton = (MenuItemActionBar)this.findViewById(R.id.menu_item_button);
        this.mActionButtons = new ArrayList<ImageButton>();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = (View)this.getParent();
        if (n3 - n < view.getMeasuredWidth() || this.mActionButtons.size() != 0) {
            this.mMenuItem.setVisibility(8);
            this.mMenuButton.setVisibility(0);
        } else {
            this.mMenuItem.setVisibility(0);
            this.mMenuButton.setVisibility(8);
        }
        super.onLayout(bl, n, n2, n3, n4);
    }

    public void initialize(GeckoMenuItem geckoMenuItem) {
        if (geckoMenuItem == null) {
            return;
        }
        this.mMenuItem.initialize(geckoMenuItem);
        this.mMenuButton.initialize(geckoMenuItem);
        this.setEnabled(geckoMenuItem.isEnabled());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mMenuItem.setEnabled(bl);
        this.mMenuButton.setEnabled(bl);
        for (ImageButton imageButton : this.mActionButtons) {
            imageButton.setEnabled(bl);
            imageButton.setAlpha(bl ? 255 : 99);
        }
    }

    public void setMenuItemClickListener(View.OnClickListener onClickListener) {
        this.mMenuItem.setOnClickListener(onClickListener);
        this.mMenuButton.setOnClickListener(onClickListener);
    }

    public void setActionButtonClickListener(View.OnClickListener onClickListener) {
        this.mActionButtonListener = onClickListener;
        for (ImageButton imageButton : this.mActionButtons) {
            imageButton.setOnClickListener(onClickListener);
        }
    }

    public void setShowIcon(boolean bl) {
        this.mMenuItem.setShowIcon(bl);
    }

    public void addActionButton(Drawable drawable2) {
        int n = this.mActionButtons.size();
        this.mMenuItem.setVisibility(8);
        this.mMenuButton.setVisibility(0);
        if (drawable2 != null) {
            ImageButton imageButton = new ImageButton(this.getContext(), null, R.attr.menuItemShareActionButtonStyle);
            imageButton.setImageDrawable(drawable2);
            imageButton.setOnClickListener(this.mActionButtonListener);
            imageButton.setTag((Object)n);
            int n2 = (int)this.getResources().getDimension(R.dimen.menu_item_row_height);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, n2);
            layoutParams.weight = 1.0f;
            imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mActionButtons.add(imageButton);
            this.addView((View)imageButton, n);
        }
    }
}

