/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake.stage;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Timer;
import java.util.TimerTask;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.jpake.stage.JPakeStage;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.sync.net.SyncResponse;

public class GetRequestStage
extends JPakeStage {
    private Timer timerScheduler = new Timer();
    private int pollTries;
    private GetStepTimerTask getStepTimerTask;

    public void execute(final JPakeClient jPakeClient) {
        Resource resource;
        Logger.debug("SyncJPakeStage", "Retrieving next message.");
        GetRequestStageDelegate getRequestStageDelegate = new GetRequestStageDelegate(){

            public void handleSuccess(HttpResponse httpResponse) {
                if (jPakeClient.finished) {
                    Logger.debug("SyncJPakeStage", "Finished; returning.");
                    return;
                }
                SyncResponse syncResponse = new SyncResponse(httpResponse);
                Header header = httpResponse.getFirstHeader("etag");
                if (header == null) {
                    Logger.error("SyncJPakeStage", "Server did not supply ETag.");
                    jPakeClient.abort("jpake.error.server");
                    return;
                }
                jPakeClient.theirEtag = header.getValue();
                try {
                    jPakeClient.jIncoming = syncResponse.jsonObjectBody();
                }
                catch (Exception exception) {
                    Logger.error("SyncJPakeStage", "Illegal state.", exception);
                    jPakeClient.abort("jpake.error.invalid");
                    return;
                }
                Logger.debug("SyncJPakeStage", "incoming message: " + jPakeClient.jIncoming.toJSONString());
                jPakeClient.runNextStage();
            }

            public void handleFailure(String string2) {
                Logger.error("SyncJPakeStage", "Got HTTP failure: " + string2);
                jPakeClient.abort(string2);
            }

            public void handleError(Exception exception) {
                Logger.error("SyncJPakeStage", "Threw HTTP exception.", exception);
                jPakeClient.abort("jpake.error.network");
            }
        };
        try {
            resource = this.createGetRequest(getRequestStageDelegate, jPakeClient);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.error("SyncJPakeStage", "Incorrect URI syntax.", uRISyntaxException);
            jPakeClient.abort("jpake.error.invalid");
            return;
        }
        Logger.debug("SyncJPakeStage", "Scheduling GET request.");
        this.getStepTimerTask = new GetStepTimerTask(resource);
        this.timerScheduler.schedule((TimerTask)this.getStepTimerTask, jPakeClient.jpakePollInterval);
    }

    private Resource createGetRequest(final GetRequestStageDelegate getRequestStageDelegate, final JPakeClient jPakeClient) throws URISyntaxException {
        BaseResource baseResource = new BaseResource(jPakeClient.channelUrl);
        baseResource.delegate = new BaseResourceDelegate(baseResource){

            public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
                httpRequestBase.setHeader((Header)new BasicHeader("X-KeyExchange-Id", jPakeClient.clientId));
                if (jPakeClient.myEtag != null) {
                    httpRequestBase.setHeader((Header)new BasicHeader("If-None-Match", jPakeClient.myEtag));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleHttpResponse(HttpResponse httpResponse) {
                try {
                    int n = httpResponse.getStatusLine().getStatusCode();
                    switch (n) {
                        case 200: {
                            jPakeClient.pollTries = 0;
                            getRequestStageDelegate.handleSuccess(httpResponse);
                            return;
                        }
                        case 304: {
                            Logger.debug("SyncJPakeStage", "Channel hasn't been updated yet. Will try again later");
                            if (GetRequestStage.this.pollTries >= jPakeClient.jpakeMaxTries) {
                                Logger.error("SyncJPakeStage", "Tried for " + GetRequestStage.this.pollTries + " times, maxTries " + jPakeClient.jpakeMaxTries + ", aborting");
                                getRequestStageDelegate.handleFailure("jpake.error.timeout");
                                return;
                            } else {
                                ++jPakeClient.pollTries;
                                if (!jPakeClient.finished) {
                                    Logger.debug("SyncJPakeStage", "Scheduling next GET request.");
                                    GetRequestStage.this.scheduleGetRequest(jPakeClient.jpakePollInterval, jPakeClient);
                                    return;
                                } else {
                                    Logger.debug("SyncJPakeStage", "Resetting pollTries");
                                    jPakeClient.pollTries = 0;
                                    return;
                                }
                            }
                        }
                        case 404: {
                            Logger.error("SyncJPakeStage", "No data found in channel.");
                            getRequestStageDelegate.handleFailure("jpake.error.nodata");
                            return;
                        }
                        case 412: {
                            Logger.debug("SyncJPakeStage", "Message already replaced on server by other party.");
                            getRequestStageDelegate.handleSuccess(httpResponse);
                            return;
                        }
                        default: {
                            Logger.error("SyncJPakeStage", "Could not retrieve data. Server responded with HTTP " + n);
                            getRequestStageDelegate.handleFailure("jpake.error.server");
                            return;
                        }
                    }
                }
                finally {
                    BaseResource.consumeEntity(httpResponse);
                }
            }

            public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
                getRequestStageDelegate.handleError((Exception)((Object)clientProtocolException));
            }

            public void handleHttpIOException(IOException iOException) {
                getRequestStageDelegate.handleError(iOException);
            }

            public void handleTransportException(GeneralSecurityException generalSecurityException) {
                getRequestStageDelegate.handleError(generalSecurityException);
            }

            public int connectionTimeout() {
                return 60000;
            }
        };
        return baseResource;
    }

    private void scheduleGetRequest(int n, final JPakeClient jPakeClient) {
        this.timerScheduler.schedule(new TimerTask(){

            public void run() {
                new GetRequestStage().execute(jPakeClient);
            }
        }, n);
    }

    public class GetStepTimerTask
    extends TimerTask {
        private Resource request;

        public GetStepTimerTask(Resource resource) {
            this.request = resource;
        }

        public void run() {
            this.request.get();
        }
    }

    private static interface GetRequestStageDelegate {
        public void handleSuccess(HttpResponse var1);

        public void handleFailure(String var1);

        public void handleError(Exception var1);
    }
}

