/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.delegates;

import java.util.concurrent.ExecutorService;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.RepositorySessionBundle;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;

public class DeferredRepositorySessionFinishDelegate
implements RepositorySessionFinishDelegate {
    protected final ExecutorService executor;
    protected final RepositorySessionFinishDelegate inner;

    public DeferredRepositorySessionFinishDelegate(RepositorySessionFinishDelegate repositorySessionFinishDelegate, ExecutorService executorService) {
        this.executor = executorService;
        this.inner = repositorySessionFinishDelegate;
    }

    public void onFinishSucceeded(final RepositorySession repositorySession, final RepositorySessionBundle repositorySessionBundle) {
        this.executor.execute(new Runnable(){

            public void run() {
                DeferredRepositorySessionFinishDelegate.this.inner.onFinishSucceeded(repositorySession, repositorySessionBundle);
            }
        });
    }

    public void onFinishFailed(final Exception exception) {
        this.executor.execute(new Runnable(){

            public void run() {
                DeferredRepositorySessionFinishDelegate.this.inner.onFinishFailed(exception);
            }
        });
    }

    public RepositorySessionFinishDelegate deferredFinishDelegate(ExecutorService executorService) {
        if (executorService == this.executor) {
            return this;
        }
        throw new IllegalArgumentException("Can't re-defer this delegate.");
    }
}

