/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.widget.ArrowPopup;
import org.mozilla.gecko.widget.DoorHanger;

public class SiteIdentityPopup
extends ArrowPopup {
    private static final String LOGTAG = "GeckoSiteIdentityPopup";
    private static final String MIXED_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/how-does-content-isnt-secure-affect-my-safety";
    private SiteIdentity mSiteIdentity;
    private Resources mResources;
    private LinearLayout mIdentity;
    private TextView mHost;
    private TextView mOwner;
    private TextView mVerifier;
    private DoorHanger mMixedContentNotification;
    private final DoorHanger.OnButtonClickListener mButtonClickListener;

    SiteIdentityPopup(BrowserApp browserApp) {
        super(browserApp);
        this.mResources = browserApp.getResources();
        this.mButtonClickListener = new PopupButtonListener();
    }

    protected void init() {
        super.init();
        this.setFocusable(true);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mActivity);
        this.mIdentity = (LinearLayout)layoutInflater.inflate(R.layout.site_identity, null);
        this.mContent.addView((View)this.mIdentity);
        this.mHost = (TextView)this.mIdentity.findViewById(R.id.host);
        this.mOwner = (TextView)this.mIdentity.findViewById(R.id.owner);
        this.mVerifier = (TextView)this.mIdentity.findViewById(R.id.verifier);
    }

    private void updateUi() {
        if (!this.mInflated) {
            this.init();
        }
        if (this.mSiteIdentity.getSecurityMode() == SiteIdentity.SecurityMode.MIXED_CONTENT_LOADED) {
            this.mContent.setPadding(0, (int)this.mResources.getDimension(R.dimen.identity_padding_top), 0, 0);
            this.mIdentity.setVisibility(8);
        } else {
            this.mHost.setText((CharSequence)this.mSiteIdentity.getHost());
            String string2 = this.mSiteIdentity.getOwner();
            String string3 = this.mSiteIdentity.getSupplemental();
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                string2 = string2 + "\n" + string3;
            }
            this.mOwner.setText((CharSequence)string2);
            String string4 = this.mSiteIdentity.getVerifier();
            String string5 = this.mSiteIdentity.getEncrypted();
            this.mVerifier.setText((CharSequence)(string4 + "\n" + string5));
            this.mContent.setPadding(0, 0, 0, 0);
            this.mIdentity.setVisibility(0);
        }
    }

    private void addMixedContentNotification(boolean bl) {
        this.removeMixedContentNotification();
        this.mMixedContentNotification = new DoorHanger((Context)this.mActivity, DoorHanger.Theme.DARK);
        String string2 = bl ? this.mActivity.getString(R.string.blocked_mixed_content_message_top) + "\n\n" + this.mActivity.getString(R.string.blocked_mixed_content_message_bottom) : this.mActivity.getString(R.string.loaded_mixed_content_message);
        this.mMixedContentNotification.setMessage(string2);
        this.mMixedContentNotification.addLink(this.mActivity.getString(R.string.learn_more), MIXED_CONTENT_SUPPORT_URL, "\n\n");
        if (bl) {
            this.mMixedContentNotification.setIcon(R.drawable.shield_doorhanger);
            this.mMixedContentNotification.addButton(this.mActivity.getString(R.string.disable_protection), "disable", this.mButtonClickListener);
            this.mMixedContentNotification.addButton(this.mActivity.getString(R.string.keep_blocking), "keepBlocking", this.mButtonClickListener);
        } else {
            this.mMixedContentNotification.setIcon(R.drawable.warning_doorhanger);
            this.mMixedContentNotification.addButton(this.mActivity.getString(R.string.enable_protection), "enable", this.mButtonClickListener);
        }
        this.mContent.addView((View)this.mMixedContentNotification);
    }

    private void removeMixedContentNotification() {
        if (this.mMixedContentNotification != null) {
            this.mContent.removeView((View)this.mMixedContentNotification);
            this.mMixedContentNotification = null;
        }
    }

    void setSiteIdentity(SiteIdentity siteIdentity) {
        this.mSiteIdentity = siteIdentity;
    }

    public void show() {
        if (this.mSiteIdentity == null) {
            Log.e((String)LOGTAG, (String)"Can't show site identity popup for undefined state");
            return;
        }
        SiteIdentity.SecurityMode securityMode = this.mSiteIdentity.getSecurityMode();
        if (securityMode == SiteIdentity.SecurityMode.UNKNOWN) {
            Log.e((String)LOGTAG, (String)"Can't show site identity popup in non-identified state");
            return;
        }
        this.updateUi();
        if (securityMode == SiteIdentity.SecurityMode.MIXED_CONTENT_LOADED || securityMode == SiteIdentity.SecurityMode.MIXED_CONTENT_BLOCKED) {
            this.addMixedContentNotification(securityMode == SiteIdentity.SecurityMode.MIXED_CONTENT_BLOCKED);
        }
        super.show();
    }

    public void dismiss() {
        super.dismiss();
        this.removeMixedContentNotification();
    }

    private class PopupButtonListener
    implements DoorHanger.OnButtonClickListener {
        private PopupButtonListener() {
        }

        public void onButtonClick(DoorHanger doorHanger, String string2) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("allowMixedContent", string2.equals("disable"));
                GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:Reload", jSONObject.toString());
                GeckoAppShell.sendEventToGecko(geckoEvent);
            }
            catch (JSONException jSONException) {
                Log.e((String)SiteIdentityPopup.LOGTAG, (String)"Exception creating message to enable/disable mixed content blocking", (Throwable)jSONException);
            }
            SiteIdentityPopup.this.dismiss();
        }
    }
}

