/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.DataSetObservable;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ActivityChooserModel
extends DataSetObservable {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = ActivityChooserModel.class.getSimpleName();
    private static final String TAG_HISTORICAL_RECORDS = "historical-records";
    private static final String TAG_HISTORICAL_RECORD = "historical-record";
    private static final String ATTRIBUTE_ACTIVITY = "activity";
    private static final String ATTRIBUTE_TIME = "time";
    private static final String ATTRIBUTE_WEIGHT = "weight";
    public static final String DEFAULT_HISTORY_FILE_NAME = "activity_choser_model_history.xml";
    public static final int DEFAULT_HISTORY_MAX_LENGTH = 50;
    private static final int DEFAULT_ACTIVITY_INFLATION = 5;
    private static final float DEFAULT_HISTORICAL_RECORD_WEIGHT = 1.0f;
    private static final String HISTORY_FILE_EXTENSION = ".xml";
    private static final int INVALID_INDEX = -1;
    private static final Object sRegistryLock = new Object();
    private static final Map<String, ActivityChooserModel> sDataModelRegistry = new HashMap<String, ActivityChooserModel>();
    private final Object mInstanceLock = new Object();
    private final List<ActivityResolveInfo> mActivities = new ArrayList<ActivityResolveInfo>();
    private final List<HistoricalRecord> mHistoricalRecords = new ArrayList<HistoricalRecord>();
    private int mApplicationsCount;
    private final Context mContext;
    private final String mHistoryFileName;
    private Intent mIntent;
    private ActivitySorter mActivitySorter = new DefaultSorter();
    private int mHistoryMaxSize = 50;
    private boolean mCanReadHistoricalData = true;
    private boolean mReadShareHistoryCalled = false;
    private boolean mHistoricalRecordsChanged = true;
    private boolean mReloadActivities = false;
    private OnChooseActivityListener mActivityChoserModelPolicy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivityChooserModel get(Context context, String string2) {
        Object object = sRegistryLock;
        synchronized (object) {
            ActivityChooserModel activityChooserModel = sDataModelRegistry.get(string2);
            if (activityChooserModel == null) {
                activityChooserModel = new ActivityChooserModel(context, string2);
                sDataModelRegistry.put(string2, activityChooserModel);
            }
            return activityChooserModel;
        }
    }

    private ActivityChooserModel(Context context, String string2) {
        this.mContext = context.getApplicationContext();
        this.mHistoryFileName = !TextUtils.isEmpty((CharSequence)string2) && !string2.endsWith(HISTORY_FILE_EXTENSION) ? string2 + HISTORY_FILE_EXTENSION : string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntent(Intent intent) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mIntent == intent) {
                return;
            }
            this.mIntent = intent;
            this.mReloadActivities = true;
            this.ensureConsistentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent getIntent() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mIntent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActivityCount() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mActivities.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveInfo getActivity(int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mActivities.get((int)n).resolveInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActivityIndex(ResolveInfo resolveInfo) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            List<ActivityResolveInfo> list = this.mActivities;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ActivityResolveInfo activityResolveInfo = list.get(i);
                if (activityResolveInfo.resolveInfo != resolveInfo) continue;
                return i;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent chooseActivity(int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Object object2;
            boolean bl;
            if (this.mIntent == null) {
                return null;
            }
            this.ensureConsistentState();
            ActivityResolveInfo activityResolveInfo = this.mActivities.get(n);
            ComponentName componentName = new ComponentName(activityResolveInfo.resolveInfo.activityInfo.packageName, activityResolveInfo.resolveInfo.activityInfo.name);
            Intent intent = new Intent(this.mIntent);
            intent.setComponent(componentName);
            if (this.mActivityChoserModelPolicy != null && (bl = this.mActivityChoserModelPolicy.onChooseActivity(this, (Intent)(object2 = new Intent(intent))))) {
                return null;
            }
            object2 = new HistoricalRecord(componentName, System.currentTimeMillis(), 1.0f);
            this.addHisoricalRecord((HistoricalRecord)object2);
            return intent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnChooseActivityListener(OnChooseActivityListener onChooseActivityListener) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mActivityChoserModelPolicy = onChooseActivityListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveInfo getDefaultActivity() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            if (!this.mActivities.isEmpty()) {
                return this.mActivities.get((int)0).resolveInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultActivity(int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            ActivityResolveInfo activityResolveInfo = this.mActivities.get(n);
            ActivityResolveInfo activityResolveInfo2 = this.mActivities.get(0);
            float f = activityResolveInfo2 != null ? activityResolveInfo2.weight - activityResolveInfo.weight + 5.0f : 1.0f;
            ComponentName componentName = new ComponentName(activityResolveInfo.resolveInfo.activityInfo.packageName, activityResolveInfo.resolveInfo.activityInfo.name);
            HistoricalRecord historicalRecord = new HistoricalRecord(componentName, System.currentTimeMillis(), f);
            this.addHisoricalRecord(historicalRecord);
        }
    }

    private void persistHistoricalDataIfNeeded() {
        if (!this.mReadShareHistoryCalled) {
            throw new IllegalStateException("No preceding call to #readHistoricalData");
        }
        if (!this.mHistoricalRecordsChanged) {
            return;
        }
        this.mHistoricalRecordsChanged = false;
        if (!TextUtils.isEmpty((CharSequence)this.mHistoryFileName)) {
            new PersistHistoryAsyncTask().executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Object[]{new ArrayList<HistoricalRecord>(this.mHistoricalRecords), this.mHistoryFileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivitySorter(ActivitySorter activitySorter) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mActivitySorter == activitySorter) {
                return;
            }
            this.mActivitySorter = activitySorter;
            if (this.sortActivitiesIfNeeded()) {
                this.notifyChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryMaxSize(int n) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mHistoryMaxSize == n) {
                return;
            }
            this.mHistoryMaxSize = n;
            this.pruneExcessiveHistoricalRecordsIfNeeded();
            if (this.sortActivitiesIfNeeded()) {
                this.notifyChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryMaxSize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mHistoryMaxSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistorySize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mHistoricalRecords.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDistinctActivityCountInHistory() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (HistoricalRecord historicalRecord : this.mHistoricalRecords) {
                String string2 = historicalRecord.activity.flattenToString();
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            return arrayList.size();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private void ensureConsistentState() {
        boolean bl = this.loadActivitiesIfNeeded();
        this.pruneExcessiveHistoricalRecordsIfNeeded();
        if (bl |= this.readHistoricalDataIfNeeded()) {
            this.sortActivitiesIfNeeded();
            this.notifyChanged();
        }
    }

    private boolean sortActivitiesIfNeeded() {
        if (this.mActivitySorter != null && this.mIntent != null && !this.mActivities.isEmpty() && !this.mHistoricalRecords.isEmpty()) {
            this.mActivitySorter.sort(this.mIntent, this.mActivities, Collections.unmodifiableList(this.mHistoricalRecords));
            return true;
        }
        return false;
    }

    private boolean loadActivitiesIfNeeded() {
        List list = this.mContext.getPackageManager().getInstalledApplications(0);
        if (list != null && list.size() != this.mApplicationsCount) {
            this.mApplicationsCount = list.size();
            this.mReloadActivities = true;
        }
        if (this.mReloadActivities && this.mIntent != null) {
            this.mReloadActivities = false;
            this.mActivities.clear();
            List list2 = this.mContext.getPackageManager().queryIntentActivities(this.mIntent, 0);
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                ResolveInfo resolveInfo = (ResolveInfo)list2.get(i);
                this.mActivities.add(new ActivityResolveInfo(resolveInfo));
            }
            return true;
        }
        return false;
    }

    private boolean readHistoricalDataIfNeeded() {
        if (this.mCanReadHistoricalData && this.mHistoricalRecordsChanged && !TextUtils.isEmpty((CharSequence)this.mHistoryFileName)) {
            this.mCanReadHistoricalData = false;
            this.mReadShareHistoryCalled = true;
            this.readHistoricalDataImpl();
            return true;
        }
        return false;
    }

    private boolean addHisoricalRecord(HistoricalRecord historicalRecord) {
        boolean bl = this.mHistoricalRecords.add(historicalRecord);
        if (bl) {
            this.mHistoricalRecordsChanged = true;
            this.pruneExcessiveHistoricalRecordsIfNeeded();
            this.persistHistoricalDataIfNeeded();
            this.sortActivitiesIfNeeded();
            this.notifyChanged();
        }
        return bl;
    }

    private void pruneExcessiveHistoricalRecordsIfNeeded() {
        int n = this.mHistoricalRecords.size() - this.mHistoryMaxSize;
        if (n <= 0) {
            return;
        }
        this.mHistoricalRecordsChanged = true;
        for (int i = 0; i < n; ++i) {
            HistoricalRecord historicalRecord = this.mHistoricalRecords.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHistoricalDataImpl() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = this.mContext.openFileInput(this.mHistoryFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        try {
            XmlPullParser xmlPullParser = Xml.newPullParser();
            xmlPullParser.setInput((InputStream)fileInputStream, null);
            int n = 0;
            while (n != 1 && n != 2) {
                n = xmlPullParser.next();
            }
            if (!TAG_HISTORICAL_RECORDS.equals(xmlPullParser.getName())) {
                throw new XmlPullParserException("Share records file does not start with historical-records tag.");
            }
            List<HistoricalRecord> list = this.mHistoricalRecords;
            list.clear();
            while ((n = xmlPullParser.next()) != 1) {
                if (n == 3 || n == 4) continue;
                String string2 = xmlPullParser.getName();
                if (!TAG_HISTORICAL_RECORD.equals(string2)) {
                    throw new XmlPullParserException("Share records file not well-formed.");
                }
                String string3 = xmlPullParser.getAttributeValue(null, ATTRIBUTE_ACTIVITY);
                long l = Long.parseLong(xmlPullParser.getAttributeValue(null, ATTRIBUTE_TIME));
                float f = Float.parseFloat(xmlPullParser.getAttributeValue(null, ATTRIBUTE_WEIGHT));
                HistoricalRecord historicalRecord = new HistoricalRecord(string3, l, f);
                list.add(historicalRecord);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            Log.e((String)LOG_TAG, (String)("Error reading historical recrod file: " + this.mHistoryFileName), (Throwable)xmlPullParserException);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)("Error reading historical recrod file: " + this.mHistoryFileName), (Throwable)iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PersistHistoryAsyncTask
    extends AsyncTask<Object, Void, Void> {
        private PersistHistoryAsyncTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void doInBackground(Object ... objectArray) {
            List list = (List)objectArray[0];
            String string2 = (String)objectArray[1];
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = ActivityChooserModel.this.mContext.openFileOutput(string2, 0);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.e((String)LOG_TAG, (String)("Error writing historical recrod file: " + string2), (Throwable)fileNotFoundException);
                return null;
            }
            XmlSerializer xmlSerializer = Xml.newSerializer();
            try {
                xmlSerializer.setOutput((OutputStream)fileOutputStream, null);
                xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
                xmlSerializer.startTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORDS);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    HistoricalRecord historicalRecord = (HistoricalRecord)list.remove(0);
                    xmlSerializer.startTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORD);
                    xmlSerializer.attribute(null, ActivityChooserModel.ATTRIBUTE_ACTIVITY, historicalRecord.activity.flattenToString());
                    xmlSerializer.attribute(null, ActivityChooserModel.ATTRIBUTE_TIME, String.valueOf(historicalRecord.time));
                    xmlSerializer.attribute(null, ActivityChooserModel.ATTRIBUTE_WEIGHT, String.valueOf(historicalRecord.weight));
                    xmlSerializer.endTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORD);
                }
                xmlSerializer.endTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORDS);
                xmlSerializer.endDocument();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)LOG_TAG, (String)("Error writing historical recrod file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)illegalArgumentException);
            }
            catch (IllegalStateException illegalStateException) {
                Log.e((String)LOG_TAG, (String)("Error writing historical recrod file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)illegalStateException);
            }
            catch (IOException iOException) {
                Log.e((String)LOG_TAG, (String)("Error writing historical recrod file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)iOException);
            }
            finally {
                ActivityChooserModel.this.mCanReadHistoricalData = true;
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultSorter
    implements ActivitySorter {
        private static final float WEIGHT_DECAY_COEFFICIENT = 0.95f;
        private final Map<String, ActivityResolveInfo> mPackageNameToActivityMap = new HashMap<String, ActivityResolveInfo>();

        private DefaultSorter() {
        }

        @Override
        public void sort(Intent intent, List<ActivityResolveInfo> list, List<HistoricalRecord> list2) {
            Object object;
            int n;
            Map<String, ActivityResolveInfo> map = this.mPackageNameToActivityMap;
            map.clear();
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                ActivityResolveInfo activityResolveInfo = list.get(n);
                activityResolveInfo.weight = 0.0f;
                ComponentName componentName = new ComponentName(activityResolveInfo.resolveInfo.activityInfo.packageName, activityResolveInfo.resolveInfo.activityInfo.name);
                object = componentName.flattenToString();
                map.put((String)object, activityResolveInfo);
            }
            n = list2.size() - 1;
            float f = 1.0f;
            for (int i = n; i >= 0; --i) {
                object = list2.get(i);
                String string2 = ((HistoricalRecord)object).activity.flattenToString();
                ActivityResolveInfo activityResolveInfo = map.get(string2);
                if (activityResolveInfo == null) continue;
                activityResolveInfo.weight += ((HistoricalRecord)object).weight * f;
                f *= 0.95f;
            }
            Collections.sort(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ActivityResolveInfo
    implements Comparable<ActivityResolveInfo> {
        public final ResolveInfo resolveInfo;
        public float weight;

        public ActivityResolveInfo(ResolveInfo resolveInfo) {
            this.resolveInfo = resolveInfo;
        }

        public int hashCode() {
            return 31 + Float.floatToIntBits(this.weight);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ActivityResolveInfo activityResolveInfo = (ActivityResolveInfo)object;
            return Float.floatToIntBits(this.weight) == Float.floatToIntBits(activityResolveInfo.weight);
        }

        @Override
        public int compareTo(ActivityResolveInfo activityResolveInfo) {
            return Float.floatToIntBits(activityResolveInfo.weight) - Float.floatToIntBits(this.weight);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append("resolveInfo:").append(this.resolveInfo.toString());
            stringBuilder.append("; weight:").append(new BigDecimal(this.weight));
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static final class HistoricalRecord {
        public final ComponentName activity;
        public final long time;
        public final float weight;

        public HistoricalRecord(String string2, long l, float f) {
            this(ComponentName.unflattenFromString((String)string2), l, f);
        }

        public HistoricalRecord(ComponentName componentName, long l, float f) {
            this.activity = componentName;
            this.time = l;
            this.weight = f;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.activity == null ? 0 : this.activity.hashCode());
            n = 31 * n + (int)(this.time ^ this.time >>> 32);
            n = 31 * n + Float.floatToIntBits(this.weight);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HistoricalRecord historicalRecord = (HistoricalRecord)object;
            if (this.activity == null ? historicalRecord.activity != null : !this.activity.equals((Object)historicalRecord.activity)) {
                return false;
            }
            if (this.time != historicalRecord.time) {
                return false;
            }
            return Float.floatToIntBits(this.weight) == Float.floatToIntBits(historicalRecord.weight);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append("; activity:").append(this.activity);
            stringBuilder.append("; time:").append(this.time);
            stringBuilder.append("; weight:").append(new BigDecimal(this.weight));
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static interface OnChooseActivityListener {
        public boolean onChooseActivity(ActivityChooserModel var1, Intent var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ActivitySorter {
        public void sort(Intent var1, List<ActivityResolveInfo> var2, List<HistoricalRecord> var3);
    }

    public static interface ActivityChooserModelClient {
        public void setActivityChooserModel(ActivityChooserModel var1);
    }
}

