/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.cookie;

import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.cookie.CookieSpec;
import ch.boye.httpclientandroidlib.cookie.CookieSpecFactory;
import ch.boye.httpclientandroidlib.params.HttpParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class CookieSpecRegistry {
    private final ConcurrentHashMap<String, CookieSpecFactory> registeredSpecs = new ConcurrentHashMap();

    public void register(String string, CookieSpecFactory cookieSpecFactory) {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (cookieSpecFactory == null) {
            throw new IllegalArgumentException("Cookie spec factory may not be null");
        }
        this.registeredSpecs.put(string.toLowerCase(Locale.ENGLISH), cookieSpecFactory);
    }

    public void unregister(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        this.registeredSpecs.remove(string.toLowerCase(Locale.ENGLISH));
    }

    public CookieSpec getCookieSpec(String string, HttpParams httpParams) throws IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        CookieSpecFactory cookieSpecFactory = this.registeredSpecs.get(string.toLowerCase(Locale.ENGLISH));
        if (cookieSpecFactory != null) {
            return cookieSpecFactory.newInstance(httpParams);
        }
        throw new IllegalStateException("Unsupported cookie spec: " + string);
    }

    public CookieSpec getCookieSpec(String string) throws IllegalStateException {
        return this.getCookieSpec(string, null);
    }

    public List<String> getSpecNames() {
        return new ArrayList<String>(this.registeredSpecs.keySet());
    }

    public void setItems(Map<String, CookieSpecFactory> map) {
        if (map == null) {
            return;
        }
        this.registeredSpecs.clear();
        this.registeredSpecs.putAll(map);
    }
}

