/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.auth;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.auth.AuthenticationException;
import ch.boye.httpclientandroidlib.auth.Credentials;
import ch.boye.httpclientandroidlib.auth.MalformedChallengeException;
import ch.boye.httpclientandroidlib.auth.params.AuthParams;
import ch.boye.httpclientandroidlib.impl.auth.RFC2617Scheme;
import ch.boye.httpclientandroidlib.impl.auth.UnsupportedDigestAlgorithmException;
import ch.boye.httpclientandroidlib.message.BasicHeaderValueFormatter;
import ch.boye.httpclientandroidlib.message.BasicNameValuePair;
import ch.boye.httpclientandroidlib.message.BufferedHeader;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;
import ch.boye.httpclientandroidlib.util.EncodingUtils;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import java.util.StringTokenizer;

@NotThreadSafe
public class DigestScheme
extends RFC2617Scheme {
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private boolean complete = false;
    private static final int QOP_UNKNOWN = -1;
    private static final int QOP_MISSING = 0;
    private static final int QOP_AUTH_INT = 1;
    private static final int QOP_AUTH = 2;
    private String lastNonce;
    private long nounceCount;
    private String cnonce;
    private String a1;
    private String a2;

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        if (this.getParameter("realm") == null) {
            throw new MalformedChallengeException("missing realm in challenge");
        }
        if (this.getParameter("nonce") == null) {
            throw new MalformedChallengeException("missing nonce in challenge");
        }
        this.complete = true;
    }

    public boolean isComplete() {
        String string = this.getParameter("stale");
        if ("true".equalsIgnoreCase(string)) {
            return false;
        }
        return this.complete;
    }

    public String getSchemeName() {
        return "digest";
    }

    public boolean isConnectionBased() {
        return false;
    }

    public void overrideParamter(String string, String string2) {
        this.getParameters().put(string, string2);
    }

    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.getParameters().put("methodname", httpRequest.getRequestLine().getMethod());
        this.getParameters().put("uri", httpRequest.getRequestLine().getUri());
        String string = this.getParameter("charset");
        if (string == null) {
            string = AuthParams.getCredentialCharset(httpRequest.getParams());
            this.getParameters().put("charset", string);
        }
        return this.createDigestHeader(credentials);
    }

    private static MessageDigest createMessageDigest(String string) throws UnsupportedDigestAlgorithmException {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw new UnsupportedDigestAlgorithmException("Unsupported algorithm in HTTP Digest authentication: " + string);
        }
    }

    private Header createDigestHeader(Credentials credentials) throws AuthenticationException {
        String string;
        String string2;
        MessageDigest messageDigest;
        String string3;
        Object object;
        String string4 = this.getParameter("uri");
        String string5 = this.getParameter("realm");
        String string6 = this.getParameter("nonce");
        String string7 = this.getParameter("opaque");
        String string8 = this.getParameter("methodname");
        String string9 = this.getParameter("algorithm");
        if (string4 == null) {
            throw new IllegalStateException("URI may not be null");
        }
        if (string5 == null) {
            throw new IllegalStateException("Realm may not be null");
        }
        if (string6 == null) {
            throw new IllegalStateException("Nonce may not be null");
        }
        int n = -1;
        String string10 = this.getParameter("qop");
        if (string10 != null) {
            object = new StringTokenizer(string10, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken().trim();
                if (!string3.equals("auth")) continue;
                n = 2;
                break;
            }
        } else {
            n = 0;
        }
        if (n == -1) {
            throw new AuthenticationException("None of the qop methods is supported: " + string10);
        }
        if (string9 == null) {
            string9 = "MD5";
        }
        if ((object = this.getParameter("charset")) == null) {
            object = "ISO-8859-1";
        }
        if ((string3 = string9).equalsIgnoreCase("MD5-sess")) {
            string3 = "MD5";
        }
        try {
            messageDigest = DigestScheme.createMessageDigest(string3);
        }
        catch (UnsupportedDigestAlgorithmException unsupportedDigestAlgorithmException) {
            throw new AuthenticationException("Unsuppported digest algorithm: " + string3);
        }
        String string11 = credentials.getUserPrincipal().getName();
        String string12 = credentials.getPassword();
        if (string6.equals(this.lastNonce)) {
            ++this.nounceCount;
        } else {
            this.nounceCount = 1L;
            this.cnonce = null;
            this.lastNonce = string6;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        Formatter formatter = new Formatter(stringBuilder, Locale.US);
        formatter.format("%08x", this.nounceCount);
        String string13 = stringBuilder.toString();
        if (this.cnonce == null) {
            this.cnonce = DigestScheme.createCnonce();
        }
        this.a1 = null;
        this.a2 = null;
        if (string9.equalsIgnoreCase("MD5-sess")) {
            stringBuilder.setLength(0);
            stringBuilder.append(string11).append(':').append(string5).append(':').append(string12);
            string2 = DigestScheme.encode(messageDigest.digest(EncodingUtils.getBytes(stringBuilder.toString(), (String)object)));
            stringBuilder.setLength(0);
            stringBuilder.append(string2).append(':').append(string6).append(':').append(this.cnonce);
            this.a1 = stringBuilder.toString();
        } else {
            stringBuilder.setLength(0);
            stringBuilder.append(string11).append(':').append(string5).append(':').append(string12);
            this.a1 = stringBuilder.toString();
        }
        string2 = DigestScheme.encode(messageDigest.digest(EncodingUtils.getBytes(this.a1, (String)object)));
        if (n == 2) {
            this.a2 = string8 + ':' + string4;
        } else {
            if (n == 1) {
                throw new AuthenticationException("qop-int method is not suppported");
            }
            this.a2 = string8 + ':' + string4;
        }
        String string14 = DigestScheme.encode(messageDigest.digest(EncodingUtils.getBytes(this.a2, (String)object)));
        if (n == 0) {
            stringBuilder.setLength(0);
            stringBuilder.append(string2).append(':').append(string6).append(':').append(string14);
            string = stringBuilder.toString();
        } else {
            stringBuilder.setLength(0);
            stringBuilder.append(string2).append(':').append(string6).append(':').append(string13).append(':').append(this.cnonce).append(':').append(n == 1 ? "auth-int" : "auth").append(':').append(string14);
            string = stringBuilder.toString();
        }
        String string15 = DigestScheme.encode(messageDigest.digest(EncodingUtils.getAsciiBytes(string)));
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(128);
        if (this.isProxy()) {
            charArrayBuffer.append("Proxy-Authorization");
        } else {
            charArrayBuffer.append("Authorization");
        }
        charArrayBuffer.append(": Digest ");
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(20);
        arrayList.add(new BasicNameValuePair("username", string11));
        arrayList.add(new BasicNameValuePair("realm", string5));
        arrayList.add(new BasicNameValuePair("nonce", string6));
        arrayList.add(new BasicNameValuePair("uri", string4));
        arrayList.add(new BasicNameValuePair("response", string15));
        if (n != 0) {
            arrayList.add(new BasicNameValuePair("qop", n == 1 ? "auth-int" : "auth"));
            arrayList.add(new BasicNameValuePair("nc", string13));
            arrayList.add(new BasicNameValuePair("cnonce", this.cnonce));
        }
        if (string9 != null) {
            arrayList.add(new BasicNameValuePair("algorithm", string9));
        }
        if (string7 != null) {
            arrayList.add(new BasicNameValuePair("opaque", string7));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            BasicNameValuePair basicNameValuePair = (BasicNameValuePair)arrayList.get(i);
            if (i > 0) {
                charArrayBuffer.append(", ");
            }
            boolean bl = "nc".equals(basicNameValuePair.getName()) || "qop".equals(basicNameValuePair.getName());
            BasicHeaderValueFormatter.DEFAULT.formatNameValuePair(charArrayBuffer, basicNameValuePair, !bl);
        }
        return new BufferedHeader(charArrayBuffer);
    }

    String getCnonce() {
        return this.cnonce;
    }

    String getA1() {
        return this.a1;
    }

    String getA2() {
        return this.a2;
    }

    private static String encode(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xF;
            int n3 = (byArray[i] & 0xF0) >> 4;
            cArray[i * 2] = HEXADECIMAL[n3];
            cArray[i * 2 + 1] = HEXADECIMAL[n2];
        }
        return new String(cArray);
    }

    public static String createCnonce() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        return DigestScheme.encode(byArray);
    }
}

