/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.accounts.Account;
import android.content.Context;
import android.util.Log;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;
import org.mozilla.gecko.util.EventDispatcher;
import org.mozilla.gecko.util.GeckoEventListener;

public final class FirefoxAccountsHelper
implements GeckoEventListener {
    public static final String LOGTAG = "FxAcctsHelper";
    public static boolean LOG_PERSONAL_INFORMATION = false;
    public static final String EVENT_CREATE = "FxAccount:Create";
    public static final String EVENT_LOGIN = "FxAccount:Login";
    public static final String EVENT_VERIFIED = "FxAccount:Verified";
    protected final Context mContext;

    public FirefoxAccountsHelper(Context context) {
        this.mContext = context;
        EventDispatcher eventDispatcher = GeckoAppShell.getEventDispatcher();
        if (eventDispatcher == null) {
            Log.e((String)LOGTAG, (String)"Gecko event dispatcher must not be null", (Throwable)new RuntimeException());
            return;
        }
        eventDispatcher.registerEventListener(EVENT_CREATE, (GeckoEventListener)this);
        eventDispatcher.registerEventListener(EVENT_LOGIN, (GeckoEventListener)this);
        eventDispatcher.registerEventListener(EVENT_VERIFIED, (GeckoEventListener)this);
    }

    public synchronized void uninit() {
        EventDispatcher eventDispatcher = GeckoAppShell.getEventDispatcher();
        if (eventDispatcher == null) {
            Log.e((String)LOGTAG, (String)"Gecko event dispatcher must not be null", (Throwable)new RuntimeException());
            return;
        }
        eventDispatcher.unregisterEventListener(EVENT_CREATE, (GeckoEventListener)this);
        eventDispatcher.unregisterEventListener(EVENT_LOGIN, (GeckoEventListener)this);
        eventDispatcher.unregisterEventListener(EVENT_VERIFIED, (GeckoEventListener)this);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        Log.i((String)LOGTAG, (String)("FirefoxAccountsHelper got event " + string2));
        if (!(EVENT_CREATE.equals(string2) || EVENT_LOGIN.equals(string2) || EVENT_VERIFIED.equals(string2))) {
            Log.e((String)LOGTAG, (String)("FirefoxAccountsHelper got unexpected event " + string2));
            return;
        }
        if (EVENT_CREATE.equals(string2)) {
            Log.i((String)LOGTAG, (String)("FirefoxAccountsHelper ignoring event " + string2));
            return;
        }
        try {
            Account account;
            JSONObject jSONObject2 = jSONObject.getJSONObject("data");
            if (jSONObject2 == null) {
                Log.e((String)LOGTAG, (String)"data must not be null");
                return;
            }
            if (LOG_PERSONAL_INFORMATION) {
                Log.w((String)LOGTAG, (String)("data: " + jSONObject2.toString()));
            }
            String string3 = jSONObject2.optString("email");
            String string4 = jSONObject2.optString("uid");
            String string5 = jSONObject2.optString("sessionToken");
            String string6 = jSONObject2.optString("kA");
            String string7 = jSONObject2.optString("kB");
            if (LOG_PERSONAL_INFORMATION) {
                Log.w((String)LOGTAG, (String)("email: " + string3));
                Log.w((String)LOGTAG, (String)("uid: " + string4));
                Log.w((String)LOGTAG, (String)("sessionToken: " + string5));
                Log.w((String)LOGTAG, (String)("kA: " + string6));
                Log.w((String)LOGTAG, (String)("kB: " + string7));
            }
            if ((account = FxAccountAuthenticator.addAccount(this.mContext, string3, string4, string5, string6, string7)) == null) {
                Log.e((String)LOGTAG, (String)"Got null adding FxAccount.");
                return;
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Got exception in handleMessage handling event " + string2), (Throwable)exception);
            return;
        }
    }
}

