/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.TabsPanel;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.widget.TwoWayView;

public class TabsTray
extends TwoWayView
implements TabsPanel.PanelView {
    private static final String LOGTAG = "GeckoTabsTray";
    private Context mContext;
    private TabsPanel mTabsPanel;
    private TabsAdapter mTabsAdapter;
    private List<View> mPendingClosedTabs;
    private int mCloseAnimationCount;
    private TabSwipeGestureListener mSwipeListener;
    private static final int ANIMATION_DURATION = 250;
    private static final String ABOUT_HOME = "about:home";
    private int mOriginalSize = 0;

    public TabsTray(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mCloseAnimationCount = 0;
        this.mPendingClosedTabs = new ArrayList<View>();
        this.setItemsCanFocus(true);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabsTray);
        boolean bl = typedArray.getInt(0, 0) == 1;
        typedArray.recycle();
        this.mTabsAdapter = new TabsAdapter(this.mContext, bl);
        this.setAdapter((ListAdapter)this.mTabsAdapter);
        this.mSwipeListener = new TabSwipeGestureListener();
        this.setOnTouchListener(this.mSwipeListener);
        this.setOnScrollListener(this.mSwipeListener.makeScrollListener());
        this.setRecyclerListener(new TwoWayView.RecyclerListener(){

            public void onMovedToScrapHeap(View view) {
                TabRow tabRow = (TabRow)view.getTag();
                tabRow.thumbnail.setImageDrawable(null);
                tabRow.close.setVisibility(0);
            }
        });
    }

    public ViewGroup getLayout() {
        return this;
    }

    public void setTabsPanel(TabsPanel tabsPanel) {
        this.mTabsPanel = tabsPanel;
    }

    public void show() {
        this.setVisibility(0);
        Tabs.getInstance().refreshThumbnails();
        Tabs.registerOnTabsChangedListener(this.mTabsAdapter);
        this.mTabsAdapter.refreshTabsData();
    }

    public void hide() {
        this.setVisibility(8);
        Tabs.unregisterOnTabsChangedListener(this.mTabsAdapter);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Tab:Screenshot:Cancel", ""));
        this.mTabsAdapter.clear();
    }

    public boolean shouldExpand() {
        return this.isVertical();
    }

    private void autoHidePanel() {
        this.mTabsPanel.autoHidePanel();
    }

    private boolean isVertical() {
        return this.getOrientation().compareTo(TwoWayView.Orientation.VERTICAL) == 0;
    }

    private void animateClose(View view, int n) {
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.attach(view, PropertyAnimator.Property.ALPHA, 0.0f);
        if (this.isVertical()) {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_X, n);
        } else {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_Y, n);
        }
        ++this.mCloseAnimationCount;
        this.mPendingClosedTabs.add(view);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
            }

            public void onPropertyAnimationEnd() {
                TabsTray.this.mCloseAnimationCount--;
                if (TabsTray.this.mCloseAnimationCount > 0) {
                    return;
                }
                for (View view : TabsTray.this.mPendingClosedTabs) {
                    TabsTray.this.animateFinishClose(view);
                }
                TabsTray.this.mPendingClosedTabs.clear();
            }
        });
        if (this.mTabsAdapter.getCount() == 1) {
            this.autoHidePanel();
        }
        propertyAnimator.start();
    }

    private void animateFinishClose(View view) {
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        boolean bl = this.isVertical();
        if (bl) {
            propertyAnimator.attach(view, PropertyAnimator.Property.HEIGHT, 1.0f);
        } else {
            propertyAnimator.attach(view, PropertyAnimator.Property.WIDTH, 1.0f);
        }
        TabRow tabRow = (TabRow)view.getTag();
        final int n = tabRow.id;
        if (this.mOriginalSize == 0) {
            this.mOriginalSize = bl ? view.getHeight() : view.getWidth();
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
            }

            public void onPropertyAnimationEnd() {
                Tabs tabs = Tabs.getInstance();
                Tab tab = tabs.getTab(n);
                tabs.closeTab(tab);
            }
        });
        propertyAnimator.start();
    }

    private void animateCancel(final View view) {
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.attach(view, PropertyAnimator.Property.ALPHA, 1.0f);
        if (this.isVertical()) {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        } else {
            propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_Y, 0.0f);
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
            }

            public void onPropertyAnimationEnd() {
                TabRow tabRow = (TabRow)view.getTag();
                tabRow.close.setVisibility(0);
            }
        });
        propertyAnimator.start();
    }

    private class TabSwipeGestureListener
    implements View.OnTouchListener {
        private static final float MIN_VELOCITY = 750.0f;
        private int mSwipeThreshold;
        private int mMinFlingVelocity;
        private int mMaxFlingVelocity;
        private VelocityTracker mVelocityTracker;
        private int mListWidth = 1;
        private int mListHeight = 1;
        private View mSwipeView = null;
        private int mSwipeViewPosition = -1;
        private Runnable mPendingCheckForTap;
        private float mSwipeStartX;
        private float mSwipeStartY;
        private boolean mSwiping = false;
        private boolean mEnabled = true;

        public TabSwipeGestureListener() {
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)TabsTray.this.getContext());
            this.mSwipeThreshold = viewConfiguration.getScaledTouchSlop();
            this.mMinFlingVelocity = (int)(TabsTray.this.getContext().getResources().getDisplayMetrics().density * 750.0f);
            this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        }

        public void setEnabled(boolean bl) {
            this.mEnabled = bl;
        }

        public TwoWayView.OnScrollListener makeScrollListener() {
            return new TwoWayView.OnScrollListener(){

                public void onScrollStateChanged(TwoWayView twoWayView, int n) {
                    TabSwipeGestureListener.this.setEnabled(n != 1);
                }

                public void onScroll(TwoWayView twoWayView, int n, int n2, int n3) {
                }
            };
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (!this.mEnabled) {
                return false;
            }
            if (this.mListWidth < 2 || this.mListHeight < 2) {
                this.mListWidth = TabsTray.this.getWidth();
                this.mListHeight = TabsTray.this.getHeight();
            }
            switch (motionEvent.getActionMasked()) {
                case 0: {
                    this.triggerCheckForTap();
                    float f = motionEvent.getRawX();
                    float f2 = motionEvent.getRawY();
                    this.mSwipeView = this.findViewAt(f, f2);
                    if (this.mSwipeView != null) {
                        this.mSwipeStartX = motionEvent.getRawX();
                        this.mSwipeStartY = motionEvent.getRawY();
                        this.mSwipeViewPosition = TabsTray.this.getPositionForView(this.mSwipeView);
                        this.mVelocityTracker = VelocityTracker.obtain();
                        this.mVelocityTracker.addMovement(motionEvent);
                    }
                    view.onTouchEvent(motionEvent);
                    return true;
                }
                case 1: {
                    if (this.mSwipeView == null) break;
                    this.cancelCheckForTap();
                    this.mSwipeView.setPressed(false);
                    if (!this.mSwiping) {
                        TabRow tabRow = (TabRow)this.mSwipeView.getTag();
                        Tabs.getInstance().selectTab(tabRow.id);
                        TabsTray.this.autoHidePanel();
                        break;
                    }
                    this.mVelocityTracker.addMovement(motionEvent);
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                    float f = Math.abs(this.mVelocityTracker.getXVelocity());
                    float f3 = Math.abs(this.mVelocityTracker.getYVelocity());
                    boolean bl = false;
                    boolean bl2 = false;
                    int n = 0;
                    if (TabsTray.this.isVertical()) {
                        float f4 = ViewHelper.getTranslationX(this.mSwipeView);
                        if (Math.abs(f4) > (float)(this.mListWidth / 2)) {
                            bl = true;
                            bl2 = f4 > 0.0f;
                        } else if ((float)this.mMinFlingVelocity <= f && f <= (float)this.mMaxFlingVelocity && f3 < f) {
                            bl = this.mSwiping && f4 * this.mVelocityTracker.getXVelocity() > 0.0f;
                            bl2 = this.mVelocityTracker.getXVelocity() > 0.0f;
                        }
                        n = bl2 ? this.mListWidth : -this.mListWidth;
                    } else {
                        float f5 = ViewHelper.getTranslationY(this.mSwipeView);
                        if (Math.abs(f5) > (float)(this.mListHeight / 2)) {
                            bl = true;
                            bl2 = f5 > 0.0f;
                        } else if ((float)this.mMinFlingVelocity <= f3 && f3 <= (float)this.mMaxFlingVelocity && f < f3) {
                            bl = this.mSwiping && f5 * this.mVelocityTracker.getYVelocity() > 0.0f;
                            bl2 = this.mVelocityTracker.getYVelocity() > 0.0f;
                        }
                        int n2 = n = bl2 ? this.mListHeight : -this.mListHeight;
                    }
                    if (bl) {
                        TabsTray.this.animateClose(this.mSwipeView, n);
                    } else {
                        TabsTray.this.animateCancel(this.mSwipeView);
                    }
                    this.mVelocityTracker = null;
                    this.mSwipeView = null;
                    this.mSwipeViewPosition = -1;
                    this.mSwipeStartX = 0.0f;
                    this.mSwipeStartY = 0.0f;
                    this.mSwiping = false;
                    break;
                }
                case 2: {
                    boolean bl;
                    if (this.mSwipeView == null) break;
                    this.mVelocityTracker.addMovement(motionEvent);
                    boolean bl3 = TabsTray.this.isVertical();
                    float f = motionEvent.getRawX() - this.mSwipeStartX;
                    float f6 = motionEvent.getRawY() - this.mSwipeStartY;
                    float f7 = bl3 ? f : f6;
                    boolean bl4 = Math.abs(f) > (float)this.mSwipeThreshold;
                    boolean bl5 = Math.abs(f6) > (float)this.mSwipeThreshold;
                    boolean bl6 = bl = bl3 ? bl4 : bl5;
                    if (bl4 || bl5) {
                        this.cancelCheckForTap();
                    }
                    if (bl) {
                        this.mSwiping = true;
                        TabsTray.this.requestDisallowInterceptTouchEvent(true);
                        TabRow tabRow = (TabRow)this.mSwipeView.getTag();
                        tabRow.close.setVisibility(4);
                        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                        motionEvent2.setAction(3 | motionEvent.getActionIndex() << 8);
                        TabsTray.this.onTouchEvent(motionEvent2);
                    }
                    if (!this.mSwiping) break;
                    if (bl3) {
                        ViewHelper.setTranslationX(this.mSwipeView, f7);
                    } else {
                        ViewHelper.setTranslationY(this.mSwipeView, f7);
                    }
                    ViewHelper.setAlpha(this.mSwipeView, Math.max(0.1f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(f7) / (float)(bl3 ? this.mListWidth : this.mListHeight))));
                    return true;
                }
            }
            return false;
        }

        private View findViewAt(float f, float f2) {
            Rect rect = new Rect();
            int[] nArray = new int[2];
            TabsTray.this.getLocationOnScreen(nArray);
            int n = (int)f - nArray[0];
            int n2 = (int)f2 - nArray[1];
            for (int i = 0; i < TabsTray.this.getChildCount(); ++i) {
                View view = TabsTray.this.getChildAt(i);
                view.getHitRect(rect);
                if (!rect.contains(n, n2)) continue;
                return view;
            }
            return null;
        }

        private void triggerCheckForTap() {
            if (this.mPendingCheckForTap == null) {
                this.mPendingCheckForTap = new CheckForTap();
            }
            TabsTray.this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
        }

        private void cancelCheckForTap() {
            if (this.mPendingCheckForTap == null) {
                return;
            }
            TabsTray.this.removeCallbacks(this.mPendingCheckForTap);
        }

        private class CheckForTap
        implements Runnable {
            private CheckForTap() {
            }

            public void run() {
                if (!TabSwipeGestureListener.this.mSwiping && TabSwipeGestureListener.this.mSwipeView != null && TabSwipeGestureListener.this.mEnabled) {
                    TabSwipeGestureListener.this.mSwipeView.setPressed(true);
                }
            }
        }
    }

    private class TabsAdapter
    extends BaseAdapter
    implements Tabs.OnTabsChangedListener {
        private Context mContext;
        private boolean mIsPrivate;
        private ArrayList<Tab> mTabs;
        private LayoutInflater mInflater;
        private View.OnClickListener mOnCloseClickListener;

        public TabsAdapter(Context context, boolean bl) {
            this.mContext = context;
            this.mInflater = LayoutInflater.from((Context)this.mContext);
            this.mIsPrivate = bl;
            this.mOnCloseClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    TabRow tabRow = (TabRow)view.getTag();
                    int n = TabsTray.this.isVertical() ? tabRow.info.getWidth() : tabRow.info.getHeight();
                    TabsTray.this.animateClose((View)tabRow.info, n);
                }
            };
        }

        public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
            switch (tabEvents) {
                case ADDED: {
                    this.refreshTabsData();
                    break;
                }
                case CLOSED: {
                    this.removeTab(tab);
                    break;
                }
                case SELECTED: {
                    this.updateSelectedPosition();
                }
                case UNSELECTED: 
                case THUMBNAIL: 
                case TITLE: {
                    View view = TabsTray.this.getChildAt(this.getPositionForTab(tab) - TabsTray.this.getFirstVisiblePosition());
                    if (view == null) {
                        return;
                    }
                    TabRow tabRow = (TabRow)view.getTag();
                    this.assignValues(tabRow, tab);
                }
            }
        }

        private void refreshTabsData() {
            this.mTabs = new ArrayList();
            Iterable<Tab> iterable = Tabs.getInstance().getTabsInOrder();
            for (Tab tab : iterable) {
                if (tab.isPrivate() != this.mIsPrivate) continue;
                this.mTabs.add(tab);
            }
            this.notifyDataSetChanged();
            this.updateSelectedPosition();
        }

        private void updateSelectedPosition() {
            int n = this.getPositionForTab(Tabs.getInstance().getSelectedTab());
            if (n != -1) {
                TabsTray.this.setSelection(n);
            }
            this.updateSelectedStyle(n);
        }

        private void updateSelectedStyle(int n) {
            for (int i = 0; i < this.getCount(); ++i) {
                TabsTray.this.setItemChecked(i, i == n);
            }
        }

        public void clear() {
            this.mTabs = null;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.mTabs == null ? 0 : this.mTabs.size();
        }

        public Tab getItem(int n) {
            return this.mTabs.get(n);
        }

        public long getItemId(int n) {
            return n;
        }

        private int getPositionForTab(Tab tab) {
            if (this.mTabs == null || tab == null) {
                return -1;
            }
            return this.mTabs.indexOf(tab);
        }

        private void removeTab(Tab tab) {
            if (tab.isPrivate() == this.mIsPrivate && this.mTabs != null) {
                this.mTabs.remove(tab);
                this.notifyDataSetChanged();
                int n = this.getPositionForTab(Tabs.getInstance().getSelectedTab());
                this.updateSelectedStyle(n);
            }
        }

        private void assignValues(TabRow tabRow, Tab tab) {
            if (tabRow == null || tab == null) {
                return;
            }
            tabRow.id = tab.getId();
            BitmapDrawable bitmapDrawable = tab.getThumbnail();
            if (bitmapDrawable != null) {
                tabRow.thumbnail.setImageDrawable((Drawable)bitmapDrawable);
            } else if (AboutPages.isAboutHome(tab.getURL())) {
                tabRow.thumbnail.setImageResource(R.drawable.abouthome_thumbnail);
            } else {
                tabRow.thumbnail.setImageResource(R.drawable.tab_thumbnail_default);
            }
            tabRow.title.setText((CharSequence)tab.getDisplayTitle());
            tabRow.close.setTag((Object)tabRow);
        }

        private void resetTransforms(View view) {
            ViewHelper.setAlpha(view, 1.0f);
            if (TabsTray.this.mOriginalSize == 0) {
                return;
            }
            if (TabsTray.this.isVertical()) {
                ViewHelper.setHeight(view, TabsTray.this.mOriginalSize);
                ViewHelper.setTranslationX(view, 0.0f);
            } else {
                ViewHelper.setWidth(view, TabsTray.this.mOriginalSize);
                ViewHelper.setTranslationY(view, 0.0f);
            }
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            TabRow tabRow;
            if (view == null) {
                view = this.mInflater.inflate(R.layout.tabs_row, null);
                tabRow = new TabRow(view);
                tabRow.close.setOnClickListener(this.mOnCloseClickListener);
                view.setTag((Object)tabRow);
            } else {
                tabRow = (TabRow)view.getTag();
                this.resetTransforms(view);
            }
            Tab tab = this.mTabs.get(n);
            this.assignValues(tabRow, tab);
            return view;
        }
    }

    private class TabRow {
        int id;
        TextView title;
        ImageView thumbnail;
        ImageButton close;
        ViewGroup info;

        public TabRow(View view) {
            this.info = (ViewGroup)view;
            this.title = (TextView)view.findViewById(R.id.title);
            this.thumbnail = (ImageView)view.findViewById(R.id.thumbnail);
            this.close = (ImageButton)view.findViewById(R.id.close);
        }
    }
}

