/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.announcements;

import java.net.URI;
import java.net.URISyntaxException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;

public class Announcement {
    private static final String LOG_TAG = "Announcement";
    private static final String KEY_ID = "id";
    private static final String KEY_TITLE = "title";
    private static final String KEY_URL = "url";
    private static final String KEY_TEXT = "text";
    private final int id;
    private final String title;
    private final URI uri;
    private final String text;

    public Announcement(int n, String string2, String string3, URI uRI) {
        this.id = n;
        this.title = string2;
        this.uri = uRI;
        this.text = string3;
    }

    public static Announcement parseAnnouncement(ExtendedJSONObject extendedJSONObject) throws URISyntaxException, IllegalArgumentException {
        Integer n = extendedJSONObject.getIntegerSafely(KEY_ID);
        if (n == null) {
            throw new IllegalArgumentException("No id provided in JSON.");
        }
        String string2 = extendedJSONObject.getString(KEY_TITLE);
        if (string2 == null || string2.trim().length() == 0) {
            throw new IllegalArgumentException("Missing or empty announcement title.");
        }
        String string3 = extendedJSONObject.getString(KEY_URL);
        if (string3 == null) {
            throw new IllegalArgumentException("Missing announcement URI.");
        }
        String string4 = extendedJSONObject.getString(KEY_TEXT);
        if (string4 == null) {
            throw new IllegalArgumentException("Missing announcement body.");
        }
        return new Announcement(n, string2, string4, new URI(string3));
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public URI getUri() {
        return this.uri;
    }

    public ExtendedJSONObject asJSON() {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put(KEY_ID, this.id);
        extendedJSONObject.put(KEY_TITLE, this.title);
        extendedJSONObject.put(KEY_URL, this.uri.toASCIIString());
        extendedJSONObject.put(KEY_TEXT, this.text);
        return extendedJSONObject;
    }

    public static boolean isValidAnnouncement(Announcement announcement) {
        URI uRI = announcement.getUri();
        if (uRI == null) {
            Logger.warn(LOG_TAG, "No URI: announcement not valid.");
            return false;
        }
        String string2 = uRI.getScheme();
        if (string2 == null) {
            Logger.warn(LOG_TAG, "Null scheme: announcement not valid.");
            return false;
        }
        if (!string2.equalsIgnoreCase("http") && !string2.equalsIgnoreCase("https")) {
            Logger.warn(LOG_TAG, "Scheme '" + string2 + "' forbidden: announcement not valid.");
            return false;
        }
        return true;
    }
}

