/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.db;

import android.database.Cursor;

public class CursorDumper {
    protected static String fixedWidth(int n, String string2) {
        if (string2 == null) {
            return CursorDumper.spaces(n);
        }
        int n2 = string2.length();
        if (n == n2) {
            return string2;
        }
        if (n > n2) {
            return string2 + CursorDumper.spaces(n - n2);
        }
        return string2.substring(0, n);
    }

    protected static String spaces(int n) {
        return "                                     ".substring(0, n);
    }

    protected static String dashes(int n) {
        return "-------------------------------------".substring(0, n);
    }

    public static void dumpCursor(Cursor cursor) {
        CursorDumper.dumpCursor(cursor, 18, "records");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dumpCursor(Cursor cursor, int n, String string2) {
        int n2 = cursor.getPosition();
        try {
            int n3;
            String[] stringArray = cursor.getColumnNames();
            int n4 = cursor.getColumnCount();
            for (n3 = 0; n3 < n4; ++n3) {
                System.out.print(CursorDumper.fixedWidth(n, stringArray[n3]) + " | ");
            }
            System.out.println("(" + cursor.getCount() + " " + string2 + ")");
            for (n3 = 0; n3 < n4; ++n3) {
                System.out.print(CursorDumper.dashes(n) + " | ");
            }
            System.out.println("");
            if (!cursor.moveToFirst()) {
                System.out.println("EMPTY");
                return;
            }
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                for (n3 = 0; n3 < n4; ++n3) {
                    System.out.print(CursorDumper.fixedWidth(n, cursor.getString(n3)) + " | ");
                }
                System.out.println("");
                cursor.moveToNext();
            }
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                System.out.print(CursorDumper.dashes(n + 3));
            }
            System.out.print(CursorDumper.dashes(n + 3 - 1));
            System.out.println("");
        }
        finally {
            cursor.moveToPosition(n2);
        }
    }
}

