/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import android.content.Context;
import java.io.File;
import java.util.HashMap;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.HealthReportDatabaseStorage;

public class HealthReportDatabases {
    private static final String LOG_TAG = "HealthReportDatabases";
    private Context context;
    private final HashMap<File, HealthReportDatabaseStorage> storages = new HashMap();

    public HealthReportDatabases(Context context) {
        this.context = context;
    }

    public synchronized HealthReportDatabaseStorage getDatabaseHelperForProfile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("No profile provided.");
        }
        if (this.storages.containsKey(file)) {
            return this.storages.get(file);
        }
        HealthReportDatabaseStorage healthReportDatabaseStorage = new HealthReportDatabaseStorage(this.context, file);
        this.storages.put(file, healthReportDatabaseStorage);
        return healthReportDatabaseStorage;
    }

    public synchronized void closeDatabaseHelpers() {
        for (HealthReportDatabaseStorage healthReportDatabaseStorage : this.storages.values()) {
            try {
                healthReportDatabaseStorage.close();
            }
            catch (Exception exception) {
                Logger.warn(LOG_TAG, "Failed to close database helper.", exception);
            }
        }
        this.storages.clear();
    }
}

