/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.net.Uri;
import org.mozilla.gecko.mozglue.RobocopTarget;

@RobocopTarget
public class BrowserContract {
    public static final String AUTHORITY = "org.mozilla.fennec.db.browser";
    public static final Uri AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.browser");
    public static final String PASSWORDS_AUTHORITY = "org.mozilla.fennec.db.passwords";
    public static final Uri PASSWORDS_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.passwords");
    public static final String FORM_HISTORY_AUTHORITY = "org.mozilla.fennec.db.formhistory";
    public static final Uri FORM_HISTORY_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.formhistory");
    public static final String TABS_AUTHORITY = "org.mozilla.fennec.db.tabs";
    public static final Uri TABS_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.tabs");
    public static final String HOME_AUTHORITY = "org.mozilla.fennec.db.home";
    public static final Uri HOME_AUTHORITY_URI = Uri.parse((String)"content://org.mozilla.fennec.db.home");
    public static final String PARAM_PROFILE = "profile";
    public static final String PARAM_PROFILE_PATH = "profilePath";
    public static final String PARAM_LIMIT = "limit";
    public static final String PARAM_IS_SYNC = "sync";
    public static final String PARAM_SHOW_DELETED = "show_deleted";
    public static final String PARAM_IS_TEST = "test";
    public static final String PARAM_INSERT_IF_NEEDED = "insert_if_needed";
    public static final String PARAM_INCREMENT_VISITS = "increment_visits";
    public static final String PARAM_EXPIRE_PRIORITY = "priority";

    public static String getFrecencySortOrder(boolean bl, boolean bl2) {
        String string2 = "(date - " + System.currentTimeMillis() + ") / 86400000";
        StringBuilder stringBuilder = new StringBuilder("visits * MAX(1, 100 * 225 / (" + string2 + "*" + string2 + " + 225)) ");
        if (bl) {
            stringBuilder.insert(0, "(CASE WHEN bookmark_id > -1 THEN 100 ELSE 0 END) + ");
        }
        stringBuilder.append(bl2 ? " ASC" : " DESC");
        return stringBuilder.toString();
    }

    @RobocopTarget
    public static final class HomeItems
    implements CommonColumns {
        public static final Uri CONTENT_FAKE_URI = Uri.withAppendedPath((Uri)HOME_AUTHORITY_URI, (String)"items/fake");
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)HOME_AUTHORITY_URI, (String)"items");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/homeitem";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/homeitem";
        public static final String DATASET_ID = "dataset_id";
        public static final String URL = "url";
        public static final String TITLE = "title";
        public static final String DESCRIPTION = "description";
        public static final String IMAGE_URL = "image_url";
        public static final String CREATED = "created";

        private HomeItems() {
        }
    }

    public static final class Clients {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)TABS_AUTHORITY_URI, (String)"clients");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/client";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/client";
        public static final String ROWID = "rowid";
        public static final String NAME = "name";
        public static final String GUID = "guid";
        public static final String LAST_MODIFIED = "last_modified";

        private Clients() {
        }
    }

    public static final class Tabs
    implements CommonColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)TABS_AUTHORITY_URI, (String)"tabs");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/tab";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/tab";
        public static final String TITLE = "title";
        public static final String URL = "url";
        public static final String CLIENT_GUID = "client_guid";
        public static final String HISTORY = "history";
        public static final String FAVICON = "favicon";
        public static final String LAST_USED = "last_used";
        public static final String POSITION = "position";

        private Tabs() {
        }
    }

    public static final class DeletedFormHistory
    implements DeletedColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)FORM_HISTORY_AUTHORITY_URI, (String)"deleted-formhistory");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/deleted-formhistory";

        private DeletedFormHistory() {
        }
    }

    public static final class FormHistory {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)FORM_HISTORY_AUTHORITY_URI, (String)"formhistory");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/formhistory";
        public static final String ID = "id";
        public static final String FIELD_NAME = "fieldname";
        public static final String VALUE = "value";
        public static final String TIMES_USED = "timesUsed";
        public static final String FIRST_USED = "firstUsed";
        public static final String LAST_USED = "lastUsed";
        public static final String GUID = "guid";

        private FormHistory() {
        }
    }

    public static final class DeletedPasswords
    implements DeletedColumns {
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/deleted-passwords";
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)PASSWORDS_AUTHORITY_URI, (String)"deleted-passwords");

        private DeletedPasswords() {
        }
    }

    public static final class Passwords {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)PASSWORDS_AUTHORITY_URI, (String)"passwords");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/passwords";
        public static final String ID = "id";
        public static final String HOSTNAME = "hostname";
        public static final String HTTP_REALM = "httpRealm";
        public static final String FORM_SUBMIT_URL = "formSubmitURL";
        public static final String USERNAME_FIELD = "usernameField";
        public static final String PASSWORD_FIELD = "passwordField";
        public static final String ENCRYPTED_USERNAME = "encryptedUsername";
        public static final String ENCRYPTED_PASSWORD = "encryptedPassword";
        public static final String ENC_TYPE = "encType";
        public static final String TIME_CREATED = "timeCreated";
        public static final String TIME_LAST_USED = "timeLastUsed";
        public static final String TIME_PASSWORD_CHANGED = "timePasswordChanged";
        public static final String TIMES_USED = "timesUsed";
        public static final String GUID = "guid";
        public static final int ENCTYPE_SDR = 1;

        private Passwords() {
        }
    }

    public static final class Schema {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"schema");
        public static final String VERSION = "version";

        private Schema() {
        }
    }

    @RobocopTarget
    public static final class Combined
    implements CommonColumns,
    URLColumns,
    HistoryColumns,
    FaviconColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"combined");
        public static final int DISPLAY_NORMAL = 0;
        public static final int DISPLAY_READER = 1;
        public static final String BOOKMARK_ID = "bookmark_id";
        public static final String HISTORY_ID = "history_id";
        public static final String DISPLAY = "display";

        private Combined() {
        }
    }

    @RobocopTarget
    public static final class History
    implements CommonColumns,
    URLColumns,
    HistoryColumns,
    FaviconColumns,
    SyncColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"history");
        public static final Uri CONTENT_OLD_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"history/old");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/browser-history";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/browser-history";

        private History() {
        }
    }

    @RobocopTarget
    public static final class Bookmarks
    implements CommonColumns,
    URLColumns,
    FaviconColumns,
    SyncColumns {
        public static final int FIXED_ROOT_ID = 0;
        public static final int FAKE_DESKTOP_FOLDER_ID = -1;
        public static final int FIXED_READING_LIST_ID = -2;
        public static final int FIXED_PINNED_LIST_ID = -3;
        public static final String MOBILE_FOLDER_GUID = "mobile";
        public static final String PLACES_FOLDER_GUID = "places";
        public static final String MENU_FOLDER_GUID = "menu";
        public static final String TAGS_FOLDER_GUID = "tags";
        public static final String TOOLBAR_FOLDER_GUID = "toolbar";
        public static final String UNFILED_FOLDER_GUID = "unfiled";
        public static final String READING_LIST_FOLDER_GUID = "readinglist";
        public static final String FAKE_DESKTOP_FOLDER_GUID = "desktop";
        public static final String PINNED_FOLDER_GUID = "pinned";
        public static final int TYPE_FOLDER = 0;
        public static final int TYPE_BOOKMARK = 1;
        public static final int TYPE_SEPARATOR = 2;
        public static final int TYPE_LIVEMARK = 3;
        public static final int TYPE_QUERY = 4;
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"bookmarks");
        public static final Uri PARENTS_CONTENT_URI = Uri.withAppendedPath((Uri)CONTENT_URI, (String)"parents");
        public static final Uri POSITIONS_CONTENT_URI = Uri.withAppendedPath((Uri)CONTENT_URI, (String)"positions");
        public static final long DEFAULT_POSITION = Long.MIN_VALUE;
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/bookmark";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/bookmark";
        public static final String TYPE = "type";
        public static final String PARENT = "parent";
        public static final String POSITION = "position";
        public static final String TAGS = "tags";
        public static final String DESCRIPTION = "description";
        public static final String KEYWORD = "keyword";

        private Bookmarks() {
        }
    }

    @RobocopTarget
    public static final class Thumbnails
    implements CommonColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"thumbnails");
        public static final String URL = "url";
        public static final String DATA = "data";

        private Thumbnails() {
        }
    }

    @RobocopTarget
    public static final class Favicons
    implements CommonColumns,
    DateSyncColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"favicons");
        public static final String URL = "url";
        public static final String DATA = "data";
        public static final String PAGE_URL = "page_url";

        private Favicons() {
        }
    }

    public static interface DeletedColumns {
        public static final String ID = "id";
        public static final String GUID = "guid";
        public static final String TIME_DELETED = "timeDeleted";
    }

    @RobocopTarget
    public static interface HistoryColumns {
        public static final String DATE_LAST_VISITED = "date";
        public static final String VISITS = "visits";
    }

    @RobocopTarget
    public static interface FaviconColumns {
        public static final String FAVICON = "favicon";
        public static final String FAVICON_ID = "favicon_id";
        public static final String FAVICON_URL = "favicon_url";
    }

    @RobocopTarget
    public static interface URLColumns {
        public static final String URL = "url";
        public static final String TITLE = "title";
    }

    @RobocopTarget
    public static interface SyncColumns
    extends DateSyncColumns {
        public static final String GUID = "guid";
        public static final String IS_DELETED = "deleted";
    }

    @RobocopTarget
    public static interface DateSyncColumns {
        public static final String DATE_CREATED = "created";
        public static final String DATE_MODIFIED = "modified";
    }

    @RobocopTarget
    public static interface CommonColumns {
        public static final String _ID = "_id";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpirePriority {
        NORMAL,
        AGGRESSIVE;

    }
}

