/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.SQLiteBridgeContentProvider;
import org.mozilla.gecko.sqlite.SQLiteBridge;

public class HomeProvider
extends SQLiteBridgeContentProvider {
    private static final String LOGTAG = "GeckoHomeProvider";
    private static int DB_VERSION = 1;
    private static String DB_FILENAME = "home.sqlite";
    private static final String TABLE_ITEMS = "items";
    static final int ITEMS_FAKE = 100;
    static final int ITEMS = 101;
    static final int ITEMS_ID = 102;
    static final UriMatcher URI_MATCHER = new UriMatcher(-1);

    public HomeProvider() {
        super(LOGTAG);
    }

    public String getType(Uri uri) {
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 100: {
                return "vnd.android.cursor.dir/homeitem";
            }
            case 101: {
                return "vnd.android.cursor.dir/homeitem";
            }
        }
        throw new UnsupportedOperationException("Unknown type " + uri);
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        int n = URI_MATCHER.match(uri);
        if (n == 100) {
            return this.queryFakeItems(uri, stringArray, string2, stringArray2, string3);
        }
        return super.query(uri, stringArray, string2, stringArray2, string3);
    }

    private Cursor queryFakeItems(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        JSONArray jSONArray = null;
        try {
            jSONArray = new JSONArray(this.getRawFakeItems());
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error getting fake home items", (Throwable)iOException);
            return null;
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error parsing fake_home_items.json", (Throwable)jSONException);
            return null;
        }
        String[] stringArray3 = new String[]{"_id", "dataset_id", "url", "title", "description"};
        MatrixCursor matrixCursor = new MatrixCursor(stringArray3);
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                matrixCursor.addRow(new Object[]{jSONObject.getInt("id"), jSONObject.getString("dataset_id"), jSONObject.getString("url"), jSONObject.getString("title"), jSONObject.getString("description")});
                continue;
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error creating cursor row for fake home item", (Throwable)jSONException);
            }
        }
        return matrixCursor;
    }

    private String getRawFakeItems() throws IOException {
        int n;
        InputStream inputStream = this.getContext().getResources().openRawResource(R.raw.fake_home_items);
        byte[] byArray = new byte[1024];
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read(byArray)) != -1) {
            stringBuilder.append(new String(byArray, 0, n));
        }
        return stringBuilder.toString();
    }

    protected String getDBName() {
        return DB_FILENAME;
    }

    protected int getDBVersion() {
        return DB_VERSION;
    }

    public String getTable(Uri uri) {
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 101: {
                return TABLE_ITEMS;
            }
        }
        throw new UnsupportedOperationException("Unknown table " + uri);
    }

    public String getSortOrder(Uri uri, String string2) {
        return null;
    }

    public void setupDefaults(Uri uri, ContentValues contentValues) {
    }

    public void initGecko() {
    }

    public void onPreInsert(ContentValues contentValues, Uri uri, SQLiteBridge sQLiteBridge) {
    }

    public void onPreUpdate(ContentValues contentValues, Uri uri, SQLiteBridge sQLiteBridge) {
    }

    public void onPostQuery(Cursor cursor, Uri uri, SQLiteBridge sQLiteBridge) {
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.db.home", "items/fake", 100);
        URI_MATCHER.addURI("org.mozilla.fennec.db.home", TABLE_ITEMS, 101);
        URI_MATCHER.addURI("org.mozilla.fennec.db.home", "items/#", 102);
    }
}

