/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.AccountAuthenticatorActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.View;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountAgeLockoutHelper;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountActivity;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountNotAllowedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;

public class FxAccountGetStartedActivity
extends AccountAuthenticatorActivity {
    protected static final String LOG_TAG = FxAccountGetStartedActivity.class.getSimpleName();
    private static final int CHILD_REQUEST_CODE = 1;

    public void onCreate(Bundle bundle) {
        Logger.setThreadLogTag("FxAccounts");
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_get_started);
        View view = this.findViewById(R.id.get_started_button);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent((Context)FxAccountGetStartedActivity.this, FxAccountCreateAccountActivity.class);
                intent.setFlags(65536);
                FxAccountGetStartedActivity.this.startActivityForResult(intent, 1);
            }
        });
    }

    public void onResume() {
        super.onResume();
        Intent intent = null;
        if (FxAccountAgeLockoutHelper.isLockedOut(SystemClock.elapsedRealtime())) {
            intent = new Intent((Context)this, FxAccountCreateAccountNotAllowedActivity.class);
        } else if (FxAccountAuthenticator.firefoxAccountsExist((Context)this)) {
            intent = new Intent((Context)this, FxAccountStatusActivity.class);
        }
        if (intent != null) {
            this.setAccountAuthenticatorResult(null);
            this.setResult(0);
            intent.setFlags(65536);
            this.startActivity(intent);
            this.finish();
            return;
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        Logger.debug(LOG_TAG, "onActivityResult: " + n);
        if (n != 1) {
            super.onActivityResult(n, n2, intent);
            return;
        }
        if (intent != null) {
            this.setAccountAuthenticatorResult(intent.getExtras());
        }
        this.setResult(n, intent);
    }
}

