/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.accounts.Account;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SyncResult;
import android.os.Bundle;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.SkewHandler;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.RSACryptoImplementation;
import org.mozilla.gecko.browserid.verifier.BrowserIDRemoteVerifierClient;
import org.mozilla.gecko.browserid.verifier.BrowserIDVerifierDelegate;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.FxAccountLoginStateMachine;
import org.mozilla.gecko.fxa.login.FxAccountLoginTransition;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.sync.FxAccountGlobalSession;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.SharedPreferencesClientsDataDelegate;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.delegates.BaseGlobalSessionCallback;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.HawkAuthHeaderProvider;
import org.mozilla.gecko.sync.stage.GlobalSyncStage;
import org.mozilla.gecko.tokenserver.TokenServerClient;
import org.mozilla.gecko.tokenserver.TokenServerClientDelegate;
import org.mozilla.gecko.tokenserver.TokenServerException;
import org.mozilla.gecko.tokenserver.TokenServerToken;

public class FxAccountSyncAdapter
extends AbstractThreadedSyncAdapter {
    private static final String LOG_TAG = FxAccountSyncAdapter.class.getSimpleName();
    protected final ExecutorService executor = Executors.newSingleThreadExecutor();

    public FxAccountSyncAdapter(Context context, boolean bl) {
        super(context, bl);
    }

    protected void syncWithAssertion(final String string2, final String string3, URI uRI, String string4, final SharedPreferences sharedPreferences, final KeyBundle keyBundle, final BaseGlobalSessionCallback baseGlobalSessionCallback) {
        TokenServerClient tokenServerClient = new TokenServerClient(uRI, this.executor);
        tokenServerClient.getTokenFromBrowserIDAssertion(string3, true, new TokenServerClientDelegate(){

            public void handleSuccess(TokenServerToken tokenServerToken) {
                FxAccountConstants.pii(LOG_TAG, "Got token! uid is " + tokenServerToken.uid + " and endpoint is " + tokenServerToken.endpoint + ".");
                FxAccountGlobalSession fxAccountGlobalSession = null;
                try {
                    SharedPreferencesClientsDataDelegate sharedPreferencesClientsDataDelegate = new SharedPreferencesClientsDataDelegate(sharedPreferences);
                    SkewHandler skewHandler = SkewHandler.getSkewHandlerFromEndpointString(tokenServerToken.endpoint);
                    long l = skewHandler.getSkewInSeconds();
                    HawkAuthHeaderProvider hawkAuthHeaderProvider = new HawkAuthHeaderProvider(tokenServerToken.id, tokenServerToken.key.getBytes("UTF-8"), false, l);
                    Context context = FxAccountSyncAdapter.this.getContext();
                    SyncConfiguration syncConfiguration = new SyncConfiguration(tokenServerToken.uid, (AuthHeaderProvider)hawkAuthHeaderProvider, sharedPreferences, keyBundle);
                    Bundle bundle = Bundle.EMPTY;
                    fxAccountGlobalSession = new FxAccountGlobalSession(tokenServerToken.endpoint, syncConfiguration, baseGlobalSessionCallback, context, bundle, sharedPreferencesClientsDataDelegate);
                    fxAccountGlobalSession.start();
                }
                catch (Exception exception) {
                    baseGlobalSessionCallback.handleError(fxAccountGlobalSession, exception);
                    return;
                }
            }

            public void handleFailure(TokenServerException tokenServerException) {
                FxAccountSyncAdapter.this.debugAssertion(string2, string3);
                this.handleError(tokenServerException);
            }

            public void handleError(Exception exception) {
                Logger.error(LOG_TAG, "Failed to get token.", exception);
                baseGlobalSessionCallback.handleError(null, exception);
            }
        });
    }

    public void onPerformSync(Account account, Bundle bundle, String string2, ContentProviderClient contentProviderClient, SyncResult syncResult) {
        Logger.setThreadLogTag("FxAccounts");
        Logger.resetLogging();
        Logger.info(LOG_TAG, "Syncing FxAccount account named " + account.name + " for authority " + string2 + " with instance " + (Object)((Object)this) + ".");
        Context context = this.getContext();
        final AndroidFxAccount androidFxAccount = new AndroidFxAccount(context, account);
        if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
            androidFxAccount.dump();
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        final SessionCallback sessionCallback = new SessionCallback(countDownLatch, syncResult, androidFxAccount);
        try {
            State state;
            try {
                state = androidFxAccount.getState();
            }
            catch (Exception exception) {
                sessionCallback.handleError(null, exception);
                return;
            }
            final String string3 = androidFxAccount.getSyncPrefsPath();
            final SharedPreferences sharedPreferences = context.getSharedPreferences(string3, 0);
            final String string4 = androidFxAccount.getAudience();
            String string5 = androidFxAccount.getAccountServerURI();
            final String string6 = androidFxAccount.getTokenServerURI();
            final URI uRI = new URI(string6);
            final FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string5, this.executor);
            FxAccountLoginStateMachine fxAccountLoginStateMachine = new FxAccountLoginStateMachine();
            fxAccountLoginStateMachine.advance(state, State.StateLabel.Married, new FxAccountLoginStateMachine.LoginStateMachineDelegate(){

                public FxAccountClient getClient() {
                    return fxAccountClient20;
                }

                public long getCertificateDurationInMilliseconds() {
                    return 3600000L;
                }

                public long getAssertionDurationInMilliseconds() {
                    return 900000L;
                }

                public BrowserIDKeyPair generateKeyPair() throws NoSuchAlgorithmException {
                    return RSACryptoImplementation.generateKeyPair(1024);
                }

                public void handleTransition(FxAccountLoginTransition.Transition transition, State state) {
                    Logger.warn(LOG_TAG, "handleTransition: " + transition + " to " + state);
                }

                public void handleFinal(State state) {
                    Logger.warn(LOG_TAG, "handleFinal: in " + state);
                    androidFxAccount.setState(state);
                    try {
                        if (state.getStateLabel() != State.StateLabel.Married) {
                            sessionCallback.handleError(null, new RuntimeException("Cannot sync from state: " + state));
                            return;
                        }
                        Married married = (Married)state;
                        long l = System.currentTimeMillis();
                        SkewHandler skewHandler = SkewHandler.getSkewHandlerFromEndpointString(string6);
                        String string2 = married.generateAssertion(string4, "127.0.0.1", l + skewHandler.getSkewInMillis(), this.getAssertionDurationInMilliseconds());
                        FxAccountSyncAdapter.this.syncWithAssertion(string4, string2, uRI, string3, sharedPreferences, married.getSyncKeyBundle(), sessionCallback);
                    }
                    catch (Exception exception) {
                        sessionCallback.handleError(null, exception);
                        return;
                    }
                }
            });
            countDownLatch.await();
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Got error syncing.", exception);
            sessionCallback.handleError(null, exception);
        }
        Logger.error(LOG_TAG, "Syncing done.");
    }

    protected void debugAssertion(String string2, String string3) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        BrowserIDRemoteVerifierClient browserIDRemoteVerifierClient = new BrowserIDRemoteVerifierClient(URI.create("https://verifier.login.persona.org/verify"));
        browserIDRemoteVerifierClient.verify(string2, string3, new BrowserIDVerifierDelegate(){

            public void handleSuccess(ExtendedJSONObject extendedJSONObject) {
                Logger.info(LOG_TAG, "Remote verifier returned success: " + extendedJSONObject.toJSONString());
                countDownLatch.countDown();
            }

            public void handleFailure(ExtendedJSONObject extendedJSONObject) {
                Logger.warn(LOG_TAG, "Remote verifier returned failure: " + extendedJSONObject.toJSONString());
                countDownLatch.countDown();
            }

            public void handleError(Exception exception) {
                Logger.error(LOG_TAG, "Remote verifier returned error.", exception);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Logger.error(LOG_TAG, "Got error.", interruptedException);
        }
    }

    protected static class SessionCallback
    implements BaseGlobalSessionCallback {
        protected final CountDownLatch latch;
        protected final SyncResult syncResult;
        protected final AndroidFxAccount fxAccount;

        public SessionCallback(CountDownLatch countDownLatch, SyncResult syncResult, AndroidFxAccount androidFxAccount) {
            if (countDownLatch == null) {
                throw new IllegalArgumentException("latch must not be null");
            }
            if (syncResult == null) {
                throw new IllegalArgumentException("syncResult must not be null");
            }
            if (androidFxAccount == null) {
                throw new IllegalArgumentException("fxAccount must not be null");
            }
            this.latch = countDownLatch;
            this.syncResult = syncResult;
            this.fxAccount = androidFxAccount;
        }

        public boolean shouldBackOff() {
            return false;
        }

        public void requestBackoff(long l) {
        }

        public void informUpgradeRequiredResponse(GlobalSession globalSession) {
        }

        public void informUnauthorizedResponse(GlobalSession globalSession, URI uRI) {
        }

        public void handleStageCompleted(GlobalSyncStage.Stage stage, GlobalSession globalSession) {
        }

        protected void setSyncResultSuccess() {
            ++this.syncResult.stats.numUpdates;
        }

        protected void setSyncResultSoftError() {
            ++this.syncResult.stats.numUpdates;
            ++this.syncResult.stats.numIoExceptions;
        }

        protected void setSyncResultHardError() {
            ++this.syncResult.stats.numAuthExceptions;
        }

        public void handleSuccess(GlobalSession globalSession) {
            this.setSyncResultSuccess();
            Logger.info(LOG_TAG, "Sync succeeded.");
            this.latch.countDown();
        }

        public void handleError(GlobalSession globalSession, Exception exception) {
            State state;
            if (exception instanceof TokenServerException && (state = this.fxAccount.getState()).getStateLabel() == State.StateLabel.Married) {
                Married married = (Married)state;
                this.fxAccount.setState(married.makeCohabitingState());
            }
            this.setSyncResultSoftError();
            Logger.warn(LOG_TAG, "Sync failed.", exception);
            this.latch.countDown();
        }

        public void handleAborted(GlobalSession globalSession, String string2) {
            this.setSyncResultSoftError();
            Logger.warn(LOG_TAG, "Sync aborted: " + string2);
            this.latch.countDown();
        }
    }
}

