/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.mozilla.gecko.gfx.BufferedCairoImage;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.gfx.SingleTileLayer;
import org.mozilla.gecko.mozglue.DirectBufferAllocator;

public class TextLayer
extends SingleTileLayer {
    private final ByteBuffer mBuffer;
    private final IntSize mSize;

    private TextLayer(ByteBuffer byteBuffer, BufferedCairoImage bufferedCairoImage, IntSize intSize, String string2) {
        super(false, bufferedCairoImage);
        this.mBuffer = byteBuffer;
        this.mSize = intSize;
        this.renderText(string2);
    }

    public static TextLayer create(IntSize intSize, String string2) {
        ByteBuffer byteBuffer = DirectBufferAllocator.allocate((int)(intSize.width * intSize.height * 4));
        BufferedCairoImage bufferedCairoImage = new BufferedCairoImage(byteBuffer, intSize.width, intSize.height, 0);
        return new TextLayer(byteBuffer, bufferedCairoImage, intSize, string2);
    }

    public void setText(String string2) {
        this.renderText(string2);
        this.invalidate();
    }

    private void renderText(String string2) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.mSize.width, (int)this.mSize.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(-1);
        paint.setFakeBoldText(true);
        paint.setTextSize(18.0f);
        paint.setTypeface(Typeface.DEFAULT_BOLD);
        float f = paint.measureText(string2) + 18.0f;
        Paint paint2 = new Paint();
        paint2.setColor(Color.argb((int)127, (int)0, (int)0, (int)0));
        canvas.drawRect(0.0f, 0.0f, f, 24.0f, paint2);
        canvas.drawText(string2, 6.0f, 18.0f, paint);
        bitmap.copyPixelsToBuffer((Buffer)this.mBuffer.asIntBuffer());
    }
}

