/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.TextView;
import org.mozilla.gecko.R;

public class FadedTextView
extends TextView {
    private int mFadeWidth;
    private int mCompoundPadding;

    public FadedTextView(Context context) {
        this(context, null);
    }

    public FadedTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842884);
    }

    public FadedTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.FadedTextView);
        this.mFadeWidth = typedArray.getDimensionPixelSize(0, 0);
        typedArray.recycle();
        this.mCompoundPadding = this.getCompoundDrawablePadding();
    }

    public void onDraw(Canvas canvas) {
        int n = this.getMeasuredWidth();
        if (this.getLayout().getLineWidth(0) > (float)n) {
            Drawable drawable2 = this.getCompoundDrawables()[0];
            int n2 = 0;
            if (drawable2 != null) {
                n2 = drawable2.getIntrinsicWidth() + this.mCompoundPadding;
                n -= n2;
            }
            int n3 = this.getCurrentTextColor();
            float f = (float)(n - this.mFadeWidth) / (float)n;
            LinearGradient linearGradient = new LinearGradient(0.0f, 0.0f, (float)n, 0.0f, new int[]{n3, n3, 0}, new float[]{0.0f, f, 1.0f - (float)(n2 / n)}, Shader.TileMode.CLAMP);
            this.getPaint().setShader((Shader)linearGradient);
        } else {
            this.getPaint().setShader(null);
        }
        super.onDraw(canvas);
    }
}

