/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.util.Log;
import android.view.View;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.PanelLayout;

class FramePanelLayout
extends PanelLayout {
    private static final String LOGTAG = "GeckoFramePanelLayout";
    private final View mChildView;
    private final HomeConfig.ViewConfig mChildConfig;

    public FramePanelLayout(Context context, HomeConfig.PanelConfig panelConfig, PanelLayout.DatasetHandler datasetHandler) {
        super(context, panelConfig, datasetHandler);
        this.mChildConfig = panelConfig.getViewAt(0);
        if (this.mChildConfig == null) {
            throw new IllegalStateException("FramePanelLayout requires a view in PanelConfig");
        }
        this.mChildView = this.createPanelView(this.mChildConfig);
        this.addView(this.mChildView);
    }

    public void load() {
        Log.d((String)LOGTAG, (String)"Loading");
        if (this.mChildView instanceof PanelLayout.DatasetBacked) {
            Log.d((String)LOGTAG, (String)("Requesting child dataset: " + this.mChildConfig.getDatasetId()));
            this.requestDataset(this.mChildConfig.getDatasetId());
        }
    }
}

