/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.home.HomeAdapter;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeConfigLoader;
import org.mozilla.gecko.home.HomePagerTabStrip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePager
extends ViewPager {
    private static final int LOADER_ID_CONFIG = 0;
    private final Context mContext;
    private volatile boolean mLoaded;
    private Decor mDecor;
    private View mTabStrip;
    private final HomeAdapter.OnAddPanelListener mAddPanelListener;
    private final HomeConfig mConfig;
    private ConfigLoaderCallbacks mConfigLoaderCallbacks;
    private String mInitialPanelId;
    private boolean mRestartLoader;
    static final String LIST_TAG_HISTORY = "history";
    static final String LIST_TAG_BOOKMARKS = "bookmarks";
    static final String LIST_TAG_READING_LIST = "reading_list";
    static final String LIST_TAG_TOP_SITES = "top_sites";
    static final String LIST_TAG_MOST_RECENT = "most_recent";
    static final String LIST_TAG_LAST_TABS = "last_tabs";
    static final String LIST_TAG_BROWSER_SEARCH = "browser_search";
    static final String CAN_LOAD_ARG = "canLoad";
    static final String PANEL_CONFIG_ARG = "panelConfig";

    public HomePager(Context context) {
        this(context, null);
    }

    public HomePager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mConfig = HomeConfig.getDefault(this.mContext);
        this.mConfigLoaderCallbacks = new ConfigLoaderCallbacks();
        this.mAddPanelListener = new HomeAdapter.OnAddPanelListener(){

            public void onAddPanel(String string2) {
                if (HomePager.this.mDecor != null) {
                    HomePager.this.mDecor.onAddPagerView(string2);
                }
            }
        };
        this.setOffscreenPageLimit(3);
        this.setFocusableInTouchMode(true);
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (view instanceof Decor) {
            ((ViewPager.LayoutParams)layoutParams).isDecor = true;
            this.mDecor = (Decor)view;
            this.mTabStrip = view;
            this.mDecor.setOnTitleClickListener(new OnTitleClickListener(){

                public void onTitleClicked(int n) {
                    HomePager.this.setCurrentItem(n, true);
                }
            });
            this.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                public void onPageSelected(int n) {
                    HomePager.this.mDecor.onPageSelected(n);
                }

                public void onPageScrolled(int n, float f, int n2) {
                    HomePager.this.mDecor.onPageScrolled(n, f, n2);
                }

                public void onPageScrollStateChanged(int n) {
                }
            });
        } else if (view instanceof HomePagerTabStrip) {
            this.mTabStrip = view;
        }
        super.addView(view, n, layoutParams);
    }

    public void invalidate(LoaderManager loaderManager, FragmentManager fragmentManager) {
        this.mRestartLoader = true;
        if (this.isVisible()) {
            this.redisplay(loaderManager, fragmentManager);
        }
    }

    private void redisplay(LoaderManager loaderManager, FragmentManager fragmentManager) {
        HomeAdapter homeAdapter = (HomeAdapter)this.getAdapter();
        String string2 = this.mInitialPanelId != null ? this.mInitialPanelId : homeAdapter.getPanelIdAtPosition(this.getCurrentItem());
        this.show(loaderManager, fragmentManager, string2, null);
    }

    public void show(LoaderManager loaderManager, FragmentManager fragmentManager, String string2, PropertyAnimator propertyAnimator) {
        this.mLoaded = true;
        this.mInitialPanelId = string2;
        boolean bl = propertyAnimator != null && Build.VERSION.SDK_INT >= 11;
        final HomeAdapter homeAdapter = new HomeAdapter(this.mContext, fragmentManager);
        homeAdapter.setOnAddPanelListener(this.mAddPanelListener);
        homeAdapter.setCanLoadHint(!bl);
        this.setAdapter((PagerAdapter)homeAdapter);
        this.setVisibility(0);
        this.mTabStrip.setVisibility(4);
        if (this.mRestartLoader) {
            loaderManager.restartLoader(0, null, (LoaderManager.LoaderCallbacks)this.mConfigLoaderCallbacks);
            this.mRestartLoader = false;
        } else {
            loaderManager.initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mConfigLoaderCallbacks);
        }
        if (bl) {
            propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

                public void onPropertyAnimationStart() {
                    HomePager.this.setLayerType(2, null);
                }

                public void onPropertyAnimationEnd() {
                    HomePager.this.setLayerType(0, null);
                    homeAdapter.setCanLoadHint(true);
                }
            });
            ViewHelper.setAlpha((View)this, 0.0f);
            propertyAnimator.attach((View)this, PropertyAnimator.Property.ALPHA, 1.0f);
        }
    }

    public void hide() {
        this.mLoaded = false;
        this.setVisibility(8);
        this.setAdapter(null);
    }

    public boolean isVisible() {
        return this.mLoaded;
    }

    public void setCurrentItem(int n, boolean bl) {
        super.setCurrentItem(n, bl);
        if (this.mDecor != null) {
            this.mDecor.onPageSelected(n);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getActionMasked() == 0) {
            this.requestFocus();
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    private void updateUiFromPanelConfigs(List<HomeConfig.PanelConfig> list) {
        if (!this.mLoaded) {
            return;
        }
        if (this.mDecor != null) {
            this.mDecor.removeAllPagerViews();
        }
        HomeAdapter homeAdapter = (HomeAdapter)this.getAdapter();
        this.setAdapter(null);
        ArrayList<HomeConfig.PanelConfig> arrayList = new ArrayList<HomeConfig.PanelConfig>();
        for (HomeConfig.PanelConfig panelConfig : list) {
            if (panelConfig.isDisabled()) continue;
            arrayList.add(panelConfig);
        }
        homeAdapter.update(arrayList);
        int n = arrayList.size();
        this.mTabStrip.setVisibility(n > 0 ? 0 : 4);
        this.setAdapter((PagerAdapter)homeAdapter);
        if (this.mInitialPanelId != null) {
            this.setCurrentItem(homeAdapter.getItemPosition(this.mInitialPanelId), false);
            this.mInitialPanelId = null;
        } else {
            for (int i = 0; i < n; ++i) {
                HomeConfig.PanelConfig panelConfig = (HomeConfig.PanelConfig)arrayList.get(i);
                if (!panelConfig.isDefault()) continue;
                this.setCurrentItem(i, false);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<List<HomeConfig.PanelConfig>> {
        private ConfigLoaderCallbacks() {
        }

        public Loader<List<HomeConfig.PanelConfig>> onCreateLoader(int n, Bundle bundle) {
            return new HomeConfigLoader(HomePager.this.mContext, HomePager.this.mConfig);
        }

        public void onLoadFinished(Loader<List<HomeConfig.PanelConfig>> loader, List<HomeConfig.PanelConfig> list) {
            HomePager.this.updateUiFromPanelConfigs(list);
        }

        public void onLoaderReset(Loader<List<HomeConfig.PanelConfig>> loader) {
        }
    }

    static interface Decor {
        public void onAddPagerView(String var1);

        public void removeAllPagerViews();

        public void onPageSelected(int var1);

        public void onPageScrolled(int var1, float var2, int var3);

        public void setOnTitleClickListener(OnTitleClickListener var1);
    }

    static interface OnTitleClickListener {
        public void onTitleClicked(int var1);
    }

    public static interface OnNewTabsListener {
        public void onNewTabs(String[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OnUrlOpenListener {
        public void onUrlOpen(String var1, EnumSet<Flags> var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Flags {
            ALLOW_SWITCH_TO_TAB;

        }
    }
}

