/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;

public abstract class TwoLineRow
extends LinearLayout {
    protected static final int NO_ICON = 0;
    private final TextView mPrimaryText;
    private int mPrimaryIconId;
    private final TextView mSecondaryText;
    private int mSecondaryIconId;

    public TwoLineRow(Context context) {
        this(context, null);
    }

    public TwoLineRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setGravity(16);
        this.mSecondaryIconId = 0;
        this.mPrimaryIconId = 0;
        LayoutInflater.from((Context)context).inflate(R.layout.two_line_row, (ViewGroup)this);
        this.mPrimaryText = (TextView)this.findViewById(R.id.primary_text);
        this.mSecondaryText = (TextView)this.findViewById(R.id.secondary_text);
    }

    protected void setPrimaryText(String string2) {
        this.mPrimaryText.setText((CharSequence)string2);
    }

    protected void setSecondaryText(String string2) {
        this.mSecondaryText.setText((CharSequence)string2);
    }

    protected void setSecondaryText(int n) {
        this.mSecondaryText.setText(n);
    }

    protected void setPrimaryIcon(int n) {
        if (this.mPrimaryIconId == n) {
            return;
        }
        this.mPrimaryIconId = n;
        this.mSecondaryText.setCompoundDrawablesWithIntrinsicBounds(this.mSecondaryIconId, 0, this.mPrimaryIconId, 0);
    }

    protected void setSecondaryIcon(int n) {
        if (this.mSecondaryIconId == n) {
            return;
        }
        this.mSecondaryIconId = n;
        this.mSecondaryText.setCompoundDrawablesWithIntrinsicBounds(this.mSecondaryIconId, 0, this.mPrimaryIconId, 0);
    }

    public abstract void updateFromCursor(Cursor var1);
}

