/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.preferences.CustomListCategory;
import org.mozilla.gecko.preferences.CustomListPreference;
import org.mozilla.gecko.preferences.PanelsPreference;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelsPreferenceCategory
extends CustomListCategory {
    public static final String LOGTAG = "PanelsPrefCategory";
    protected HomeConfig mHomeConfig;
    protected final List<HomeConfig.PanelConfig> mPanelConfigs = new ArrayList<HomeConfig.PanelConfig>();
    protected UiAsyncTask<Void, Void, List<HomeConfig.PanelConfig>> mLoadTask;
    protected UiAsyncTask<Void, Void, Void> mSaveTask;

    public PanelsPreferenceCategory(Context context) {
        super(context);
        this.initConfig(context);
    }

    public PanelsPreferenceCategory(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initConfig(context);
    }

    public PanelsPreferenceCategory(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initConfig(context);
    }

    protected void initConfig(Context context) {
        this.mHomeConfig = HomeConfig.getDefault(context);
    }

    @Override
    public void onAttachedToActivity() {
        super.onAttachedToActivity();
        this.loadHomeConfig();
    }

    private void loadHomeConfig() {
        this.mLoadTask = new UiAsyncTask<Void, Void, List<HomeConfig.PanelConfig>>(ThreadUtils.getBackgroundHandler()){

            public List<HomeConfig.PanelConfig> doInBackground(Void ... voidArray) {
                return PanelsPreferenceCategory.this.mHomeConfig.load();
            }

            public void onPostExecute(List<HomeConfig.PanelConfig> list) {
                PanelsPreferenceCategory.this.displayPanelConfig(list);
            }
        };
        this.mLoadTask.execute((Object[])new Void[0]);
    }

    private void displayPanelConfig(List<HomeConfig.PanelConfig> list) {
        for (HomeConfig.PanelConfig panelConfig : list) {
            this.mPanelConfigs.add(panelConfig);
            PanelsPreference panelsPreference = new PanelsPreference(this.getContext(), this);
            panelsPreference.setTitle(panelConfig.getTitle());
            panelsPreference.setKey(panelConfig.getId());
            this.addPreference(panelsPreference);
            if (panelConfig.isDefault()) {
                this.mDefaultReference = panelsPreference;
                panelsPreference.setIsDefault(true);
            }
            if (!panelConfig.isDisabled()) continue;
            panelsPreference.setHidden(true);
        }
    }

    private void saveHomeConfig() {
        final List<HomeConfig.PanelConfig> list = this.makeConfigListDeepCopy();
        this.mSaveTask = new UiAsyncTask<Void, Void, Void>(ThreadUtils.getBackgroundHandler()){

            public Void doInBackground(Void ... voidArray) {
                PanelsPreferenceCategory.this.mHomeConfig.save(list);
                return null;
            }
        };
        this.mSaveTask.execute((Object[])new Void[0]);
    }

    private List<HomeConfig.PanelConfig> makeConfigListDeepCopy() {
        ArrayList<HomeConfig.PanelConfig> arrayList = new ArrayList<HomeConfig.PanelConfig>();
        for (HomeConfig.PanelConfig panelConfig : this.mPanelConfigs) {
            arrayList.add(new HomeConfig.PanelConfig(panelConfig));
        }
        return arrayList;
    }

    @Override
    public void setDefault(CustomListPreference customListPreference) {
        super.setDefault(customListPreference);
        this.updateConfigDefault();
        this.saveHomeConfig();
    }

    protected void onPrepareForRemoval() {
        if (this.mLoadTask != null) {
            this.mLoadTask.cancel(true);
        }
        if (this.mSaveTask != null) {
            this.mSaveTask.cancel(true);
        }
    }

    private void updateConfigDefault() {
        String string2 = null;
        if (this.mDefaultReference != null) {
            string2 = this.mDefaultReference.getKey();
        }
        for (HomeConfig.PanelConfig panelConfig : this.mPanelConfigs) {
            if (TextUtils.equals((CharSequence)panelConfig.getId(), (CharSequence)string2)) {
                panelConfig.setIsDefault(true);
                panelConfig.setIsDisabled(false);
                continue;
            }
            panelConfig.setIsDefault(false);
        }
    }

    @Override
    public void uninstall(CustomListPreference customListPreference) {
        super.uninstall(customListPreference);
        this.updateConfigDefault();
        String string2 = customListPreference.getKey();
        HomeConfig.PanelConfig panelConfig = null;
        for (HomeConfig.PanelConfig panelConfig2 : this.mPanelConfigs) {
            if (!TextUtils.equals((CharSequence)panelConfig2.getId(), (CharSequence)string2)) continue;
            panelConfig = panelConfig2;
            break;
        }
        this.mPanelConfigs.remove(panelConfig);
        this.saveHomeConfig();
    }

    protected void setHidden(PanelsPreference panelsPreference, boolean bl) {
        panelsPreference.setHidden(bl);
        this.ensureDefaultForHide(panelsPreference, bl);
        String string2 = panelsPreference.getKey();
        for (HomeConfig.PanelConfig panelConfig : this.mPanelConfigs) {
            if (!TextUtils.equals((CharSequence)panelConfig.getId(), (CharSequence)string2)) continue;
            panelConfig.setIsDisabled(bl);
            break;
        }
        this.saveHomeConfig();
    }

    private void ensureDefaultForHide(PanelsPreference panelsPreference, boolean bl) {
        if (bl) {
            if (panelsPreference == this.mDefaultReference) {
                this.setFallbackDefault();
                this.updateConfigDefault();
            }
        } else if (this.mDefaultReference == null) {
            super.setDefault(panelsPreference);
            this.updateConfigDefault();
        }
    }

    @Override
    protected void setFallbackDefault() {
        for (int i = 0; i < this.getPreferenceCount(); ++i) {
            PanelsPreference panelsPreference = (PanelsPreference)this.getPreference(i);
            if (panelsPreference.isHidden()) continue;
            super.setDefault(panelsPreference);
            return;
        }
        this.mDefaultReference = null;
    }
}

