/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.AlreadySyncingException;
import org.mozilla.gecko.sync.CollectionKeys;
import org.mozilla.gecko.sync.CommandProcessor;
import org.mozilla.gecko.sync.CommandRunner;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.EngineSettings;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.JSONRecordFetcher;
import org.mozilla.gecko.sync.MetaGlobal;
import org.mozilla.gecko.sync.MetaGlobalException;
import org.mozilla.gecko.sync.MetaGlobalMissingEnginesException;
import org.mozilla.gecko.sync.MetaGlobalNotSetException;
import org.mozilla.gecko.sync.NoCollectionKeysSetException;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.PrefsSource;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.sync.SyncConfigurationException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.delegates.BaseGlobalSessionCallback;
import org.mozilla.gecko.sync.delegates.ClientsDataDelegate;
import org.mozilla.gecko.sync.delegates.FreshStartDelegate;
import org.mozilla.gecko.sync.delegates.JSONRecordFetchDelegate;
import org.mozilla.gecko.sync.delegates.KeyUploadDelegate;
import org.mozilla.gecko.sync.delegates.MetaGlobalDelegate;
import org.mozilla.gecko.sync.delegates.NodeAssignmentCallback;
import org.mozilla.gecko.sync.delegates.WipeServerDelegate;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.HttpResponseObserver;
import org.mozilla.gecko.sync.net.SyncResponse;
import org.mozilla.gecko.sync.net.SyncStorageRecordRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;
import org.mozilla.gecko.sync.stage.AbstractSessionManagingSyncStage;
import org.mozilla.gecko.sync.stage.AndroidBrowserBookmarksServerSyncStage;
import org.mozilla.gecko.sync.stage.AndroidBrowserHistoryServerSyncStage;
import org.mozilla.gecko.sync.stage.CheckPreconditionsStage;
import org.mozilla.gecko.sync.stage.CompletedStage;
import org.mozilla.gecko.sync.stage.EnsureClusterURLStage;
import org.mozilla.gecko.sync.stage.EnsureCrypto5KeysStage;
import org.mozilla.gecko.sync.stage.FennecTabsServerSyncStage;
import org.mozilla.gecko.sync.stage.FetchInfoCollectionsStage;
import org.mozilla.gecko.sync.stage.FetchMetaGlobalStage;
import org.mozilla.gecko.sync.stage.FormHistoryServerSyncStage;
import org.mozilla.gecko.sync.stage.GlobalSyncStage;
import org.mozilla.gecko.sync.stage.NoSuchStageException;
import org.mozilla.gecko.sync.stage.PasswordsServerSyncStage;
import org.mozilla.gecko.sync.stage.SyncClientsEngineStage;
import org.mozilla.gecko.sync.stage.UploadMetaGlobalStage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalSession
implements PrefsSource,
HttpResponseObserver {
    private static final String LOG_TAG = "GlobalSession";
    public static final String API_VERSION = "1.1";
    public static final long STORAGE_VERSION = 5L;
    public SyncConfiguration config = null;
    protected Map<GlobalSyncStage.Stage, GlobalSyncStage> stages;
    public GlobalSyncStage.Stage currentState = GlobalSyncStage.Stage.idle;
    public final BaseGlobalSessionCallback callback;
    protected final Context context;
    protected final ClientsDataDelegate clientsDelegate;
    protected final NodeAssignmentCallback nodeAssignmentCallback;
    public final Map<String, EngineSettings> enginesToUpdate = new HashMap<String, EngineSettings>();
    protected final AtomicLong largestBackoffObserved = new AtomicLong(-1L);

    public KeyBundle keyBundleForCollection(String string2) throws NoCollectionKeysSetException {
        return this.config.getCollectionKeys().keyBundleForCollection(string2);
    }

    public AuthHeaderProvider getAuthHeaderProvider() {
        return this.config.getAuthHeaderProvider();
    }

    public URI wboURI(String string2, String string3) throws URISyntaxException {
        return this.config.wboURI(string2, string3);
    }

    public GlobalSession(SyncConfiguration syncConfiguration, BaseGlobalSessionCallback baseGlobalSessionCallback, Context context, Bundle bundle, ClientsDataDelegate clientsDataDelegate, NodeAssignmentCallback nodeAssignmentCallback) throws SyncConfigurationException, IllegalArgumentException, IOException, ParseException, NonObjectJSONException {
        if (baseGlobalSessionCallback == null) {
            throw new IllegalArgumentException("Must provide a callback to GlobalSession constructor.");
        }
        Logger.debug(LOG_TAG, "GlobalSession initialized with bundle " + bundle);
        this.callback = baseGlobalSessionCallback;
        this.context = context;
        this.clientsDelegate = clientsDataDelegate;
        this.nodeAssignmentCallback = nodeAssignmentCallback;
        this.config = syncConfiguration;
        GlobalSession.registerCommands();
        this.prepareStages();
        Set<String> set = SyncConfiguration.validEngineNames();
        syncConfiguration.stagesToSync = Utils.getStagesToSyncFromBundle(set, bundle);
    }

    protected static void registerCommands() {
        CommandProcessor commandProcessor = CommandProcessor.getProcessor();
        commandProcessor.registerCommand("resetEngine", new CommandRunner(1){

            @Override
            public void executeCommand(GlobalSession globalSession, List<String> list) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(list.get(0));
                globalSession.resetStagesByName(hashSet);
            }
        });
        commandProcessor.registerCommand("resetAll", new CommandRunner(0){

            @Override
            public void executeCommand(GlobalSession globalSession, List<String> list) {
                globalSession.resetAllStages();
            }
        });
        commandProcessor.registerCommand("wipeEngine", new CommandRunner(1){

            @Override
            public void executeCommand(GlobalSession globalSession, List<String> list) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(list.get(0));
                globalSession.wipeStagesByName(hashSet);
            }
        });
        commandProcessor.registerCommand("wipeAll", new CommandRunner(0){

            @Override
            public void executeCommand(GlobalSession globalSession, List<String> list) {
                globalSession.wipeAllStages();
            }
        });
        commandProcessor.registerCommand("displayURI", new CommandRunner(3){

            @Override
            public void executeCommand(GlobalSession globalSession, List<String> list) {
                CommandProcessor.displayURI(list, globalSession.getContext());
            }
        });
    }

    protected void prepareStages() {
        HashMap<GlobalSyncStage.Stage, AbstractSessionManagingSyncStage> hashMap = new HashMap<GlobalSyncStage.Stage, AbstractSessionManagingSyncStage>();
        hashMap.put(GlobalSyncStage.Stage.checkPreconditions, new CheckPreconditionsStage());
        hashMap.put(GlobalSyncStage.Stage.ensureClusterURL, new EnsureClusterURLStage(this.nodeAssignmentCallback));
        hashMap.put(GlobalSyncStage.Stage.fetchInfoCollections, new FetchInfoCollectionsStage());
        hashMap.put(GlobalSyncStage.Stage.fetchMetaGlobal, new FetchMetaGlobalStage());
        hashMap.put(GlobalSyncStage.Stage.ensureKeysStage, new EnsureCrypto5KeysStage());
        hashMap.put(GlobalSyncStage.Stage.syncClientsEngine, new SyncClientsEngineStage());
        hashMap.put(GlobalSyncStage.Stage.syncTabs, new FennecTabsServerSyncStage());
        hashMap.put(GlobalSyncStage.Stage.syncPasswords, new PasswordsServerSyncStage());
        hashMap.put(GlobalSyncStage.Stage.syncBookmarks, new AndroidBrowserBookmarksServerSyncStage());
        hashMap.put(GlobalSyncStage.Stage.syncHistory, new AndroidBrowserHistoryServerSyncStage());
        hashMap.put(GlobalSyncStage.Stage.syncFormHistory, new FormHistoryServerSyncStage());
        hashMap.put(GlobalSyncStage.Stage.uploadMetaGlobal, new UploadMetaGlobalStage());
        hashMap.put(GlobalSyncStage.Stage.completed, new CompletedStage());
        this.stages = Collections.unmodifiableMap(hashMap);
    }

    public GlobalSyncStage getSyncStageByName(String string2) throws NoSuchStageException {
        return this.getSyncStageByName(GlobalSyncStage.Stage.byName(string2));
    }

    public GlobalSyncStage getSyncStageByName(GlobalSyncStage.Stage stage) throws NoSuchStageException {
        GlobalSyncStage globalSyncStage = this.stages.get((Object)stage);
        if (globalSyncStage == null) {
            throw new NoSuchStageException(stage);
        }
        return globalSyncStage;
    }

    public Collection<GlobalSyncStage> getSyncStagesByEnum(Collection<GlobalSyncStage.Stage> collection) {
        ArrayList<GlobalSyncStage> arrayList = new ArrayList<GlobalSyncStage>();
        for (GlobalSyncStage.Stage stage : collection) {
            try {
                GlobalSyncStage globalSyncStage = this.getSyncStageByName(stage);
                arrayList.add(globalSyncStage);
            }
            catch (NoSuchStageException noSuchStageException) {
                Logger.warn(LOG_TAG, "Unable to find stage with name " + (Object)((Object)stage));
            }
        }
        return arrayList;
    }

    public Collection<GlobalSyncStage> getSyncStagesByName(Collection<String> collection) {
        ArrayList<GlobalSyncStage> arrayList = new ArrayList<GlobalSyncStage>();
        for (String string2 : collection) {
            try {
                GlobalSyncStage globalSyncStage = this.getSyncStageByName(string2);
                arrayList.add(globalSyncStage);
            }
            catch (NoSuchStageException noSuchStageException) {
                Logger.warn(LOG_TAG, "Unable to find stage with name " + string2);
            }
        }
        return arrayList;
    }

    public static GlobalSyncStage.Stage nextStage(GlobalSyncStage.Stage stage) {
        int n = stage.ordinal() + 1;
        int n2 = GlobalSyncStage.Stage.completed.ordinal() + 1;
        return GlobalSyncStage.Stage.values()[n % n2];
    }

    public void advance() {
        GlobalSyncStage globalSyncStage;
        long l = this.largestBackoffObserved.get();
        if (l > 0L) {
            this.abort(null, "Aborting sync because of backoff of " + l + " milliseconds.");
            return;
        }
        this.callback.handleStageCompleted(this.currentState, this);
        GlobalSyncStage.Stage stage = GlobalSession.nextStage(this.currentState);
        try {
            globalSyncStage = this.getSyncStageByName(stage);
        }
        catch (NoSuchStageException noSuchStageException) {
            this.abort(noSuchStageException, "No such stage " + (Object)((Object)stage));
            return;
        }
        this.currentState = stage;
        Logger.info(LOG_TAG, "Running next stage " + (Object)((Object)stage) + " (" + globalSyncStage + ")...");
        try {
            globalSyncStage.execute(this);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Caught exception " + exception + " running stage " + (Object)((Object)stage));
            this.abort(exception, "Uncaught exception in stage.");
            return;
        }
    }

    @Override
    public SharedPreferences getPrefs(String string2, int n) {
        return this.getContext().getSharedPreferences(string2, n);
    }

    public Context getContext() {
        return this.context;
    }

    public void start() throws AlreadySyncingException {
        if (this.currentState != GlobalSyncStage.Stage.idle) {
            throw new AlreadySyncingException(this.currentState);
        }
        this.installAsHttpResponseObserver();
        this.advance();
    }

    protected void restart() throws AlreadySyncingException {
        this.currentState = GlobalSyncStage.Stage.idle;
        if (this.callback.shouldBackOff()) {
            this.callback.handleAborted(this, "Told to back off.");
            return;
        }
        this.start();
    }

    protected void cleanUp() {
        this.uninstallAsHttpResponseObserver();
        this.stages = null;
    }

    public void completeSync() {
        this.cleanUp();
        this.currentState = GlobalSyncStage.Stage.idle;
        this.callback.handleSuccess(this);
    }

    public void recordForMetaGlobalUpdate(String string2, EngineSettings engineSettings) {
        this.enginesToUpdate.put(string2, engineSettings);
    }

    public void removeEngineFromMetaGlobal(String string2) {
        this.enginesToUpdate.put(string2, null);
    }

    public boolean hasUpdatedMetaGlobal() {
        if (this.enginesToUpdate.isEmpty()) {
            Logger.info(LOG_TAG, "Not uploading updated meta/global record since there are no engines requesting upload.");
            return false;
        }
        if (Logger.shouldLogVerbose(LOG_TAG)) {
            Logger.trace(LOG_TAG, "Uploading updated meta/global record since there are engine changes to meta/global.");
            Logger.trace(LOG_TAG, "Engines requesting update [" + Utils.toCommaSeparatedString(this.enginesToUpdate.keySet()) + "]");
        }
        return true;
    }

    public void updateMetaGlobalInPlace() {
        ExtendedJSONObject extendedJSONObject = this.config.metaGlobal.getEngines();
        for (Map.Entry<String, EngineSettings> entry : this.enginesToUpdate.entrySet()) {
            if (entry.getValue() == null) {
                extendedJSONObject.remove(entry.getKey());
                continue;
            }
            extendedJSONObject.put(entry.getKey(), entry.getValue().toJSONObject());
        }
        this.enginesToUpdate.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadUpdatedMetaGlobal() {
        this.updateMetaGlobalInPlace();
        Logger.debug(LOG_TAG, "Uploading updated meta/global record.");
        final Object object = new Object();
        Runnable runnable = new Runnable(){

            public void run() {
                GlobalSession.this.config.metaGlobal.upload(new MetaGlobalDelegate(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleSuccess(MetaGlobal metaGlobal, SyncStorageResponse syncStorageResponse) {
                        Logger.info(GlobalSession.LOG_TAG, "Successfully uploaded updated meta/global record.");
                        GlobalSession.this.config.enabledEngineNames = GlobalSession.this.config.metaGlobal.getEnabledEngineNames();
                        GlobalSession.this.config.userSelectedEngines = null;
                        Object object = object;
                        synchronized (object) {
                            object.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleMissing(MetaGlobal metaGlobal, SyncStorageResponse syncStorageResponse) {
                        Logger.warn(GlobalSession.LOG_TAG, "Got 404 missing uploading updated meta/global record; shouldn't happen.  Ignoring.");
                        Object object = object;
                        synchronized (object) {
                            object.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleFailure(SyncStorageResponse syncStorageResponse) {
                        Logger.warn(GlobalSession.LOG_TAG, "Failed to upload updated meta/global record; ignoring.");
                        Object object = object;
                        synchronized (object) {
                            object.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleError(Exception exception) {
                        Logger.warn(GlobalSession.LOG_TAG, "Got exception trying to upload updated meta/global record; ignoring.", exception);
                        Object object = object;
                        synchronized (object) {
                            object.notify();
                        }
                    }
                });
            }
        };
        Thread thread = new Thread(runnable);
        Object object2 = object;
        synchronized (object2) {
            try {
                thread.start();
                object.wait();
                Logger.debug(LOG_TAG, "Uploaded updated meta/global record.");
            }
            catch (InterruptedException interruptedException) {
                Logger.error(LOG_TAG, "Uploading updated meta/global interrupted; continuing.");
            }
        }
    }

    public void abort(Exception exception, String string2) {
        Logger.warn(LOG_TAG, "Aborting sync: " + string2, exception);
        this.cleanUp();
        long l = this.largestBackoffObserved.get();
        if (l > 0L) {
            this.callback.requestBackoff(l);
        }
        if (!(exception instanceof HTTPFailureException) && this.hasUpdatedMetaGlobal()) {
            this.uploadUpdatedMetaGlobal();
        }
        this.callback.handleError(this, exception);
    }

    public void handleHTTPError(SyncStorageResponse syncStorageResponse, String string2) {
        Logger.warn(LOG_TAG, "Aborting sync due to HTTP " + syncStorageResponse.getStatusCode());
        this.interpretHTTPFailure(syncStorageResponse.httpResponse());
        this.abort(new HTTPFailureException(syncStorageResponse), string2);
    }

    public void interpretHTTPFailure(HttpResponse httpResponse) {
        long l = new SyncResponse(httpResponse).totalBackoffInMilliseconds();
        if (l > 0L) {
            this.callback.requestBackoff(l);
        }
        if (httpResponse.getStatusLine() != null) {
            int n = httpResponse.getStatusLine().getStatusCode();
            switch (n) {
                case 400: {
                    SyncStorageResponse syncStorageResponse = new SyncStorageResponse(httpResponse);
                    this.interpretHTTPBadRequestBody(syncStorageResponse);
                    break;
                }
                case 401: {
                    this.callback.informUnauthorizedResponse(this, this.config.getClusterURL());
                }
            }
        }
    }

    protected void interpretHTTPBadRequestBody(SyncStorageResponse syncStorageResponse) {
        try {
            String string2 = syncStorageResponse.body();
            if (string2 == null) {
                return;
            }
            if ("16".equals(string2)) {
                this.callback.informUpgradeRequiredResponse(this);
                return;
            }
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Exception parsing HTTP 400 body.", exception);
        }
    }

    public void fetchInfoCollections(JSONRecordFetchDelegate jSONRecordFetchDelegate) throws URISyntaxException {
        JSONRecordFetcher jSONRecordFetcher = new JSONRecordFetcher(this.config.infoCollectionsURL(), this.getAuthHeaderProvider());
        jSONRecordFetcher.fetch(jSONRecordFetchDelegate);
    }

    public void uploadKeys(CollectionKeys collectionKeys, final KeyUploadDelegate keyUploadDelegate) {
        CryptoRecord cryptoRecord;
        SyncStorageRecordRequest syncStorageRecordRequest;
        try {
            syncStorageRecordRequest = new SyncStorageRecordRequest(this.config.keysURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            keyUploadDelegate.onKeyUploadFailed(uRISyntaxException);
            return;
        }
        syncStorageRecordRequest.delegate = new SyncStorageRequestDelegate(){

            public String ifUnmodifiedSince() {
                return null;
            }

            public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
                Logger.debug(GlobalSession.LOG_TAG, "Keys uploaded.");
                BaseResource.consumeEntity(syncStorageResponse);
                keyUploadDelegate.onKeysUploaded();
            }

            public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
                Logger.debug(GlobalSession.LOG_TAG, "Failed to upload keys.");
                GlobalSession.this.interpretHTTPFailure(syncStorageResponse.httpResponse());
                BaseResource.consumeEntity(syncStorageResponse);
                keyUploadDelegate.onKeyUploadFailed(new HTTPFailureException(syncStorageResponse));
            }

            public void handleRequestError(Exception exception) {
                Logger.warn(GlobalSession.LOG_TAG, "Got exception trying to upload keys", exception);
                keyUploadDelegate.onKeyUploadFailed(exception);
            }

            public AuthHeaderProvider getAuthHeaderProvider() {
                return GlobalSession.this.getAuthHeaderProvider();
            }
        };
        try {
            cryptoRecord = collectionKeys.asCryptoRecord();
            cryptoRecord.setKeyBundle(this.config.syncKeyBundle);
            cryptoRecord.encrypt();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception trying creating crypto record from keys", exception);
            keyUploadDelegate.onKeyUploadFailed(exception);
            return;
        }
        syncStorageRecordRequest.put(cryptoRecord);
    }

    public void processMetaGlobal(MetaGlobal metaGlobal) {
        this.config.metaGlobal = metaGlobal;
        Long l = metaGlobal.getStorageVersion();
        if (l == null) {
            Logger.warn(LOG_TAG, "Malformed remote meta/global: could not retrieve remote storage version.");
            this.freshStart();
            return;
        }
        if (l < 5L) {
            Logger.warn(LOG_TAG, "Outdated server: reported remote storage version " + l + " < " + "local storage version " + 5L);
            this.freshStart();
            return;
        }
        if (l > 5L) {
            Logger.warn(LOG_TAG, "Outdated client: reported remote storage version " + l + " > " + "local storage version " + 5L);
            this.requiresUpgrade();
            return;
        }
        String string2 = metaGlobal.getSyncID();
        if (string2 == null) {
            Logger.warn(LOG_TAG, "Malformed remote meta/global: could not retrieve remote syncID.");
            this.freshStart();
            return;
        }
        String string3 = this.config.syncID;
        if (!string2.equals(string3)) {
            Logger.warn(LOG_TAG, "Remote syncID different from local syncID: resetting client and assuming remote syncID.");
            this.resetAllStages();
            this.config.purgeCryptoKeys();
            this.config.syncID = string2;
        }
        Logger.debug(LOG_TAG, "Comparing local engine selection timestamp [" + this.config.userSelectedEnginesTimestamp + "] to server meta/global timestamp [" + this.config.persistedMetaGlobal().lastModified() + "].");
        if (this.config.userSelectedEnginesTimestamp < this.config.persistedMetaGlobal().lastModified()) {
            this.config.userSelectedEngines = null;
        }
        this.config.enabledEngineNames = metaGlobal.getEnabledEngineNames();
        if (this.config.enabledEngineNames == null) {
            Logger.warn(LOG_TAG, "meta/global reported no enabled engine names!");
        } else if (Logger.shouldLogVerbose(LOG_TAG)) {
            Logger.trace(LOG_TAG, "Persisting enabled engine names '" + Utils.toCommaSeparatedString(this.config.enabledEngineNames) + "' from meta/global.");
        }
        this.config.persistToPrefs();
        this.advance();
    }

    public void processMissingMetaGlobal(MetaGlobal metaGlobal) {
        this.freshStart();
    }

    public void freshStart() {
        final GlobalSession globalSession = this;
        GlobalSession.freshStart(this, new FreshStartDelegate(){

            public void onFreshStartFailed(Exception exception) {
                globalSession.abort(exception, "Fresh start failed.");
            }

            public void onFreshStart() {
                try {
                    Logger.warn(GlobalSession.LOG_TAG, "Fresh start succeeded; restarting global session.");
                    globalSession.config.persistToPrefs();
                    globalSession.restart();
                }
                catch (Exception exception) {
                    Logger.warn(GlobalSession.LOG_TAG, "Got exception when restarting sync after freshStart.", exception);
                    globalSession.abort(exception, "Got exception after freshStart.");
                }
            }
        });
    }

    protected static void freshStart(final GlobalSession globalSession, final FreshStartDelegate freshStartDelegate) {
        Logger.debug(LOG_TAG, "Fresh starting.");
        final MetaGlobal metaGlobal = globalSession.generateNewMetaGlobal();
        globalSession.wipeServer(globalSession.getAuthHeaderProvider(), new WipeServerDelegate(){

            public void onWiped(long l) {
                Logger.debug(GlobalSession.LOG_TAG, "Successfully wiped server.  Resetting all stages and purging cached meta/global and crypto/keys records.");
                globalSession.resetAllStages();
                globalSession.config.purgeMetaGlobal();
                globalSession.config.purgeCryptoKeys();
                globalSession.config.persistToPrefs();
                Logger.info(GlobalSession.LOG_TAG, "Uploading new meta/global with sync ID " + metaGlobal.syncID + ".");
                metaGlobal.upload(new MetaGlobalDelegate(){

                    public void handleSuccess(MetaGlobal metaGlobal, SyncStorageResponse syncStorageResponse) {
                        Logger.info(GlobalSession.LOG_TAG, "Uploaded new meta/global with sync ID " + metaGlobal.syncID + ".");
                        CollectionKeys collectionKeys = null;
                        try {
                            collectionKeys = globalSession.generateNewCryptoKeys();
                        }
                        catch (CryptoException cryptoException) {
                            Logger.warn(GlobalSession.LOG_TAG, "Got exception generating new keys; failing fresh start.", cryptoException);
                            freshStartDelegate.onFreshStartFailed(cryptoException);
                        }
                        if (collectionKeys == null) {
                            Logger.warn(GlobalSession.LOG_TAG, "Got null keys from generateNewKeys; failing fresh start.");
                            freshStartDelegate.onFreshStartFailed(null);
                        }
                        Logger.info(GlobalSession.LOG_TAG, "Uploading new crypto/keys.");
                        globalSession.uploadKeys(collectionKeys, new KeyUploadDelegate(){

                            public void onKeysUploaded() {
                                Logger.info(GlobalSession.LOG_TAG, "Uploaded new crypto/keys.");
                                freshStartDelegate.onFreshStart();
                            }

                            public void onKeyUploadFailed(Exception exception) {
                                Logger.warn(GlobalSession.LOG_TAG, "Got exception uploading new keys.", exception);
                                freshStartDelegate.onFreshStartFailed(exception);
                            }
                        });
                    }

                    public void handleMissing(MetaGlobal metaGlobal, SyncStorageResponse syncStorageResponse) {
                        Logger.warn(GlobalSession.LOG_TAG, "Got 'missing' response uploading new meta/global.");
                        freshStartDelegate.onFreshStartFailed(new Exception("meta/global missing while uploading."));
                    }

                    public void handleFailure(SyncStorageResponse syncStorageResponse) {
                        Logger.warn(GlobalSession.LOG_TAG, "Got failure " + syncStorageResponse.getStatusCode() + " uploading new meta/global.");
                        globalSession.interpretHTTPFailure(syncStorageResponse.httpResponse());
                        freshStartDelegate.onFreshStartFailed(new HTTPFailureException(syncStorageResponse));
                    }

                    public void handleError(Exception exception) {
                        Logger.warn(GlobalSession.LOG_TAG, "Got error uploading new meta/global.", exception);
                        freshStartDelegate.onFreshStartFailed(exception);
                    }
                });
            }

            public void onWipeFailed(Exception exception) {
                Logger.warn(GlobalSession.LOG_TAG, "Wipe failed.");
                freshStartDelegate.onFreshStartFailed(exception);
            }
        });
    }

    protected void wipeServer(AuthHeaderProvider authHeaderProvider, final WipeServerDelegate wipeServerDelegate) {
        SyncStorageRequest syncStorageRequest;
        final GlobalSession globalSession = this;
        try {
            syncStorageRequest = new SyncStorageRequest(this.config.storageURL());
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.warn(LOG_TAG, "Invalid URI in wipeServer.");
            wipeServerDelegate.onWipeFailed(uRISyntaxException);
            return;
        }
        syncStorageRequest.delegate = new SyncStorageRequestDelegate(){

            public String ifUnmodifiedSince() {
                return null;
            }

            public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
                BaseResource.consumeEntity(syncStorageResponse);
                wipeServerDelegate.onWiped(syncStorageResponse.normalizedWeaveTimestamp());
            }

            public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
                Logger.warn(GlobalSession.LOG_TAG, "Got request failure " + syncStorageResponse.getStatusCode() + " in wipeServer.");
                globalSession.interpretHTTPFailure(syncStorageResponse.httpResponse());
                BaseResource.consumeEntity(syncStorageResponse);
                wipeServerDelegate.onWipeFailed(new HTTPFailureException(syncStorageResponse));
            }

            public void handleRequestError(Exception exception) {
                Logger.warn(GlobalSession.LOG_TAG, "Got exception in wipeServer.", exception);
                wipeServerDelegate.onWipeFailed(exception);
            }

            public AuthHeaderProvider getAuthHeaderProvider() {
                return GlobalSession.this.getAuthHeaderProvider();
            }
        };
        syncStorageRequest.delete();
    }

    public void wipeAllStages() {
        Logger.info(LOG_TAG, "Wiping all stages.");
        this.wipeStagesByEnum(GlobalSyncStage.Stage.getNamedStages());
    }

    public void wipeStages(Collection<GlobalSyncStage> collection) {
        for (GlobalSyncStage globalSyncStage : collection) {
            try {
                Logger.info(LOG_TAG, "Wiping " + globalSyncStage);
                globalSyncStage.wipeLocal(this);
            }
            catch (Exception exception) {
                Logger.error(LOG_TAG, "Ignoring wipe failure for stage " + globalSyncStage, exception);
            }
        }
    }

    public void wipeStagesByEnum(Collection<GlobalSyncStage.Stage> collection) {
        this.wipeStages(this.getSyncStagesByEnum(collection));
    }

    public void wipeStagesByName(Collection<String> collection) {
        this.wipeStages(this.getSyncStagesByName(collection));
    }

    public void resetAllStages() {
        Logger.info(LOG_TAG, "Resetting all stages.");
        this.resetStagesByEnum(GlobalSyncStage.Stage.getNamedStages());
    }

    public void resetStages(Collection<GlobalSyncStage> collection) {
        for (GlobalSyncStage globalSyncStage : collection) {
            try {
                Logger.info(LOG_TAG, "Resetting " + globalSyncStage);
                globalSyncStage.resetLocal(this);
            }
            catch (Exception exception) {
                Logger.error(LOG_TAG, "Ignoring reset failure for stage " + globalSyncStage, exception);
            }
        }
    }

    public void resetStagesByEnum(Collection<GlobalSyncStage.Stage> collection) {
        this.resetStages(this.getSyncStagesByEnum(collection));
    }

    public void resetStagesByName(Collection<String> collection) {
        this.resetStages(this.getSyncStagesByName(collection));
    }

    protected Set<String> enabledEngineNames() {
        if (this.config.enabledEngineNames != null) {
            return this.config.enabledEngineNames;
        }
        return SyncConfiguration.validEngineNames();
    }

    public CollectionKeys generateNewCryptoKeys() throws CryptoException {
        return CollectionKeys.generateCollectionKeys();
    }

    public MetaGlobal generateNewMetaGlobal() {
        String string2 = Utils.generateGuid();
        String string3 = this.config.metaURL();
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        for (String string4 : this.enabledEngineNames()) {
            EngineSettings engineSettings = null;
            try {
                GlobalSyncStage globalSyncStage = this.getSyncStageByName(string4);
                Integer n = globalSyncStage.getStorageVersion();
                if (n == null) continue;
                engineSettings = new EngineSettings(Utils.generateGuid(), n);
            }
            catch (NoSuchStageException noSuchStageException) {
                engineSettings = new EngineSettings(Utils.generateGuid(), 0);
            }
            extendedJSONObject.put(string4, engineSettings.toJSONObject());
        }
        MetaGlobal metaGlobal = new MetaGlobal(string3, this.getAuthHeaderProvider());
        metaGlobal.setSyncID(string2);
        metaGlobal.setStorageVersion(5L);
        metaGlobal.setEngines(extendedJSONObject);
        return metaGlobal;
    }

    public void requiresUpgrade() {
        Logger.info(LOG_TAG, "Client outdated storage version; requires update.");
        this.abort(null, "Requires upgrade");
    }

    public boolean engineIsEnabled(String string2, EngineSettings engineSettings) throws MetaGlobalException {
        if (this.config.metaGlobal == null) {
            throw new MetaGlobalNotSetException();
        }
        if (this.config.enabledEngineNames == null) {
            Logger.error(LOG_TAG, "No enabled engines in config. Giving up.");
            throw new MetaGlobalMissingEnginesException();
        }
        if (!this.config.enabledEngineNames.contains(string2)) {
            Logger.debug(LOG_TAG, "Engine " + string2 + " not enabled: no meta/global entry.");
            return false;
        }
        if (engineSettings != null) {
            this.config.metaGlobal.verifyEngineSettings(string2, engineSettings);
        }
        return true;
    }

    public ClientsDataDelegate getClientsDelegate() {
        return this.clientsDelegate;
    }

    protected void installAsHttpResponseObserver() {
        Logger.debug(LOG_TAG, "Installing " + this + " as BaseResource HttpResponseObserver.");
        BaseResource.setHttpResponseObserver(this);
        this.largestBackoffObserved.set(-1L);
    }

    protected void uninstallAsHttpResponseObserver() {
        Logger.debug(LOG_TAG, "Uninstalling " + this + " as BaseResource HttpResponseObserver.");
        BaseResource.setHttpResponseObserver(null);
    }

    @Override
    public void observeHttpResponse(HttpResponse httpResponse) {
        long l;
        long l2 = new SyncResponse(httpResponse).totalBackoffInMilliseconds();
        if (l2 <= 0L) {
            return;
        }
        Logger.debug(LOG_TAG, "Observed " + l2 + " millisecond backoff request.");
        do {
            if ((l = this.largestBackoffObserved.get()) < l2) continue;
            return;
        } while (!this.largestBackoffObserved.compareAndSet(l, l2));
    }
}

