/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.crypto;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class PBKDF2 {
    public static byte[] pbkdf2SHA1(byte[] byArray, byte[] byArray2, int n, int n2) throws GeneralSecurityException {
        PBEKeySpec pBEKeySpec;
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        try {
            pBEKeySpec = new PBEKeySpec(new String(byArray, "UTF-8").toCharArray(), byArray2, n, n2 * 8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GeneralSecurityException(unsupportedEncodingException);
        }
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        return secretKey.getEncoded();
    }

    public static byte[] pbkdf2SHA256(byte[] byArray, byte[] byArray2, int n, int n2) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(secretKeySpec);
        int n3 = mac.getMacLength();
        int n4 = Math.max(n2, n3);
        int n5 = n2 - (n4 - 1) * n3;
        byte[] byArray3 = new byte[n4 * n3];
        int n6 = 0;
        for (int i = 1; i <= n4; ++i) {
            PBKDF2.F(byArray3, n6, mac, byArray2, n, i);
            n6 += n3;
        }
        if (n5 < n3) {
            byte[] byArray4 = new byte[n2];
            System.arraycopy(byArray3, 0, byArray4, 0, n2);
            return byArray4;
        }
        return byArray3;
    }

    private static void F(byte[] byArray, int n, Mac mac, byte[] byArray2, int n2, int n3) {
        int n4 = mac.getMacLength();
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[byArray2.length + 4];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        PBKDF2.INT(byArray4, byArray2.length, n3);
        for (int i = 0; i < n2; ++i) {
            byArray4 = mac.doFinal(byArray4);
            PBKDF2.xor(byArray3, byArray4);
        }
        System.arraycopy(byArray3, 0, byArray, n, n4);
    }

    private static void xor(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
    }

    private static void INT(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 / 0x1000000);
        byArray[n + 1] = (byte)(n2 / 65536);
        byArray[n + 2] = (byte)(n2 / 256);
        byArray[n + 3] = (byte)n2;
    }
}

