/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake.stage;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.json.simple.parser.JSONParser;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.jpake.stage.JPakeStage;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.SyncResponse;

public class GetChannelStage
extends JPakeStage {
    public void execute(final JPakeClient jPakeClient) {
        Logger.debug("SyncJPakeStage", "Getting channel.");
        GetChannelStageDelegate getChannelStageDelegate = new GetChannelStageDelegate(){

            public void handleSuccess(String string2) {
                if (jPakeClient.finished) {
                    Logger.debug("SyncJPakeStage", "Finished; returning.");
                    return;
                }
                jPakeClient.channelUrl = jPakeClient.jpakeServer + string2;
                Logger.debug("SyncJPakeStage", "Using channel " + string2);
                jPakeClient.makeAndDisplayPin(string2);
                jPakeClient.runNextStage();
            }

            public void handleFailure(String string2) {
                Logger.error("SyncJPakeStage", "Got HTTP failure: " + string2);
                jPakeClient.abort(string2);
            }

            public void handleError(Exception exception) {
                Logger.error("SyncJPakeStage", "Threw HTTP exception.", exception);
                jPakeClient.abort("jpake.error.channel");
            }
        };
        try {
            this.makeChannelRequest(getChannelStageDelegate, jPakeClient.jpakeServer + "new_channel", jPakeClient.clientId);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.error("SyncJPakeStage", "Incorrect URI syntax.", uRISyntaxException);
            jPakeClient.abort("jpake.error.channel");
            return;
        }
        catch (Exception exception) {
            Logger.error("SyncJPakeStage", "Unexpected exception.", exception);
            jPakeClient.abort("jpake.error.channel");
            return;
        }
    }

    private void makeChannelRequest(final GetChannelStageDelegate getChannelStageDelegate, String string2, final String string3) throws URISyntaxException {
        final BaseResource baseResource = new BaseResource(string2);
        baseResource.delegate = new BaseResourceDelegate(baseResource){

            public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
                httpRequestBase.setHeader((Header)new BasicHeader("X-KeyExchange-Id", string3));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleHttpResponse(HttpResponse httpResponse) {
                try {
                    SyncResponse syncResponse = new SyncResponse(httpResponse);
                    String string2 = null;
                    try {
                        String string32 = syncResponse.body();
                        string2 = (String)new JSONParser().parse(string32);
                    }
                    catch (Exception exception) {
                        getChannelStageDelegate.handleError(exception);
                        BaseResource.consumeEntity(httpResponse);
                        return;
                    }
                    if (string2 == null) {
                        Logger.warn("SyncJPakeStage", "Got null channel.");
                        getChannelStageDelegate.handleFailure("jpake.error.channel");
                        return;
                    }
                    for (int i = 0; i < string2.length(); ++i) {
                        char c = string2.charAt(i);
                        if ('a' <= c && c <= 'z' || '0' <= c && c <= '9') continue;
                        Logger.warn("SyncJPakeStage", "Got bad channel name: " + string2 + ".");
                        getChannelStageDelegate.handleFailure("jpake.error.channel");
                        return;
                    }
                    getChannelStageDelegate.handleSuccess(string2);
                }
                finally {
                    BaseResource.consumeEntity(httpResponse);
                }
            }

            public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
                getChannelStageDelegate.handleError((Exception)clientProtocolException);
            }

            public void handleHttpIOException(IOException iOException) {
                getChannelStageDelegate.handleError(iOException);
            }

            public void handleTransportException(GeneralSecurityException generalSecurityException) {
                getChannelStageDelegate.handleError(generalSecurityException);
            }

            public int connectionTimeout() {
                return 60000;
            }
        };
        JPakeClient.runOnThread(new Runnable(){

            public void run() {
                baseResource.get();
            }
        });
    }

    private static interface GetChannelStageDelegate {
        public void handleSuccess(String var1);

        public void handleFailure(String var1);

        public void handleError(Exception var1);
    }
}

