/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.Context;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserRepositoryDataAccessor;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCleanDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCreationDelegate;

public abstract class AndroidBrowserRepository
extends Repository {
    public void createSession(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
        new CreateSessionThread(repositorySessionCreationDelegate, context).start();
    }

    public void clean(boolean bl, RepositorySessionCleanDelegate repositorySessionCleanDelegate, Context context) {
        if (bl) {
            new CleanThread(repositorySessionCleanDelegate, context).start();
        }
    }

    protected abstract AndroidBrowserRepositoryDataAccessor getDataAccessor(Context var1);

    protected abstract void sessionCreator(RepositorySessionCreationDelegate var1, Context var2);

    class CreateSessionThread
    extends Thread {
        private RepositorySessionCreationDelegate delegate;
        private Context context;

        public CreateSessionThread(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
            if (context == null) {
                throw new IllegalArgumentException("context is null.");
            }
            this.delegate = repositorySessionCreationDelegate;
            this.context = context;
        }

        public void run() {
            AndroidBrowserRepository.this.sessionCreator(this.delegate, this.context);
        }
    }

    class CleanThread
    extends Thread {
        private RepositorySessionCleanDelegate delegate;
        private Context context;

        public CleanThread(RepositorySessionCleanDelegate repositorySessionCleanDelegate, Context context) {
            if (context == null) {
                throw new IllegalArgumentException("context is null");
            }
            this.delegate = repositorySessionCleanDelegate;
            this.context = context;
        }

        public void run() {
            try {
                AndroidBrowserRepository.this.getDataAccessor(this.context).purgeDeleted();
            }
            catch (NullCursorException nullCursorException) {
                this.delegate.onCleanFailed(AndroidBrowserRepository.this, nullCursorException);
                return;
            }
            catch (Exception exception) {
                this.delegate.onCleanFailed(AndroidBrowserRepository.this, exception);
                return;
            }
            this.delegate.onCleaned(AndroidBrowserRepository.this);
        }
    }
}

