/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserBookmarksDataAccessor;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionStoreDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksDeletionManager {
    private static final String LOG_TAG = "BookmarkDelete";
    private final AndroidBrowserBookmarksDataAccessor dataAccessor;
    private RepositorySessionStoreDelegate delegate;
    private final int flushThreshold;
    private final HashSet<String> folders = new HashSet();
    private final HashSet<String> nonFolders = new HashSet();
    private int nonFolderCount = 0;
    private HashSet<String> nonFolderParents = new HashSet();
    private HashSet<String> folderParents = new HashSet();

    public BookmarksDeletionManager(AndroidBrowserBookmarksDataAccessor androidBrowserBookmarksDataAccessor, int n) {
        this.dataAccessor = androidBrowserBookmarksDataAccessor;
        this.flushThreshold = n;
    }

    public void setDelegate(RepositorySessionStoreDelegate repositorySessionStoreDelegate) {
        this.delegate = repositorySessionStoreDelegate;
    }

    public void deleteRecord(String string2, boolean bl, String string3) {
        if (string2 == null) {
            Logger.warn(LOG_TAG, "Cannot queue deletion of record with no GUID.");
            return;
        }
        Logger.debug(LOG_TAG, "Queuing deletion of " + string2);
        if (bl) {
            this.folders.add(string2);
            if (!this.folders.contains(string3)) {
                this.folderParents.add(string3);
            }
            this.nonFolderParents.remove(string2);
            this.folderParents.remove(string2);
            return;
        }
        if (!this.folders.contains(string3)) {
            this.nonFolderParents.add(string3);
        }
        if (this.nonFolders.add(string2) && ++this.nonFolderCount >= this.flushThreshold) {
            this.deleteNonFolders();
        }
    }

    public void incrementalFlush() {
        this.deleteNonFolders();
    }

    public Set<String> flushAll(long l, long l2) throws NullCursorException {
        String[] stringArray;
        Logger.debug(LOG_TAG, "Doing complete flush of deleted items. Moving orphans to " + l);
        this.deleteNonFolders();
        this.nonFolderParents.removeAll(this.folders);
        Logger.debug(LOG_TAG, "Bumping modified times for " + this.nonFolderParents.size() + " parents of deleted non-folders.");
        this.dataAccessor.bumpModifiedByGUID(this.nonFolderParents, l2);
        if (this.folders.size() > 0) {
            stringArray = this.folders.toArray(new String[this.folders.size()]);
            String[] stringArray2 = this.getIDs(stringArray);
            int n = this.dataAccessor.moveChildren(stringArray2, l);
            if (n > 0) {
                this.dataAccessor.bumpModified(l, l2);
            }
            String string2 = RepoUtils.computeSQLInClause(this.folders.size(), "guid");
            this.dataAccessor.delete(string2, stringArray);
            this.invokeCallbacks(this.delegate, stringArray);
            this.folderParents.removeAll(this.folders);
            Logger.debug(LOG_TAG, "Bumping modified times for " + this.folderParents.size() + " parents of deleted folders.");
            this.dataAccessor.bumpModifiedByGUID(this.folderParents, l2);
            this.folders.clear();
        }
        stringArray = this.nonFolderParents;
        stringArray.addAll(this.folderParents);
        this.nonFolderParents = new HashSet();
        this.folderParents = new HashSet();
        return stringArray;
    }

    private String[] getIDs(String[] stringArray) throws NullCursorException {
        String[] stringArray2 = new String[stringArray.length];
        Map<String, Long> map = this.dataAccessor.idsForGUIDs(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Long l = map.get(string2);
            if (l == null) {
                throw new IllegalArgumentException("Can't get ID for unknown record " + string2);
            }
            stringArray2[i] = l.toString();
        }
        return stringArray2;
    }

    private void deleteNonFolders() {
        if (this.nonFolderCount == 0) {
            Logger.debug(LOG_TAG, "No non-folders to delete.");
            return;
        }
        Logger.debug(LOG_TAG, "Applying deletion of " + this.nonFolderCount + " non-folders.");
        String[] stringArray = this.nonFolders.toArray(new String[this.nonFolderCount]);
        String string2 = RepoUtils.computeSQLInClause(this.nonFolderCount, "guid");
        this.dataAccessor.delete(string2, stringArray);
        this.invokeCallbacks(this.delegate, stringArray);
        this.nonFolders.clear();
        this.nonFolderCount = 0;
    }

    private void invokeCallbacks(RepositorySessionStoreDelegate repositorySessionStoreDelegate, String[] stringArray) {
        if (repositorySessionStoreDelegate == null) {
            return;
        }
        Logger.trace(LOG_TAG, "Invoking store callback for " + stringArray.length + " GUIDs.");
        for (String string2 : stringArray) {
            repositorySessionStoreDelegate.onRecordStoreSucceeded(string2);
        }
    }

    public void clear() {
        this.nonFolders.clear();
        this.nonFolderCount = 0;
        this.folders.clear();
        this.nonFolderParents.clear();
        this.folderParents.clear();
    }
}

