/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

public class ApkResources {
    private static final String LOGTAG = "GeckoWebAppApkResources";
    private final String mPackageName;
    private final ApplicationInfo mInfo;
    private final Context mContext;

    public ApkResources(Context context, String string2) throws PackageManager.NameNotFoundException {
        this.mPackageName = string2;
        this.mInfo = context.getPackageManager().getApplicationInfo(this.mPackageName, 128);
        this.mContext = context;
    }

    private ApplicationInfo info() {
        return this.mInfo;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    private Bundle metadata() {
        return this.mInfo.metaData;
    }

    public String getManifest(Context context) {
        return this.readResource(context, "manifest");
    }

    public String getMiniManifest(Context context) {
        return this.readResource(context, "mini");
    }

    public String getManifestUrl() {
        return this.metadata().getString("manifestUrl");
    }

    public boolean isPackaged() {
        return "packaged".equals(this.getWebAppType());
    }

    private String readResource(Context context, String string2) {
        Uri uri = Uri.parse((String)("android.resource://" + this.mPackageName + "/raw/" + string2));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(context.getContentResolver().openInputStream(uri)));
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)LOGTAG, (String)String.format("File not found: \"%s\"", string2));
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)String.format("Couldn't read file: \"%s\"", string2));
        }
        return stringBuilder.toString();
    }

    public Uri getAppIconUri() {
        return Uri.parse((String)("android.resource://" + this.mPackageName + "/" + this.info().icon));
    }

    public Drawable getAppIcon() {
        return this.info().loadIcon(this.mContext.getPackageManager());
    }

    public String getWebAppType() {
        return this.metadata().getString("webapp");
    }

    public String getAppName() {
        return this.info().name;
    }

    public String getPackageInstallerName() {
        return this.mContext.getPackageManager().getInstallerPackageName(this.mPackageName);
    }

    public Uri getZipFileUri() {
        return Uri.parse((String)("android.resource://" + this.mPackageName + "/raw/application"));
    }

    public File getFileDirectory() {
        File file = this.mContext.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
        String string2 = file.getAbsolutePath().replace(this.mContext.getPackageName(), this.mPackageName);
        if (!(file = new File(string2)).exists()) {
            file.mkdirs();
        }
        return file;
    }
}

