/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.conn.scheme;

import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.conn.scheme.Scheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SchemeRegistry {
    private final ConcurrentHashMap<String, Scheme> registeredSchemes = new ConcurrentHashMap();

    public final Scheme getScheme(String string) {
        Scheme scheme = this.get(string);
        if (scheme == null) {
            throw new IllegalStateException("Scheme '" + string + "' not registered.");
        }
        return scheme;
    }

    public final Scheme getScheme(HttpHost httpHost) {
        if (httpHost == null) {
            throw new IllegalArgumentException("Host must not be null.");
        }
        return this.getScheme(httpHost.getSchemeName());
    }

    public final Scheme get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        Scheme scheme = this.registeredSchemes.get(string);
        return scheme;
    }

    public final Scheme register(Scheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme must not be null.");
        }
        Scheme scheme2 = this.registeredSchemes.put(scheme.getName(), scheme);
        return scheme2;
    }

    public final Scheme unregister(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        Scheme scheme = this.registeredSchemes.remove(string);
        return scheme;
    }

    public final List<String> getSchemeNames() {
        return new ArrayList<String>(this.registeredSchemes.keySet());
    }

    public void setItems(Map<String, Scheme> map) {
        if (map == null) {
            return;
        }
        this.registeredSchemes.clear();
        this.registeredSchemes.putAll(map);
    }
}

