/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.conn.ssl;

import ch.boye.httpclientandroidlib.conn.ssl.TrustStrategy;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

class TrustManagerDecorator
implements X509TrustManager {
    private final X509TrustManager trustManager;
    private final TrustStrategy trustStrategy;

    TrustManagerDecorator(X509TrustManager x509TrustManager, TrustStrategy trustStrategy) {
        this.trustManager = x509TrustManager;
        this.trustStrategy = trustStrategy;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.trustManager.checkClientTrusted(x509CertificateArray, string);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (!this.trustStrategy.isTrusted(x509CertificateArray, string)) {
            this.trustManager.checkServerTrusted(x509CertificateArray, string);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

