/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.message;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderIterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BasicListHeaderIterator
implements HeaderIterator {
    protected final List allHeaders;
    protected int currentIndex;
    protected int lastIndex;
    protected String headerName;

    public BasicListHeaderIterator(List list, String string) {
        if (list == null) {
            throw new IllegalArgumentException("Header list must not be null.");
        }
        this.allHeaders = list;
        this.headerName = string;
        this.currentIndex = this.findNext(-1);
        this.lastIndex = -1;
    }

    protected int findNext(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = this.allHeaders.size() - 1;
        boolean bl = false;
        while (!bl && n < n2) {
            bl = this.filterHeader(++n);
        }
        return bl ? n : -1;
    }

    protected boolean filterHeader(int n) {
        if (this.headerName == null) {
            return true;
        }
        String string = ((Header)this.allHeaders.get(n)).getName();
        return this.headerName.equalsIgnoreCase(string);
    }

    public boolean hasNext() {
        return this.currentIndex >= 0;
    }

    public Header nextHeader() throws NoSuchElementException {
        int n = this.currentIndex;
        if (n < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.lastIndex = n;
        this.currentIndex = this.findNext(n);
        return (Header)this.allHeaders.get(n);
    }

    public final Object next() throws NoSuchElementException {
        return this.nextHeader();
    }

    public void remove() throws UnsupportedOperationException {
        if (this.lastIndex < 0) {
            throw new IllegalStateException("No header to remove.");
        }
        this.allHeaders.remove(this.lastIndex);
        this.lastIndex = -1;
        --this.currentIndex;
    }
}

