/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.apache.commons.codec.digest;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mozilla.apache.commons.codec.binary.Hex;
import org.mozilla.apache.commons.codec.binary.StringUtils;

public class DigestUtils {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    private static byte[] digest(MessageDigest messageDigest, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = inputStream.read(byArray, 0, 1024);
        while (n > -1) {
            messageDigest.update(byArray, 0, n);
            n = inputStream.read(byArray, 0, 1024);
        }
        return messageDigest.digest();
    }

    private static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytesUtf8(string);
    }

    static MessageDigest getDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
    }

    private static MessageDigest getMd5Digest() {
        return DigestUtils.getDigest("MD5");
    }

    private static MessageDigest getSha256Digest() {
        return DigestUtils.getDigest("SHA-256");
    }

    private static MessageDigest getSha384Digest() {
        return DigestUtils.getDigest("SHA-384");
    }

    private static MessageDigest getSha512Digest() {
        return DigestUtils.getDigest("SHA-512");
    }

    private static MessageDigest getShaDigest() {
        return DigestUtils.getDigest("SHA");
    }

    public static byte[] md5(byte[] byArray) {
        return DigestUtils.getMd5Digest().digest(byArray);
    }

    public static byte[] md5(InputStream inputStream) throws IOException {
        return DigestUtils.digest(DigestUtils.getMd5Digest(), inputStream);
    }

    public static byte[] md5(String string) {
        return DigestUtils.md5(DigestUtils.getBytesUtf8(string));
    }

    public static String md5Hex(byte[] byArray) {
        return Hex.encodeHexString(DigestUtils.md5(byArray));
    }

    public static String md5Hex(InputStream inputStream) throws IOException {
        return Hex.encodeHexString(DigestUtils.md5(inputStream));
    }

    public static String md5Hex(String string) {
        return Hex.encodeHexString(DigestUtils.md5(string));
    }

    public static byte[] sha(byte[] byArray) {
        return DigestUtils.getShaDigest().digest(byArray);
    }

    public static byte[] sha(InputStream inputStream) throws IOException {
        return DigestUtils.digest(DigestUtils.getShaDigest(), inputStream);
    }

    public static byte[] sha(String string) {
        return DigestUtils.sha(DigestUtils.getBytesUtf8(string));
    }

    public static byte[] sha256(byte[] byArray) {
        return DigestUtils.getSha256Digest().digest(byArray);
    }

    public static byte[] sha256(InputStream inputStream) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha256Digest(), inputStream);
    }

    public static byte[] sha256(String string) {
        return DigestUtils.sha256(DigestUtils.getBytesUtf8(string));
    }

    public static String sha256Hex(byte[] byArray) {
        return Hex.encodeHexString(DigestUtils.sha256(byArray));
    }

    public static String sha256Hex(InputStream inputStream) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha256(inputStream));
    }

    public static String sha256Hex(String string) {
        return Hex.encodeHexString(DigestUtils.sha256(string));
    }

    public static byte[] sha384(byte[] byArray) {
        return DigestUtils.getSha384Digest().digest(byArray);
    }

    public static byte[] sha384(InputStream inputStream) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha384Digest(), inputStream);
    }

    public static byte[] sha384(String string) {
        return DigestUtils.sha384(DigestUtils.getBytesUtf8(string));
    }

    public static String sha384Hex(byte[] byArray) {
        return Hex.encodeHexString(DigestUtils.sha384(byArray));
    }

    public static String sha384Hex(InputStream inputStream) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha384(inputStream));
    }

    public static String sha384Hex(String string) {
        return Hex.encodeHexString(DigestUtils.sha384(string));
    }

    public static byte[] sha512(byte[] byArray) {
        return DigestUtils.getSha512Digest().digest(byArray);
    }

    public static byte[] sha512(InputStream inputStream) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha512Digest(), inputStream);
    }

    public static byte[] sha512(String string) {
        return DigestUtils.sha512(DigestUtils.getBytesUtf8(string));
    }

    public static String sha512Hex(byte[] byArray) {
        return Hex.encodeHexString(DigestUtils.sha512(byArray));
    }

    public static String sha512Hex(InputStream inputStream) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha512(inputStream));
    }

    public static String sha512Hex(String string) {
        return Hex.encodeHexString(DigestUtils.sha512(string));
    }

    public static String shaHex(byte[] byArray) {
        return Hex.encodeHexString(DigestUtils.sha(byArray));
    }

    public static String shaHex(InputStream inputStream) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha(inputStream));
    }

    public static String shaHex(String string) {
        return Hex.encodeHexString(DigestUtils.sha(string));
    }
}

