/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.mozilla.gecko.mozglue.WebRTCJNITarget;

@WebRTCJNITarget
class AudioManagerAndroid {
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAMES_PER_BUFFER = 256;
    private int mNativeOutputSampleRate;
    private boolean mAudioLowLatencySupported;
    private int mAudioLowLatencyOutputFrameSize;

    private AudioManagerAndroid(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        this.mNativeOutputSampleRate = 44100;
        this.mAudioLowLatencyOutputFrameSize = 256;
        this.mAudioLowLatencySupported = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                String string;
                Method method = AudioManager.class.getMethod("getProperty", String.class);
                Field field = AudioManager.class.getField("PROPERTY_OUTPUT_SAMPLE_RATE");
                Field field2 = AudioManager.class.getField("PROPERTY_OUTPUT_FRAMES_PER_BUFFER");
                String string2 = (String)field.get(null);
                String string3 = (String)field2.get(null);
                String string4 = (String)method.invoke((Object)audioManager, string2);
                if (string4 != null) {
                    this.mNativeOutputSampleRate = Integer.parseInt(string4);
                }
                if ((string = (String)method.invoke((Object)audioManager, string2)) != null) {
                    this.mAudioLowLatencyOutputFrameSize = Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                Log.w((String)"WebRTC", (String)"error getting low latency params", (Throwable)exception);
            }
        }
    }

    private int getNativeOutputSampleRate() {
        return this.mNativeOutputSampleRate;
    }

    private boolean isAudioLowLatencySupported() {
        return this.mAudioLowLatencySupported;
    }

    private int getAudioLowLatencyOutputFrameSize() {
        return this.mAudioLowLatencyOutputFrameSize;
    }
}

