/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;

public class EditBookmarkDialog {
    private static final String LOGTAG = "GeckoEditBookmarkDialog";
    private Context mContext;

    public EditBookmarkDialog(Context context) {
        this.mContext = context;
    }

    public void show(final String string2) {
        new UiAsyncTask<Void, Void, Bookmark>(ThreadUtils.getBackgroundHandler()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Bookmark doInBackground(Void ... voidArray) {
                Cursor cursor = BrowserDB.getBookmarkForUrl(EditBookmarkDialog.this.mContext.getContentResolver(), string2);
                if (cursor == null) {
                    return null;
                }
                Bookmark bookmark = null;
                try {
                    cursor.moveToFirst();
                    bookmark = new Bookmark(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("title")), cursor.getString(cursor.getColumnIndexOrThrow("url")), cursor.getString(cursor.getColumnIndexOrThrow("keyword")));
                }
                finally {
                    cursor.close();
                }
                return bookmark;
            }

            public void onPostExecute(Bookmark bookmark) {
                if (bookmark == null) {
                    return;
                }
                EditBookmarkDialog.this.show(bookmark.id, bookmark.title, bookmark.url, bookmark.keyword);
            }
        }.execute((Object[])new Void[0]);
    }

    public void show(final int n, String string2, String string3, String string4) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.bookmark_edit, null);
        builder.setTitle(R.string.bookmark_edit_title);
        builder.setView(view);
        final EditText editText = (EditText)view.findViewById(R.id.edit_bookmark_name);
        final EditText editText2 = (EditText)view.findViewById(R.id.edit_bookmark_location);
        final EditText editText3 = (EditText)view.findViewById(R.id.edit_bookmark_keyword);
        editText.setText((CharSequence)string2);
        editText2.setText((CharSequence)string3);
        editText3.setText((CharSequence)string4);
        builder.setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                new UiAsyncTask<Void, Void, Void>(ThreadUtils.getBackgroundHandler()){

                    public Void doInBackground(Void ... voidArray) {
                        String string2 = editText2.getText().toString().trim();
                        String string3 = editText3.getText().toString().trim();
                        BrowserDB.updateBookmark(EditBookmarkDialog.this.mContext.getContentResolver(), n, string2, editText.getText().toString(), string3);
                        return null;
                    }

                    public void onPostExecute(Void void_) {
                        Toast.makeText((Context)EditBookmarkDialog.this.mContext, (int)R.string.bookmark_updated, (int)0).show();
                    }
                }.execute((Object[])new Void[0]);
            }
        });
        builder.setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        });
        AlertDialog alertDialog = builder.create();
        LocationTextWatcher locationTextWatcher = new LocationTextWatcher(alertDialog);
        KeywordTextWatcher keywordTextWatcher = new KeywordTextWatcher(alertDialog);
        locationTextWatcher.setPairedTextWatcher(keywordTextWatcher);
        keywordTextWatcher.setPairedTextWatcher(locationTextWatcher);
        editText2.addTextChangedListener((TextWatcher)locationTextWatcher);
        editText3.addTextChangedListener((TextWatcher)keywordTextWatcher);
        alertDialog.show();
    }

    private class KeywordTextWatcher
    extends EditBookmarkTextWatcher {
        public KeywordTextWatcher(AlertDialog alertDialog) {
            super(alertDialog);
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            this.mEnabled = ((Object)charSequence).toString().trim().indexOf(32) == -1;
            super.onTextChanged(charSequence, n, n2, n3);
        }
    }

    private class LocationTextWatcher
    extends EditBookmarkTextWatcher {
        public LocationTextWatcher(AlertDialog alertDialog) {
            super(alertDialog);
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            this.mEnabled = ((Object)charSequence).toString().trim().length() > 0;
            super.onTextChanged(charSequence, n, n2, n3);
        }
    }

    private class EditBookmarkTextWatcher
    implements TextWatcher {
        protected AlertDialog mDialog;
        protected EditBookmarkTextWatcher mPairedTextWatcher;
        protected boolean mEnabled = true;

        public EditBookmarkTextWatcher(AlertDialog alertDialog) {
            this.mDialog = alertDialog;
        }

        public void setPairedTextWatcher(EditBookmarkTextWatcher editBookmarkTextWatcher) {
            this.mPairedTextWatcher = editBookmarkTextWatcher;
        }

        public boolean isEnabled() {
            return this.mEnabled;
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            boolean bl = this.mEnabled && (this.mPairedTextWatcher == null || this.mPairedTextWatcher.isEnabled());
            this.mDialog.getButton(-1).setEnabled(bl);
        }

        public void afterTextChanged(Editable editable) {
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    private class Bookmark {
        int id;
        String title;
        String url;
        String keyword;

        public Bookmark(int n, String string2, String string3, String string4) {
            this.id = n;
            this.title = string2;
            this.url = string3;
            this.keyword = string4;
        }
    }
}

