/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Application;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewParent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.LightweightThemeDrawable;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class LightweightTheme
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoLightweightTheme";
    private Application mApplication;
    private Handler mHandler;
    private Bitmap mBitmap;
    private int mColor;
    private boolean mIsLight;
    private List<OnChangeListener> mListeners;

    public LightweightTheme(Application application) {
        this.mApplication = application;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mListeners = new ArrayList<OnChangeListener>();
        GeckoAppShell.getEventDispatcher().registerEventListener("LightweightTheme:Update", (GeckoEventListener)this);
        GeckoAppShell.getEventDispatcher().registerEventListener("LightweightTheme:Disable", (GeckoEventListener)this);
    }

    public void addListener(OnChangeListener onChangeListener) {
        this.mListeners.add(onChangeListener);
    }

    public void removeListener(OnChangeListener onChangeListener) {
        this.mListeners.remove(onChangeListener);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("LightweightTheme:Update")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                final String string3 = jSONObject2.getString("headerURL");
                ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                    public void run() {
                        String string2 = string3;
                        int n = string2.indexOf(63);
                        if (n != -1) {
                            string2 = string2.substring(0, n);
                        }
                        final Bitmap bitmap = BitmapUtils.decodeUrl(string2);
                        LightweightTheme.this.mHandler.post(new Runnable(){

                            public void run() {
                                LightweightTheme.this.setLightweightTheme(bitmap);
                            }
                        });
                    }
                });
            } else if (string2.equals("LightweightTheme:Disable")) {
                this.mHandler.post(new Runnable(){

                    public void run() {
                        LightweightTheme.this.resetLightweightTheme();
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    private void setLightweightTheme(Bitmap bitmap) {
        if (bitmap == null || bitmap.getWidth() == 0 || bitmap.getHeight() == 0) {
            this.mBitmap = null;
            return;
        }
        DisplayMetrics displayMetrics = this.mApplication.getResources().getDisplayMetrics();
        int n = Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
        int n2 = (int)((double)bitmap.getHeight() * 0.25);
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)(n3 > n ? n3 - n : 0), (int)(n4 - n2), (int)(n3 > n ? n : n3), (int)n2);
        this.mColor = BitmapUtils.getDominantColor(bitmap2, false);
        double d = 0.2125 * (double)((this.mColor & 0xFF0000) >> 16) + 0.7154 * (double)((this.mColor & 0xFF00) >> 8) + 0.0721 * (double)(this.mColor & 0xFF);
        boolean bl = this.mIsLight = d > 110.0;
        if (bitmap.getWidth() >= n) {
            this.mBitmap = bitmap;
        } else {
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            this.mBitmap = Bitmap.createBitmap((int)n, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            OnChangeListener onChangeListener = new Canvas(this.mBitmap);
            onChangeListener.drawColor(this.mColor);
            Rect rect = new Rect();
            Gravity.apply((int)53, (int)n3, (int)n4, (Rect)new Rect(0, 0, n, n4), (Rect)rect);
            onChangeListener.drawBitmap(bitmap, null, rect, paint);
        }
        for (OnChangeListener onChangeListener : this.mListeners) {
            onChangeListener.onLightweightThemeChanged();
        }
    }

    private void resetLightweightTheme() {
        if (this.mBitmap != null) {
            this.mBitmap = null;
            for (OnChangeListener onChangeListener : this.mListeners) {
                onChangeListener.onLightweightThemeReset();
            }
        }
    }

    public boolean isEnabled() {
        return this.mBitmap != null;
    }

    public boolean isLightTheme() {
        return this.mIsLight;
    }

    private Bitmap getCroppedBitmap(View view) {
        ViewParent viewParent;
        if (this.mBitmap == null || view == null) {
            return null;
        }
        Rect rect = new Rect();
        view.getGlobalVisibleRect(rect);
        Rect rect2 = new Rect();
        view.getWindowVisibleDisplayFrame(rect2);
        int n = view.getContext().getResources().getDisplayMetrics().widthPixels;
        int n2 = this.mBitmap.getWidth() - n + rect.left;
        int n3 = this.mBitmap.getWidth() - n + rect.right;
        int n4 = rect.top - rect2.top;
        int n5 = rect.bottom - rect2.top;
        int n6 = 0;
        int n7 = 0;
        View view2 = view;
        do {
            if (Build.VERSION.SDK_INT >= 11) {
                n6 += (int)view2.getTranslationX() - view2.getScrollX();
                n7 += (int)view2.getTranslationY() - view2.getScrollY();
            } else {
                n6 -= view2.getScrollX();
                n7 -= view2.getScrollY();
            }
            viewParent = view2.getParent();
            if (!(viewParent instanceof View)) continue;
            view2 = (View)viewParent;
        } while (viewParent instanceof View && viewParent != null);
        int n8 = (n3 -= n6) - (n2 -= n6);
        int n9 = (n5 -= n7) > this.mBitmap.getHeight() ? this.mBitmap.getHeight() - n4 : n5 - (n4 -= n7);
        try {
            return Bitmap.createBitmap((Bitmap)this.mBitmap, (int)n2, (int)n4, (int)n8, (int)n9);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Drawable getDrawable(View view) {
        Bitmap bitmap = this.getCroppedBitmap(view);
        if (bitmap == null) {
            return null;
        }
        BitmapDrawable bitmapDrawable = new BitmapDrawable(view.getContext().getResources(), bitmap);
        bitmapDrawable.setGravity(53);
        bitmapDrawable.setTileModeXY(Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        return bitmapDrawable;
    }

    public LightweightThemeDrawable getColorDrawable(View view) {
        return this.getColorDrawable(view, this.mColor, false);
    }

    public LightweightThemeDrawable getColorDrawable(View view, int n) {
        return this.getColorDrawable(view, n, false);
    }

    public LightweightThemeDrawable getColorDrawable(View view, int n, boolean bl) {
        Bitmap bitmap = this.getCroppedBitmap(view);
        if (bitmap == null) {
            return null;
        }
        LightweightThemeDrawable lightweightThemeDrawable = new LightweightThemeDrawable(view.getContext().getResources(), bitmap);
        if (bl) {
            lightweightThemeDrawable.setColorWithFilter(n, this.mColor & 0x22FFFFFF);
        } else {
            lightweightThemeDrawable.setColor(n);
        }
        return lightweightThemeDrawable;
    }

    public static interface OnChangeListener {
        public void onLightweightThemeChanged();

        public void onLightweightThemeReset();
    }
}

