/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.SimpleExpandableListAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.TabsAccessor;
import org.mozilla.gecko.TabsPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTabs
extends ExpandableListView
implements TabsPanel.PanelView,
ExpandableListView.OnGroupClickListener,
ExpandableListView.OnChildClickListener,
TabsAccessor.OnQueryTabsCompleteListener {
    private static final String LOGTAG = "GeckoRemoteTabs";
    private Context mContext;
    private TabsPanel mTabsPanel;
    private static ArrayList<ArrayList<HashMap<String, String>>> mTabsList;
    private static final String[] CLIENT_KEY;
    private static final String[] TAB_KEY;
    private static final int[] CLIENT_RESOURCE;
    private static final int[] TAB_RESOURCE;

    public RemoteTabs(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.setOnGroupClickListener(this);
        this.setOnChildClickListener(this);
    }

    @Override
    public ViewGroup getLayout() {
        return this;
    }

    @Override
    public void setTabsPanel(TabsPanel tabsPanel) {
        this.mTabsPanel = tabsPanel;
    }

    @Override
    public void show() {
        this.setVisibility(0);
        TabsAccessor.getTabs(this.mContext, this);
    }

    @Override
    public void hide() {
        this.setVisibility(8);
    }

    private void autoHidePanel() {
        this.mTabsPanel.autoHidePanel();
    }

    @Override
    public boolean shouldExpand() {
        return true;
    }

    public boolean onGroupClick(ExpandableListView expandableListView, View view, int n, long l) {
        return true;
    }

    public boolean onChildClick(ExpandableListView expandableListView, View view, int n, int n2, long l) {
        HashMap<String, String> hashMap = mTabsList.get(n).get(n2);
        if (hashMap == null) {
            this.autoHidePanel();
            return true;
        }
        Tabs.getInstance().loadUrl(hashMap.get("url"), 1);
        this.autoHidePanel();
        return true;
    }

    @Override
    public void onQueryTabsComplete(List<TabsAccessor.RemoteTab> list) {
        ArrayList<TabsAccessor.RemoteTab> arrayList = new ArrayList<TabsAccessor.RemoteTab>(list);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        ArrayList arrayList2 = new ArrayList();
        mTabsList = new ArrayList();
        String string2 = null;
        ArrayList<HashMap<String, String>> arrayList3 = null;
        for (TabsAccessor.RemoteTab remoteTab : arrayList) {
            if (string2 == null || !TextUtils.equals(string2, (CharSequence)remoteTab.guid)) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("name", remoteTab.name);
                arrayList2.add(hashMap);
                arrayList3 = new ArrayList<HashMap<String, String>>();
                mTabsList.add(arrayList3);
                string2 = new String(remoteTab.guid);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("title", TextUtils.isEmpty((CharSequence)remoteTab.title) ? remoteTab.url : remoteTab.title);
            hashMap.put("url", remoteTab.url);
            arrayList3.add(hashMap);
        }
        this.setAdapter((ExpandableListAdapter)new SimpleExpandableListAdapter(this.mContext, arrayList2, R.layout.remote_tabs_group, CLIENT_KEY, CLIENT_RESOURCE, mTabsList, R.layout.remote_tabs_child, TAB_KEY, TAB_RESOURCE));
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.expandGroup(i);
        }
    }

    static {
        CLIENT_KEY = new String[]{"name"};
        TAB_KEY = new String[]{"title", "url"};
        CLIENT_RESOURCE = new int[]{R.id.client};
        TAB_RESOURCE = new int[]{R.id.tab, R.id.url};
    }
}

