/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TabsAccessor {
    private static final String LOGTAG = "GeckoTabsAccessor";
    private static final String[] CLIENTS_AVAILABILITY_PROJECTION = new String[]{"guid"};
    private static final String[] TABS_PROJECTION_COLUMNS = new String[]{"title", "url", "guid", "name"};
    private static final String CLIENTS_SELECTION = "guid IS NOT NULL";
    private static final String TABS_SELECTION = "client_guid IS NOT NULL";
    private static final String LOCAL_CLIENT_SELECTION = "guid IS NULL";
    private static final String LOCAL_TABS_SELECTION = "client_guid IS NULL";

    public static void getTabs(Context context, OnQueryTabsCompleteListener onQueryTabsCompleteListener) {
        TabsAccessor.getTabs(context, 0, onQueryTabsCompleteListener);
    }

    public static void getTabs(final Context context, final int n, final OnQueryTabsCompleteListener onQueryTabsCompleteListener) {
        if (onQueryTabsCompleteListener == null) {
            return;
        }
        new UiAsyncTask<Void, Void, List<RemoteTab>>(ThreadUtils.getBackgroundHandler()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<RemoteTab> doInBackground(Void ... voidArray) {
                Cursor cursor;
                Uri uri = BrowserContract.Tabs.CONTENT_URI;
                if (n > 0) {
                    uri = uri.buildUpon().appendQueryParameter("limit", String.valueOf(n)).build();
                }
                if ((cursor = context.getContentResolver().query(uri, TABS_PROJECTION_COLUMNS, TabsAccessor.TABS_SELECTION, null, null)) == null) {
                    return null;
                }
                ArrayList<RemoteTab> arrayList = new ArrayList<RemoteTab>();
                try {
                    while (cursor.moveToNext()) {
                        RemoteTab remoteTab = new RemoteTab();
                        remoteTab.title = cursor.getString(TABS_COLUMN.TITLE.ordinal());
                        remoteTab.url = cursor.getString(TABS_COLUMN.URL.ordinal());
                        remoteTab.guid = cursor.getString(TABS_COLUMN.GUID.ordinal());
                        remoteTab.name = cursor.getString(TABS_COLUMN.NAME.ordinal());
                        arrayList.add(remoteTab);
                    }
                }
                finally {
                    cursor.close();
                }
                return Collections.unmodifiableList(arrayList);
            }

            protected void onPostExecute(List<RemoteTab> list) {
                onQueryTabsCompleteListener.onQueryTabsComplete(list);
            }
        }.execute((Object[])new Void[0]);
    }

    private static void updateLocalClient(ContentResolver contentResolver) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("last_modified", Long.valueOf(System.currentTimeMillis()));
        contentResolver.update(BrowserContract.Clients.CONTENT_URI, contentValues, LOCAL_CLIENT_SELECTION, null);
    }

    private static void deleteLocalTabs(ContentResolver contentResolver) {
        contentResolver.delete(BrowserContract.Tabs.CONTENT_URI, LOCAL_TABS_SELECTION, null);
    }

    private static void insertLocalTabs(ContentResolver contentResolver, Iterable<Tab> iterable) {
        JSONArray jSONArray = new JSONArray();
        ArrayList<ContentValues> arrayList = new ArrayList<ContentValues>();
        int n = 0;
        for (Tab tab : iterable) {
            String string2 = tab.getURL();
            if (string2 == null || tab.isPrivate()) continue;
            ContentValues contentValues = new ContentValues();
            contentValues.put("url", string2);
            contentValues.put("title", tab.getTitle());
            contentValues.put("last_used", Long.valueOf(tab.getLastUsed()));
            String string3 = tab.getFaviconURL();
            if (string3 != null) {
                contentValues.put("favicon", string3);
            } else {
                contentValues.putNull("favicon");
            }
            try {
                jSONArray.put(0, (Object)tab.getURL());
                contentValues.put("history", jSONArray.toString());
            }
            catch (JSONException jSONException) {
                Log.w((String)LOGTAG, (String)"JSONException adding URL to tab history array.", (Throwable)jSONException);
            }
            contentValues.put("position", Integer.valueOf(n++));
            contentValues.putNull("client_guid");
            arrayList.add(contentValues);
        }
        ContentValues[] contentValuesArray = arrayList.toArray(new ContentValues[arrayList.size()]);
        contentResolver.bulkInsert(BrowserContract.Tabs.CONTENT_URI, contentValuesArray);
    }

    public static synchronized void persistLocalTabs(ContentResolver contentResolver, Iterable<Tab> iterable) {
        TabsAccessor.deleteLocalTabs(contentResolver);
        TabsAccessor.insertLocalTabs(contentResolver, iterable);
        TabsAccessor.updateLocalClient(contentResolver);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OnQueryTabsCompleteListener {
        public void onQueryTabsComplete(List<RemoteTab> var1);
    }

    public static class RemoteTab {
        public String title;
        public String url;
        public String guid;
        public String name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TABS_COLUMN {
        TITLE,
        URL,
        GUID,
        NAME;

    }
}

