/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.bagheera;

import ch.boye.httpclientandroidlib.entity.AbstractHttpEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BoundedByteArrayEntity
extends AbstractHttpEntity
implements Cloneable {
    protected final byte[] content;
    protected final int start;
    protected final int end;
    protected final int length;

    public BoundedByteArrayEntity(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("Source byte array may not be null.");
        }
        if (n2 < n || n < 0 || n2 < 0 || n > byArray.length || n2 > byArray.length) {
            throw new IllegalArgumentException("Bounds out of range.");
        }
        this.content = byArray;
        this.start = n;
        this.end = n2;
        this.length = n2 - n;
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.content, this.start, this.length);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null.");
        }
        outputStream.write(this.content);
        outputStream.flush();
    }

    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

