/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.common.log.writers;

import java.io.PrintWriter;
import org.mozilla.gecko.background.common.log.writers.LogWriter;

public class PrintLogWriter
extends LogWriter {
    protected final PrintWriter pw;
    protected boolean closed = false;
    public static final String ERROR = " :: E :: ";
    public static final String WARN = " :: W :: ";
    public static final String INFO = " :: I :: ";
    public static final String DEBUG = " :: D :: ";
    public static final String VERBOSE = " :: V :: ";

    public PrintLogWriter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    protected void log(String string2, String string3, Throwable throwable) {
        if (this.closed) {
            return;
        }
        this.pw.println(string2 + string3);
        if (throwable != null) {
            throwable.printStackTrace(this.pw);
        }
    }

    public void error(String string2, String string3, Throwable throwable) {
        this.log(string2, ERROR + string3, throwable);
    }

    public void warn(String string2, String string3, Throwable throwable) {
        this.log(string2, WARN + string3, throwable);
    }

    public void info(String string2, String string3, Throwable throwable) {
        this.log(string2, INFO + string3, throwable);
    }

    public void debug(String string2, String string3, Throwable throwable) {
        this.log(string2, DEBUG + string3, throwable);
    }

    public void trace(String string2, String string3, Throwable throwable) {
        this.log(string2, VERBOSE + string3, throwable);
    }

    public boolean shouldLogVerbose(String string2) {
        return true;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.pw != null) {
            this.pw.close();
        }
        this.closed = true;
    }
}

