/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.impl.cookie.DateParseException;
import ch.boye.httpclientandroidlib.impl.cookie.DateUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.net.Resource;

public class SkewHandler {
    private static final String LOG_TAG = "SkewHandler";
    protected volatile long skewMillis = 0L;
    protected final String hostname;
    private static final HashMap<String, SkewHandler> skewHandlers = new HashMap();

    public static SkewHandler getSkewHandlerForResource(Resource resource) {
        return SkewHandler.getSkewHandlerForHostname(resource.getHostname());
    }

    public static SkewHandler getSkewHandlerFromEndpointString(String string2) throws URISyntaxException {
        if (string2 == null) {
            throw new IllegalArgumentException("url must not be null.");
        }
        URI uRI = new URI(string2);
        return SkewHandler.getSkewHandlerForHostname(uRI.getHost());
    }

    public static synchronized SkewHandler getSkewHandlerForHostname(String string2) {
        SkewHandler skewHandler = skewHandlers.get(string2);
        if (skewHandler == null) {
            skewHandler = new SkewHandler(string2);
            skewHandlers.put(string2, skewHandler);
        }
        return skewHandler;
    }

    public static synchronized void clearSkewHandlers() {
        skewHandlers.clear();
    }

    public SkewHandler(String string2) {
        this.hostname = string2;
    }

    public boolean updateSkewFromServerMillis(long l, long l2) {
        this.skewMillis = l - l2;
        Logger.debug(LOG_TAG, "Updated skew: " + this.skewMillis + "ms for hostname " + this.hostname);
        return true;
    }

    public boolean updateSkewFromHTTPDateString(String string2, long l) {
        try {
            long l2 = DateUtils.parseDate((String)string2).getTime();
            return this.updateSkewFromServerMillis(l2, l);
        }
        catch (DateParseException dateParseException) {
            Logger.warn(LOG_TAG, "Unexpected: invalid Date header from " + this.hostname);
            return false;
        }
    }

    public boolean updateSkewFromDateHeader(Header header, long l) {
        String string2 = header.getValue();
        if (null == string2) {
            Logger.warn(LOG_TAG, "Unexpected: null Date header from " + this.hostname);
            return false;
        }
        return this.updateSkewFromHTTPDateString(string2, l);
    }

    public boolean updateSkew(HttpResponse httpResponse, long l) {
        Header header = httpResponse.getFirstHeader("Date");
        if (null == header) {
            Logger.warn(LOG_TAG, "Unexpected: missing Date header from " + this.hostname);
            return false;
        }
        return this.updateSkewFromDateHeader(header, l);
    }

    public long getSkewInMillis() {
        return this.skewMillis;
    }

    public long getSkewInSeconds() {
        return this.skewMillis / 1000L;
    }

    public void resetSkew() {
        this.skewMillis = 0L;
    }
}

