/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.browserid;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import org.json.simple.parser.ParseException;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.apache.commons.codec.binary.StringUtils;
import org.mozilla.gecko.browserid.SigningPrivateKey;
import org.mozilla.gecko.browserid.VerifyingPublicKey;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWebTokenUtils {
    public static final long DEFAULT_CERTIFICATE_DURATION_IN_MILLISECONDS = 3600000L;
    public static final long DEFAULT_ASSERTION_DURATION_IN_MILLISECONDS = 3600000L;
    public static final String DEFAULT_CERTIFICATE_ISSUER = "127.0.0.1";
    public static final String DEFAULT_ASSERTION_ISSUER = "127.0.0.1";

    public static String encode(String string2, SigningPrivateKey signingPrivateKey) throws UnsupportedEncodingException, GeneralSecurityException {
        return JSONWebTokenUtils.encode(string2, signingPrivateKey, null);
    }

    protected static String encode(String string2, SigningPrivateKey signingPrivateKey, Map<String, Object> map) throws UnsupportedEncodingException, GeneralSecurityException {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        if (map != null) {
            extendedJSONObject.putAll(map);
        }
        extendedJSONObject.put("alg", signingPrivateKey.getAlgorithm());
        String string3 = Base64.encodeBase64URLSafeString((byte[])extendedJSONObject.toJSONString().getBytes("UTF-8"));
        String string4 = Base64.encodeBase64URLSafeString((byte[])string2.getBytes("UTF-8"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add(string4);
        byte[] byArray = Utils.toDelimitedString(".", arrayList).getBytes("UTF-8");
        byte[] byArray2 = signingPrivateKey.signMessage(byArray);
        arrayList.add(Base64.encodeBase64URLSafeString((byte[])byArray2));
        return Utils.toDelimitedString(".", arrayList);
    }

    public static String decode(String string2, VerifyingPublicKey verifyingPublicKey) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] byArray;
        if (string2 == null) {
            throw new IllegalArgumentException("token must not be null");
        }
        String[] stringArray = string2.split("\\.");
        if (stringArray == null || stringArray.length != 3) {
            throw new GeneralSecurityException("malformed token");
        }
        byte[] byArray2 = (stringArray[0] + "." + stringArray[1]).getBytes("UTF-8");
        boolean bl = verifyingPublicKey.verifyMessage(byArray2, byArray = Base64.decodeBase64((String)stringArray[2]));
        if (!bl) {
            throw new GeneralSecurityException("bad signature");
        }
        String string3 = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)stringArray[1]));
        return string3;
    }

    protected static String getPayloadString(String string2, String string3, long l, String string4, long l2) throws NonObjectJSONException, IOException, ParseException {
        ExtendedJSONObject extendedJSONObject = string2 != null ? new ExtendedJSONObject(string2) : new ExtendedJSONObject();
        extendedJSONObject.put("iss", string3);
        extendedJSONObject.put("iat", l);
        if (string4 != null) {
            extendedJSONObject.put("aud", string4);
        }
        extendedJSONObject.put("exp", l2);
        return extendedJSONObject.toJSONString();
    }

    protected static String getCertificatePayloadString(VerifyingPublicKey verifyingPublicKey, String string2) throws NonObjectJSONException, IOException, ParseException {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        ExtendedJSONObject extendedJSONObject2 = new ExtendedJSONObject();
        extendedJSONObject2.put("email", string2);
        extendedJSONObject.put("principal", extendedJSONObject2);
        extendedJSONObject.put("public-key", verifyingPublicKey.toJSONObject());
        return extendedJSONObject.toJSONString();
    }

    public static String createCertificate(VerifyingPublicKey verifyingPublicKey, String string2, String string3, long l, long l2, SigningPrivateKey signingPrivateKey) throws NonObjectJSONException, IOException, ParseException, GeneralSecurityException {
        String string4 = JSONWebTokenUtils.getCertificatePayloadString(verifyingPublicKey, string2);
        String string5 = JSONWebTokenUtils.getPayloadString(string4, string3, l, null, l2);
        return JSONWebTokenUtils.encode(string5, signingPrivateKey);
    }

    public static String createCertificate(VerifyingPublicKey verifyingPublicKey, String string2, SigningPrivateKey signingPrivateKey) throws NonObjectJSONException, IOException, ParseException, GeneralSecurityException {
        String string3 = "127.0.0.1";
        long l = System.currentTimeMillis();
        long l2 = 3600000L;
        return JSONWebTokenUtils.createCertificate(verifyingPublicKey, string2, string3, l, l + l2, signingPrivateKey);
    }

    public static String createAssertion(SigningPrivateKey signingPrivateKey, String string2, String string3, String string4, long l, long l2) throws NonObjectJSONException, IOException, ParseException, GeneralSecurityException {
        long l3 = l + l2;
        String string5 = "{}";
        String string6 = JSONWebTokenUtils.getPayloadString(string5, string4, l, string3, l3);
        String string7 = JSONWebTokenUtils.encode(string6, signingPrivateKey);
        return string2 + "~" + string7;
    }

    public static String createAssertion(SigningPrivateKey signingPrivateKey, String string2, String string3) throws NonObjectJSONException, IOException, ParseException, GeneralSecurityException {
        String string4 = "127.0.0.1";
        long l = System.currentTimeMillis();
        long l2 = 3600000L;
        return JSONWebTokenUtils.createAssertion(signingPrivateKey, string2, string3, string4, l, l2);
    }

    public static ExtendedJSONObject parseCertificate(String string2) {
        try {
            String[] stringArray = string2.split("\\.");
            if (stringArray.length != 3) {
                return null;
            }
            String string3 = new String(Base64.decodeBase64((String)stringArray[0]));
            String string4 = new String(Base64.decodeBase64((String)stringArray[1]));
            String string5 = Utils.byte2Hex(Base64.decodeBase64((String)stringArray[2]));
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("header", new ExtendedJSONObject(string3));
            extendedJSONObject.put("payload", new ExtendedJSONObject(string4));
            extendedJSONObject.put("signature", string5);
            return extendedJSONObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean dumpCertificate(String string2) {
        ExtendedJSONObject extendedJSONObject = JSONWebTokenUtils.parseCertificate(string2);
        try {
            if (extendedJSONObject == null) {
                System.out.println("Malformed certificate -- got exception trying to dump contents.");
                return false;
            }
            System.out.println("certificate header:    " + extendedJSONObject.getString("header"));
            System.out.println("certificate payload:   " + extendedJSONObject.getString("payload"));
            System.out.println("certificate signature: " + extendedJSONObject.getString("signature"));
            return true;
        }
        catch (Exception exception) {
            System.out.println("Malformed certificate -- got exception trying to dump contents.");
            return false;
        }
    }

    public static ExtendedJSONObject parseAssertion(String string2) {
        try {
            String[] stringArray = string2.split("~");
            if (stringArray.length != 2) {
                return null;
            }
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            if ((stringArray = string4.split("\\.")).length != 3) {
                return null;
            }
            String string5 = new String(Base64.decodeBase64((String)stringArray[0]));
            String string6 = new String(Base64.decodeBase64((String)stringArray[1]));
            String string7 = Utils.byte2Hex(Base64.decodeBase64((String)stringArray[2]));
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("header", new ExtendedJSONObject(string5));
            extendedJSONObject.put("payload", new ExtendedJSONObject(string6));
            extendedJSONObject.put("signature", string7);
            extendedJSONObject.put("certificate", string3);
            return extendedJSONObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean dumpAssertion(String string2) {
        ExtendedJSONObject extendedJSONObject = JSONWebTokenUtils.parseAssertion(string2);
        try {
            if (extendedJSONObject == null) {
                System.out.println("Malformed assertion -- got exception trying to dump contents.");
                return false;
            }
            JSONWebTokenUtils.dumpCertificate(extendedJSONObject.getString("certificate"));
            System.out.println("assertion   header:    " + extendedJSONObject.getString("header"));
            System.out.println("assertion   payload:   " + extendedJSONObject.getString("payload"));
            System.out.println("assertion   signature: " + extendedJSONObject.getString("signature"));
            return true;
        }
        catch (Exception exception) {
            System.out.println("Malformed assertion -- got exception trying to dump contents.");
            return false;
        }
    }
}

