/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBrowserDB
implements BrowserDB.BrowserDBIface {
    private static final String LOGTAG = "GeckoLocalBrowserDB";
    private static boolean logDebug = Log.isLoggable((String)"GeckoLocalBrowserDB", (int)3);
    private final String mProfile;
    private HashMap<String, Long> mFolderIdMap;
    private Boolean mDesktopBookmarksExist;
    private final Uri mBookmarksUriWithProfile;
    private final Uri mParentsUriWithProfile;
    private final Uri mHistoryUriWithProfile;
    private final Uri mHistoryExpireUriWithProfile;
    private final Uri mCombinedUriWithProfile;
    private final Uri mDeletedHistoryUriWithProfile;
    private final Uri mUpdateHistoryUriWithProfile;
    private final Uri mFaviconsUriWithProfile;
    private final Uri mThumbnailsUriWithProfile;
    private static final String[] DEFAULT_BOOKMARK_COLUMNS = new String[]{"_id", "guid", "url", "title", "type", "parent"};

    protected static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }

    public LocalBrowserDB(String string2) {
        this.mProfile = string2;
        this.mFolderIdMap = new HashMap();
        this.mDesktopBookmarksExist = null;
        this.mBookmarksUriWithProfile = this.appendProfile(BrowserContract.Bookmarks.CONTENT_URI);
        this.mParentsUriWithProfile = this.appendProfile(BrowserContract.Bookmarks.PARENTS_CONTENT_URI);
        this.mHistoryUriWithProfile = this.appendProfile(BrowserContract.History.CONTENT_URI);
        this.mHistoryExpireUriWithProfile = this.appendProfile(BrowserContract.History.CONTENT_OLD_URI);
        this.mCombinedUriWithProfile = this.appendProfile(BrowserContract.Combined.CONTENT_URI);
        this.mFaviconsUriWithProfile = this.appendProfile(BrowserContract.Favicons.CONTENT_URI);
        this.mThumbnailsUriWithProfile = this.appendProfile(BrowserContract.Thumbnails.CONTENT_URI);
        this.mDeletedHistoryUriWithProfile = this.mHistoryUriWithProfile.buildUpon().appendQueryParameter("show_deleted", "1").build();
        this.mUpdateHistoryUriWithProfile = this.mHistoryUriWithProfile.buildUpon().appendQueryParameter("increment_visits", "true").appendQueryParameter("insert_if_needed", "true").build();
    }

    @Override
    public void invalidateCachedState() {
        this.mDesktopBookmarksExist = null;
    }

    private Uri historyUriWithLimit(int n) {
        return this.mHistoryUriWithProfile.buildUpon().appendQueryParameter("limit", String.valueOf(n)).build();
    }

    private Uri bookmarksUriWithLimit(int n) {
        return this.mBookmarksUriWithProfile.buildUpon().appendQueryParameter("limit", String.valueOf(n)).build();
    }

    private Uri combinedUriWithLimit(int n) {
        return this.mCombinedUriWithProfile.buildUpon().appendQueryParameter("limit", String.valueOf(n)).build();
    }

    private Uri appendProfile(Uri uri) {
        return uri.buildUpon().appendQueryParameter("profile", this.mProfile).build();
    }

    private Uri getAllBookmarksUri() {
        Uri.Builder builder = this.mBookmarksUriWithProfile.buildUpon().appendQueryParameter("show_deleted", "1");
        return builder.build();
    }

    private Uri getAllHistoryUri() {
        Uri.Builder builder = this.mHistoryUriWithProfile.buildUpon().appendQueryParameter("show_deleted", "1");
        return builder.build();
    }

    private Uri getAllFaviconsUri() {
        Uri.Builder builder = this.mFaviconsUriWithProfile.buildUpon().appendQueryParameter("show_deleted", "1");
        return builder.build();
    }

    private Cursor filterAllSites(ContentResolver contentResolver, String[] stringArray, CharSequence charSequence, int n, CharSequence charSequence2) {
        return this.filterAllSites(contentResolver, stringArray, charSequence, n, charSequence2, "", null);
    }

    private Cursor filterAllSites(ContentResolver contentResolver, String[] stringArray, CharSequence charSequence, int n, CharSequence charSequence2, String string2, String[] stringArray2) {
        Object object;
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            object = ((Object)charSequence).toString().split(" ");
            int n2 = Math.min(((String[])object).length, 10);
            for (int i = 0; i < n2; ++i) {
                string2 = DBUtils.concatenateWhere(string2, "(url LIKE ? OR title LIKE ?)");
                String string3 = "%" + object[i] + "%";
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{string3, string3});
            }
        }
        if (charSequence2 != null) {
            string2 = DBUtils.concatenateWhere(string2, "(url NOT LIKE ?)");
            stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{((Object)charSequence2).toString()});
        }
        object = BrowserContract.getFrecencySortOrder(true, false);
        Cursor cursor = contentResolver.query(this.combinedUriWithLimit(n), stringArray, string2, stringArray2, (String)object);
        return new LocalDBCursor(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(ContentResolver contentResolver, String string2) {
        int n = 0;
        String[] stringArray = null;
        String string3 = null;
        Uri uri = null;
        if ("history".equals(string2)) {
            uri = this.mHistoryUriWithProfile;
            stringArray = new String[]{"_id"};
            string3 = "visits > 0";
        } else if ("bookmarks".equals(string2)) {
            uri = this.mBookmarksUriWithProfile;
            stringArray = new String[]{"_id"};
            string3 = "type = 1";
        } else if ("thumbnails".equals(string2)) {
            uri = this.mThumbnailsUriWithProfile;
            stringArray = new String[]{"_id"};
        } else if ("favicons".equals(string2)) {
            uri = this.mFaviconsUriWithProfile;
            stringArray = new String[]{"_id"};
        }
        if (uri != null) {
            Cursor cursor = null;
            try {
                cursor = contentResolver.query(uri, stringArray, string3, null, null);
                n = cursor.getCount();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        LocalBrowserDB.debug("Got count " + n + " for " + string2);
        return n;
    }

    @Override
    public Cursor filter(ContentResolver contentResolver, CharSequence charSequence, int n) {
        return this.filterAllSites(contentResolver, new String[]{"_id", "url", "title", "display", "bookmark_id", "history_id"}, charSequence, n, null);
    }

    @Override
    public Cursor getTopSites(ContentResolver contentResolver, int n) {
        String string2 = DBUtils.concatenateWhere("", "url NOT IN (SELECT url FROM bookmarks WHERE " + DBUtils.qualifyColumn("bookmarks", "parent") + " < ? AND " + DBUtils.qualifyColumn("bookmarks", "deleted") + " == 0)");
        String[] stringArray = new String[]{String.valueOf(0)};
        return this.filterAllSites(contentResolver, new String[]{"_id", "url", "title", "display", "bookmark_id", "history_id"}, "", n, "about:%", string2, stringArray);
    }

    @Override
    public void updateVisitedHistory(ContentResolver contentResolver, String string2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("url", string2);
        contentValues.put("date", Long.valueOf(System.currentTimeMillis()));
        contentValues.put("deleted", Integer.valueOf(0));
        contentResolver.update(this.mUpdateHistoryUriWithProfile, contentValues, "url = ?", new String[]{string2});
    }

    @Override
    public void updateHistoryTitle(ContentResolver contentResolver, String string2, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("title", string3);
        contentResolver.update(this.mHistoryUriWithProfile, contentValues, "url = ?", new String[]{string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHistoryEntry(ContentResolver contentResolver, String string2, String string3, long l, int n) {
        int n2 = 0;
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(this.mHistoryUriWithProfile, new String[]{"visits"}, "url = ?", new String[]{string2}, null);
            if (cursor.moveToFirst()) {
                n2 = cursor.getInt(0);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("date", Long.valueOf(l));
        contentValues.put("visits", Integer.valueOf(n2 + n));
        if (string3 != null) {
            contentValues.put("title", string3);
        }
        contentResolver.update(this.mHistoryUriWithProfile, contentValues, "url = ?", new String[]{string2});
    }

    @Override
    public Cursor getAllVisitedHistory(ContentResolver contentResolver) {
        Cursor cursor = contentResolver.query(this.mHistoryUriWithProfile, new String[]{"url"}, "visits > 0", null, null);
        return new LocalDBCursor(cursor);
    }

    @Override
    public Cursor getRecentHistory(ContentResolver contentResolver, int n) {
        Cursor cursor = contentResolver.query(this.combinedUriWithLimit(n), new String[]{"_id", "bookmark_id", "history_id", "url", "title", "display", "date", "visits"}, "date > 0", null, "date DESC");
        return new LocalDBCursor(cursor);
    }

    @Override
    public void expireHistory(ContentResolver contentResolver, BrowserContract.ExpirePriority expirePriority) {
        Uri uri = this.mHistoryExpireUriWithProfile;
        uri = uri.buildUpon().appendQueryParameter("priority", expirePriority.toString()).build();
        contentResolver.delete(uri, null, null);
    }

    @Override
    public void removeHistoryEntry(ContentResolver contentResolver, int n) {
        contentResolver.delete(this.mHistoryUriWithProfile, "_id = ?", new String[]{String.valueOf(n)});
    }

    @Override
    public void removeHistoryEntry(ContentResolver contentResolver, String string2) {
        int n = contentResolver.delete(this.mHistoryUriWithProfile, "url = ?", new String[]{string2});
    }

    @Override
    public void clearHistory(ContentResolver contentResolver) {
        contentResolver.delete(this.mHistoryUriWithProfile, null, null);
    }

    @Override
    public Cursor getBookmarksInFolder(ContentResolver contentResolver, long l) {
        Object object = null;
        boolean bl = false;
        if (l == 0L) {
            l = this.getFolderIdFromGuid(contentResolver, "mobile");
            bl = this.desktopBookmarksExist(contentResolver);
        }
        object = l == -1L ? contentResolver.query(this.mBookmarksUriWithProfile, DEFAULT_BOOKMARK_COLUMNS, "guid = ? OR guid = ? OR guid = ?", new String[]{"toolbar", "menu", "unfiled"}, null) : contentResolver.query(this.mBookmarksUriWithProfile, DEFAULT_BOOKMARK_COLUMNS, "parent = ? AND (type = ? OR (type = ? AND url IS NOT NULL))", new String[]{String.valueOf(l), String.valueOf(0), String.valueOf(1)}, null);
        if (bl) {
            object = new SpecialFoldersCursorWrapper((Cursor)object, bl);
        }
        return new LocalDBCursor((Cursor)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean desktopBookmarksExist(ContentResolver contentResolver) {
        if (this.mDesktopBookmarksExist != null) {
            return this.mDesktopBookmarksExist;
        }
        Cursor cursor = null;
        int n = 0;
        try {
            cursor = contentResolver.query(this.bookmarksUriWithLimit(1), new String[]{"_id"}, "parent = ? OR parent = ? OR parent = ?", new String[]{String.valueOf(this.getFolderIdFromGuid(contentResolver, "toolbar")), String.valueOf(this.getFolderIdFromGuid(contentResolver, "menu")), String.valueOf(this.getFolderIdFromGuid(contentResolver, "unfiled"))}, null);
            n = cursor.getCount();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        this.mDesktopBookmarksExist = n > 0;
        return this.mDesktopBookmarksExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReadingListCount(ContentResolver contentResolver) {
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(this.mBookmarksUriWithProfile, new String[]{"_id"}, "parent = ?", new String[]{String.valueOf(-2)}, null);
            int n = cursor.getCount();
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBookmark(ContentResolver contentResolver, String string2) {
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(this.bookmarksUriWithLimit(1), new String[]{"_id"}, "url = ? AND parent != ? AND parent != ?", new String[]{string2, String.valueOf(-2), String.valueOf(-3)}, "url");
            boolean bl = cursor.getCount() > 0;
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)LOGTAG, (String)"NullPointerException in isBookmark");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadingListItem(ContentResolver contentResolver, String string2) {
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(this.mBookmarksUriWithProfile, new String[]{"_id"}, "url = ? AND parent == ?", new String[]{string2, String.valueOf(-2)}, "url");
            boolean bl = cursor.getCount() > 0;
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)LOGTAG, (String)"NullPointerException in isReadingListItem");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUrlForKeyword(ContentResolver contentResolver, String string2) {
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(this.mBookmarksUriWithProfile, new String[]{"url"}, "keyword = ?", new String[]{string2}, null);
            if (cursor.moveToFirst()) {
                String string3 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                return string3;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long getFolderIdFromGuid(ContentResolver contentResolver, String string2) {
        if (this.mFolderIdMap.containsKey(string2)) {
            return this.mFolderIdMap.get(string2);
        }
        long l = -1L;
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(this.mBookmarksUriWithProfile, new String[]{"_id"}, "guid = ?", new String[]{string2}, null);
            if (cursor.moveToFirst()) {
                l = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        this.mFolderIdMap.put(string2, l);
        return l;
    }

    protected void bumpParents(ContentResolver contentResolver, String string2, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
        String string4 = string2 + " = ?";
        String[] stringArray = new String[]{string3};
        int n = contentResolver.update(this.mParentsUriWithProfile, contentValues, string4, stringArray);
        LocalBrowserDB.debug("Updated " + n + " rows to new modified time.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBookmarkItem(ContentResolver contentResolver, String string2, String string3, long l) {
        long l2 = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("title", string2);
        contentValues.put("url", string3);
        contentValues.put("parent", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l2));
        Cursor cursor = null;
        try {
            int n;
            cursor = contentResolver.query(this.mHistoryUriWithProfile, new String[]{"favicon_id"}, "url = ?", new String[]{string3}, null);
            if (cursor.moveToFirst() && !cursor.isNull(n = cursor.getColumnIndexOrThrow("favicon_id"))) {
                contentValues.put("favicon_id", Long.valueOf(cursor.getLong(n)));
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        contentValues.put("deleted", Integer.valueOf(0));
        Uri uri = this.mBookmarksUriWithProfile.buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        contentResolver.update(uri, contentValues, "url = ? AND parent = " + l, new String[]{string3});
        LocalBrowserDB.debug("Bumping parent modified time for addition to: " + l);
        String[] stringArray = new String[]{String.valueOf(l)};
        ContentValues contentValues2 = new ContentValues();
        contentValues2.put("modified", Long.valueOf(l2));
        int n = contentResolver.update(this.mBookmarksUriWithProfile, contentValues2, "_id = ?", stringArray);
        LocalBrowserDB.debug("Updated " + n + " rows to new modified time.");
    }

    @Override
    public void addBookmark(ContentResolver contentResolver, String string2, String string3) {
        long l = this.getFolderIdFromGuid(contentResolver, "mobile");
        this.addBookmarkItem(contentResolver, string2, string3, l);
    }

    @Override
    public void removeBookmark(ContentResolver contentResolver, int n) {
        Uri uri = this.mBookmarksUriWithProfile;
        String string2 = String.valueOf(n);
        this.bumpParents(contentResolver, "_id", string2);
        String[] stringArray = new String[]{string2};
        contentResolver.delete(uri, "_id = ?", stringArray);
    }

    @Override
    public void removeBookmarksWithURL(ContentResolver contentResolver, String string2) {
        Uri uri = this.mBookmarksUriWithProfile;
        this.bumpParents(contentResolver, "url", string2);
        String[] stringArray = new String[]{string2, String.valueOf(-2)};
        contentResolver.delete(uri, "url = ? AND parent != ?", stringArray);
    }

    @Override
    public void addReadingListItem(ContentResolver contentResolver, String string2, String string3) {
        this.addBookmarkItem(contentResolver, string2, string3, -2L);
    }

    @Override
    public void removeReadingListItemWithURL(ContentResolver contentResolver, String string2) {
        Uri uri = this.mBookmarksUriWithProfile;
        this.bumpParents(contentResolver, "url", string2);
        String[] stringArray = new String[]{string2, String.valueOf(-2)};
        contentResolver.delete(uri, "url = ? AND parent == ?", stringArray);
    }

    @Override
    public void registerBookmarkObserver(ContentResolver contentResolver, ContentObserver contentObserver) {
        contentResolver.registerContentObserver(this.mBookmarksUriWithProfile, false, contentObserver);
    }

    @Override
    public void registerHistoryObserver(ContentResolver contentResolver, ContentObserver contentObserver) {
        contentResolver.registerContentObserver(this.mHistoryUriWithProfile, false, contentObserver);
    }

    @Override
    public void updateBookmark(ContentResolver contentResolver, int n, String string2, String string3, String string4) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("title", string3);
        contentValues.put("url", string2);
        contentValues.put("keyword", string4);
        contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
        contentResolver.update(this.mBookmarksUriWithProfile, contentValues, "_id = ?", new String[]{String.valueOf(n)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoadFaviconResult getFaviconForUrl(ContentResolver contentResolver, String string2) {
        Cursor cursor = null;
        byte[] byArray = null;
        try {
            cursor = contentResolver.query(this.mFaviconsUriWithProfile, new String[]{"data"}, "url = ?", new String[]{string2}, null);
            if (!cursor.moveToFirst()) {
                LoadFaviconResult loadFaviconResult = null;
                return loadFaviconResult;
            }
            int n = cursor.getColumnIndexOrThrow("data");
            byArray = cursor.getBlob(n);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (byArray == null) {
            return null;
        }
        return FaviconDecoder.decodeFavicon(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFaviconUrlForHistoryUrl(ContentResolver contentResolver, String string2) {
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(this.mHistoryUriWithProfile, new String[]{"favicon_url"}, "url = ?", new String[]{string2}, null);
            if (cursor.moveToFirst()) {
                String string3 = cursor.getString(cursor.getColumnIndexOrThrow("favicon_url"));
                return string3;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    @Override
    public void updateFaviconForUrl(ContentResolver contentResolver, String string2, byte[] byArray, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("url", string3);
        contentValues.put("page_url", string2);
        contentValues.put("data", byArray);
        Uri uri = this.getAllFaviconsUri().buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        contentResolver.update(uri, contentValues, "url = ?", new String[]{string3});
    }

    @Override
    public void updateThumbnailForUrl(ContentResolver contentResolver, String string2, BitmapDrawable bitmapDrawable) {
        Bitmap bitmap = bitmapDrawable.getBitmap();
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)byteArrayOutputStream)) {
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            Log.w((String)LOGTAG, (String)"Favicon compression failed.");
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("data", byArray);
        contentValues.put("url", string2);
        Uri uri = this.mThumbnailsUriWithProfile.buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        contentResolver.update(uri, contentValues, "url = ?", new String[]{string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getThumbnailForUrl(ContentResolver contentResolver, String string2) {
        Cursor cursor = null;
        byte[] byArray = null;
        try {
            cursor = contentResolver.query(this.mThumbnailsUriWithProfile, new String[]{"data"}, "url = ?", new String[]{string2}, null);
            if (cursor.moveToFirst()) {
                int n = cursor.getColumnIndexOrThrow("data");
                byArray = cursor.getBlob(n);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return byArray;
    }

    @Override
    public Cursor getThumbnailsForUrls(ContentResolver contentResolver, List<String> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("data IS NOT NULL AND url IN (");
        int n2 = 1;
        while (n2++ < n) {
            stringBuilder.append("?, ");
        }
        stringBuilder.append("?)");
        String[] stringArray = list.toArray(new String[n]);
        return contentResolver.query(this.mThumbnailsUriWithProfile, new String[]{"url", "data"}, stringBuilder.toString(), stringArray, null);
    }

    @Override
    public void removeThumbnails(ContentResolver contentResolver) {
        contentResolver.delete(this.mThumbnailsUriWithProfile, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHistoryInBatch(ContentResolver contentResolver, Collection<ContentProviderOperation> collection, String string2, String string3, long l, int n) {
        Cursor cursor = null;
        try {
            String[] stringArray = new String[]{"_id", "visits", "date"};
            cursor = contentResolver.query(this.getAllHistoryUri(), stringArray, "url = ?", new String[]{string2}, null);
            ContentValues contentValues = new ContentValues();
            contentValues.put("deleted", Integer.valueOf(0));
            if (cursor.moveToFirst()) {
                int n2 = cursor.getColumnIndexOrThrow("visits");
                int n3 = cursor.getColumnIndexOrThrow("date");
                int n4 = cursor.getInt(n2);
                long l2 = cursor.getLong(n3);
                contentValues.put("visits", Integer.valueOf(n4 + n));
                if (l > l2) {
                    contentValues.put("date", Long.valueOf(l));
                }
            } else {
                contentValues.put("visits", Integer.valueOf(n));
                contentValues.put("date", Long.valueOf(l));
            }
            if (string3 != null) {
                contentValues.put("title", string3);
            }
            contentValues.put("url", string2);
            Uri uri = this.getAllHistoryUri().buildUpon().appendQueryParameter("insert_if_needed", "true").build();
            ContentProviderOperation.Builder builder = ContentProviderOperation.newUpdate((Uri)uri);
            builder.withSelection("url = ?", new String[]{string2});
            builder.withValues(contentValues);
            collection.add(builder.build());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void updateBookmarkInBatch(ContentResolver contentResolver, Collection<ContentProviderOperation> collection, String string2, String string3, String string4, long l, long l2, long l3, long l4, String string5, int n) {
        ContentValues contentValues = new ContentValues();
        if (string3 == null && string2 != null) {
            string3 = string2;
        }
        if (string3 != null) {
            contentValues.put("title", string3);
        }
        if (string2 != null) {
            contentValues.put("url", string2);
        }
        if (string4 != null) {
            contentValues.put("guid", string4);
        }
        if (string5 != null) {
            contentValues.put("keyword", string5);
        }
        if (l2 > 0L) {
            contentValues.put("created", Long.valueOf(l2));
        }
        if (l3 > 0L) {
            contentValues.put("modified", Long.valueOf(l3));
        }
        contentValues.put("position", Long.valueOf(l4));
        contentValues.put("deleted", Integer.valueOf(0));
        if (l < 0L) {
            l = this.getFolderIdFromGuid(contentResolver, "mobile");
        }
        contentValues.put("parent", Long.valueOf(l));
        contentValues.put("type", Integer.valueOf(n));
        Uri uri = this.getAllBookmarksUri().buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        ContentProviderOperation.Builder builder = ContentProviderOperation.newUpdate((Uri)uri);
        if (string2 != null) {
            builder.withSelection("url = ? AND parent = ? AND parent != ?", new String[]{string2, Long.toString(l), String.valueOf(-2)});
        } else if (string3 != null) {
            builder.withSelection("title = ? AND parent = ? AND parent != ?", new String[]{string3, Long.toString(l), String.valueOf(-2)});
        } else if (n == 2) {
            builder.withSelection("position = ? AND parent = ? AND parent != ?", new String[]{Long.toString(l4), Long.toString(l), String.valueOf(-2)});
        } else {
            Log.e((String)LOGTAG, (String)"Bookmark entry without url or title and not a seperator, not added.");
        }
        builder.withValues(contentValues);
        collection.add(builder.build());
    }

    public void updateFaviconInBatch(ContentResolver contentResolver, Collection<ContentProviderOperation> collection, String string2, String string3, String string4, byte[] byArray) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("data", byArray);
        contentValues.put("page_url", string2);
        if (string3 != null) {
            contentValues.put("url", string3);
        }
        Uri uri = this.getAllFaviconsUri().buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        ContentProviderOperation.Builder builder = ContentProviderOperation.newUpdate((Uri)uri);
        builder.withValues(contentValues);
        builder.withSelection("page_url = ?", new String[]{string2});
        collection.add(builder.build());
    }

    @Override
    public void pinSite(ContentResolver contentResolver, String string2, String string3, int n) {
        ContentValues contentValues = new ContentValues();
        long l = System.currentTimeMillis();
        contentValues.put("title", string3);
        contentValues.put("url", string2);
        contentValues.put("parent", Integer.valueOf(-3));
        contentValues.put("modified", Long.valueOf(l));
        contentValues.put("position", Integer.valueOf(n));
        contentValues.put("deleted", Integer.valueOf(0));
        Uri uri = this.mBookmarksUriWithProfile.buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        contentResolver.update(uri, contentValues, "position = ? AND parent = ?", new String[]{Integer.toString(n), String.valueOf(-3)});
    }

    @Override
    public Cursor getPinnedSites(ContentResolver contentResolver, int n) {
        return contentResolver.query(this.bookmarksUriWithLimit(n), new String[]{"_id", "url", "title", "position"}, "parent == ?", new String[]{String.valueOf(-3)}, "position ASC");
    }

    @Override
    public void unpinSite(ContentResolver contentResolver, int n) {
        contentResolver.delete(this.mBookmarksUriWithProfile, "parent == ? AND position = ?", new String[]{String.valueOf(-3), Integer.toString(n)});
    }

    @Override
    public void unpinAllSites(ContentResolver contentResolver) {
        contentResolver.delete(this.mBookmarksUriWithProfile, "parent == ?", new String[]{String.valueOf(-3)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isVisited(ContentResolver contentResolver, String string2) {
        int n = 0;
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(this.historyUriWithLimit(1), new String[]{"_id"}, "url = ?", new String[]{string2}, "url");
            n = cursor.getCount();
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)LOGTAG, (String)"NullPointerException in isVisited");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return n > 0;
    }

    @Override
    public Cursor getBookmarkForUrl(ContentResolver contentResolver, String string2) {
        Cursor cursor = contentResolver.query(this.bookmarksUriWithLimit(1), new String[]{"_id", "url", "title", "keyword"}, "url = ?", new String[]{string2}, null);
        if (cursor != null && cursor.getCount() == 0) {
            cursor.close();
            cursor = null;
        }
        return cursor;
    }

    private static class LocalDBCursor
    extends CursorWrapper {
        public LocalDBCursor(Cursor cursor) {
            super(cursor);
        }

        private String translateColumnName(String string2) {
            if (string2.equals("url")) {
                string2 = "url";
            } else if (string2.equals("title")) {
                string2 = "title";
            } else if (string2.equals("favicon")) {
                string2 = "favicon";
            } else if (string2.equals("date-last-visited")) {
                string2 = "date";
            } else if (string2.equals("visits")) {
                string2 = "visits";
            }
            return string2;
        }

        public int getColumnIndex(String string2) {
            return super.getColumnIndex(this.translateColumnName(string2));
        }

        public int getColumnIndexOrThrow(String string2) {
            return super.getColumnIndexOrThrow(this.translateColumnName(string2));
        }
    }

    private class SpecialFoldersCursorWrapper
    extends CursorWrapper {
        private int mIndexOffset;
        private int mDesktopBookmarksIndex;
        private boolean mAtDesktopBookmarksPosition;

        public SpecialFoldersCursorWrapper(Cursor cursor, boolean bl) {
            super(cursor);
            this.mDesktopBookmarksIndex = -1;
            this.mAtDesktopBookmarksPosition = false;
            this.mIndexOffset = 0;
            if (bl) {
                this.mDesktopBookmarksIndex = this.mIndexOffset++;
            }
        }

        public int getCount() {
            return super.getCount() + this.mIndexOffset;
        }

        public boolean moveToPosition(int n) {
            boolean bl = this.mAtDesktopBookmarksPosition = this.mDesktopBookmarksIndex == n;
            if (this.mAtDesktopBookmarksPosition) {
                return true;
            }
            return super.moveToPosition(n - this.mIndexOffset);
        }

        public long getLong(int n) {
            if (!this.mAtDesktopBookmarksPosition) {
                return super.getLong(n);
            }
            if (n == this.getColumnIndex("parent")) {
                return 0L;
            }
            return -1L;
        }

        public int getInt(int n) {
            if (!this.mAtDesktopBookmarksPosition) {
                return super.getInt(n);
            }
            if (n == this.getColumnIndex("_id") && this.mAtDesktopBookmarksPosition) {
                return -1;
            }
            if (n == this.getColumnIndex("type")) {
                return 0;
            }
            return -1;
        }

        public String getString(int n) {
            if (!this.mAtDesktopBookmarksPosition) {
                return super.getString(n);
            }
            if (n == this.getColumnIndex("guid") && this.mAtDesktopBookmarksPosition) {
                return "desktop";
            }
            return "";
        }
    }
}

