/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons;

import android.content.ContentResolver;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.http.AndroidHttpClient;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFaviconTask
extends UiAsyncTask<Void, Void, Bitmap> {
    private static final String LOGTAG = "LoadFaviconTask";
    private static final HashMap<String, LoadFaviconTask> loadsInFlight = new HashMap();
    public static final int FLAG_PERSIST = 1;
    public static final int FLAG_SCALE = 2;
    private static final int MAX_REDIRECTS_TO_FOLLOW = 5;
    private static final int DEFAULT_FAVICON_BUFFER_SIZE = 25000;
    private static AtomicInteger mNextFaviconLoadId = new AtomicInteger(0);
    private int mId = mNextFaviconLoadId.incrementAndGet();
    private String mPageUrl;
    private String mFaviconUrl;
    private OnFaviconLoadedListener mListener;
    private int mFlags;
    private final boolean mOnlyFromLocal;
    protected int mTargetWidth;
    private LinkedList<LoadFaviconTask> mChainees;
    private boolean mIsChaining;
    static AndroidHttpClient sHttpClient = AndroidHttpClient.newInstance((String)GeckoAppShell.getGeckoInterface().getDefaultUAString());

    public LoadFaviconTask(Handler handler, String string2, String string3, int n, OnFaviconLoadedListener onFaviconLoadedListener) {
        this(handler, string2, string3, n, onFaviconLoadedListener, -1, false);
    }

    public LoadFaviconTask(Handler handler, String string2, String string3, int n, OnFaviconLoadedListener onFaviconLoadedListener, int n2, boolean bl) {
        super(handler);
        this.mPageUrl = string2;
        this.mFaviconUrl = string3;
        this.mListener = onFaviconLoadedListener;
        this.mFlags = n;
        this.mTargetWidth = n2;
        this.mOnlyFromLocal = bl;
    }

    private LoadFaviconResult loadFaviconFromDb() {
        ContentResolver contentResolver = Favicons.sContext.getContentResolver();
        return BrowserDB.getFaviconForFaviconUrl(contentResolver, this.mFaviconUrl);
    }

    private void saveFaviconToDb(byte[] byArray) {
        if ((this.mFlags & 1) == 0) {
            return;
        }
        ContentResolver contentResolver = Favicons.sContext.getContentResolver();
        BrowserDB.updateFaviconForUrl(contentResolver, this.mPageUrl, byArray, this.mFaviconUrl);
    }

    private HttpResponse tryDownload(URI uRI) throws URISyntaxException, IOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(uRI.toString());
        return this.tryDownloadRecurse(uRI, hashSet);
    }

    private HttpResponse tryDownloadRecurse(URI uRI, HashSet<String> hashSet) throws URISyntaxException, IOException {
        if (hashSet.size() == 5) {
            return null;
        }
        HttpGet httpGet = new HttpGet(uRI);
        HttpResponse httpResponse = sHttpClient.execute((HttpUriRequest)httpGet);
        if (httpResponse == null) {
            return null;
        }
        if (httpResponse.getStatusLine() != null) {
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n >= 300 && n < 400) {
                Header header = httpResponse.getFirstHeader("Location");
                if (header == null) {
                    return null;
                }
                String string2 = header.getValue();
                if (string2 == null || string2.equals(uRI.toString())) {
                    return null;
                }
                if (hashSet.contains(string2)) {
                    return null;
                }
                hashSet.add(string2);
                return this.tryDownloadRecurse(new URI(string2), hashSet);
            }
            if (n >= 400) {
                return null;
            }
        }
        return httpResponse;
    }

    private static Bitmap fetchJARFavicon(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.startsWith("jar:jar:")) {
            Log.d((String)LOGTAG, (String)"Fetching favicon from JAR.");
            try {
                return GeckoJarReader.getBitmap((Resources)Favicons.sContext.getResources(), (String)string2);
            }
            catch (Exception exception) {
                Log.w((String)LOGTAG, (String)"Error fetching favicon from JAR.", (Throwable)exception);
                return null;
            }
        }
        return null;
    }

    private LoadFaviconResult downloadFavicon(URI uRI) {
        if (uRI == null) {
            return null;
        }
        String string2 = uRI.getScheme();
        if (!"http".equals(string2) && !"https".equals(string2)) {
            return null;
        }
        LoadFaviconResult loadFaviconResult = null;
        try {
            loadFaviconResult = this.downloadAndDecodeImage(uRI);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error reading favicon", (Throwable)exception);
        }
        return loadFaviconResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadFaviconResult downloadAndDecodeImage(URI uRI) throws IOException, URISyntaxException {
        HttpResponse httpResponse = this.tryDownload(uRI);
        if (httpResponse == null) {
            return null;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return null;
        }
        long l = httpEntity.getContentLength();
        int n = l > 0L ? (int)l + 1 : 25000;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        InputStream inputStream = httpEntity.getContent();
        try {
            while (n3 != -1) {
                if ((n2 += (n3 = inputStream.read(byArray, n2, byArray.length - n2))) != byArray.length) continue;
                byte[] byArray2 = new byte[n *= 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
        }
        finally {
            inputStream.close();
        }
        return FaviconDecoder.decodeFavicon(byArray, 0, n2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap doInBackground(Void ... voidArray) {
        Object object;
        if (this.isCancelled()) {
            return null;
        }
        boolean bl = false;
        if (TextUtils.isEmpty((CharSequence)this.mFaviconUrl)) {
            String string2 = Favicons.getFaviconURLForPageURLFromCache(this.mPageUrl);
            if (string2 == null && (string2 = Favicons.getFaviconURLForPageURL(this.mPageUrl)) != null) {
                Favicons.putFaviconURLForPageURLInCache(this.mPageUrl, string2);
            }
            if (string2 != null) {
                this.mFaviconUrl = string2;
            } else {
                this.mFaviconUrl = Favicons.guessDefaultFaviconURL(this.mPageUrl);
                if (TextUtils.isEmpty((CharSequence)this.mFaviconUrl)) {
                    return null;
                }
                bl = true;
            }
        }
        if (Favicons.isFailedFavicon(this.mFaviconUrl)) {
            return null;
        }
        if (this.isCancelled()) {
            return null;
        }
        Object object2 = loadsInFlight;
        synchronized (object2) {
            object = loadsInFlight.get(this.mFaviconUrl);
            if (object != null && !object.isCancelled()) {
                object.chainTasks(this);
                this.mIsChaining = true;
                return null;
            }
            loadsInFlight.put(this.mFaviconUrl, this);
        }
        if (this.isCancelled()) {
            return null;
        }
        object2 = this.loadFaviconFromDb();
        if (object2 != null) {
            return this.pushToCacheAndGetResult((LoadFaviconResult)object2);
        }
        if (this.mOnlyFromLocal || this.isCancelled()) {
            return null;
        }
        Bitmap bitmap = LoadFaviconTask.fetchJARFavicon(this.mFaviconUrl);
        if (LoadFaviconTask.imageIsValid(bitmap)) {
            Favicons.putFaviconInMemCache(this.mFaviconUrl, bitmap);
            return bitmap;
        }
        try {
            object2 = this.downloadFavicon(new URI(this.mFaviconUrl));
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.e((String)LOGTAG, (String)"The provided favicon URL is not valid");
            return null;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Couldn't download favicon.", (Throwable)exception);
        }
        if (object2 != null) {
            this.saveFaviconToDb(((LoadFaviconResult)object2).getBytesForDatabaseStorage());
            return this.pushToCacheAndGetResult((LoadFaviconResult)object2);
        }
        if (bl) {
            Favicons.putFaviconInFailedCache(this.mFaviconUrl);
            return null;
        }
        if (this.isCancelled()) {
            return null;
        }
        object = Favicons.guessDefaultFaviconURL(this.mPageUrl);
        if (object == null) {
            Favicons.putFaviconInFailedCache(this.mFaviconUrl);
            return null;
        }
        bitmap = LoadFaviconTask.fetchJARFavicon((String)object);
        if (LoadFaviconTask.imageIsValid(bitmap)) {
            Favicons.putFaviconInMemCache(this.mFaviconUrl, bitmap);
            return bitmap;
        }
        try {
            object2 = this.downloadFavicon(new URI((String)object));
        }
        catch (Exception exception) {
            return null;
        }
        if (object2 != null) {
            this.saveFaviconToDb(((LoadFaviconResult)object2).getBytesForDatabaseStorage());
            return this.pushToCacheAndGetResult((LoadFaviconResult)object2);
        }
        return null;
    }

    private Bitmap pushToCacheAndGetResult(LoadFaviconResult loadFaviconResult) {
        Favicons.putFaviconsInMemCache(this.mFaviconUrl, loadFaviconResult.getBitmaps());
        Bitmap bitmap = Favicons.getSizedFaviconFromCache(this.mFaviconUrl, this.mTargetWidth);
        return bitmap;
    }

    private static boolean imageIsValid(Bitmap bitmap) {
        return bitmap != null && bitmap.getWidth() > 0 && bitmap.getHeight() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPostExecute(Bitmap bitmap) {
        if (this.mIsChaining) {
            return;
        }
        this.processResult(bitmap);
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            loadsInFlight.remove(this.mFaviconUrl);
        }
        if (this.mChainees != null) {
            for (LoadFaviconTask loadFaviconTask : this.mChainees) {
                loadFaviconTask.processResult(bitmap);
            }
        }
    }

    private void processResult(Bitmap bitmap) {
        Favicons.removeLoadTask(this.mId);
        Bitmap bitmap2 = bitmap;
        if (this.mTargetWidth != -1 && bitmap != null && bitmap.getWidth() != this.mTargetWidth) {
            bitmap2 = Favicons.getSizedFaviconFromCache(this.mFaviconUrl, this.mTargetWidth);
        }
        Favicons.dispatchResult(this.mPageUrl, this.mFaviconUrl, bitmap2, this.mListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCancelled() {
        Favicons.removeLoadTask(this.mId);
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            LoadFaviconTask loadFaviconTask = loadsInFlight.get(this.mFaviconUrl);
            if (loadFaviconTask == this) {
                loadsInFlight.remove(this.mFaviconUrl);
                return;
            }
            if (loadFaviconTask == null) {
                return;
            }
            if (loadFaviconTask.mChainees != null) {
                loadFaviconTask.mChainees.remove((Object)this);
            }
        }
    }

    private void chainTasks(LoadFaviconTask loadFaviconTask) {
        if (this.mChainees == null) {
            this.mChainees = new LinkedList();
        }
        this.mChainees.add(loadFaviconTask);
    }

    int getId() {
        return this.mId;
    }

    static void closeHTTPClient() {
        if (ThreadUtils.isOnBackgroundThread()) {
            if (sHttpClient != null) {
                sHttpClient.close();
            }
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                LoadFaviconTask.closeHTTPClient();
            }
        });
    }
}

