/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.cache;

import android.graphics.Bitmap;
import android.util.Log;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.cache.FaviconCacheElement;
import org.mozilla.gecko.favicons.cache.FaviconsForURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaviconCache {
    private static final String LOGTAG = "FaviconCache";
    private static final int NUM_FAVICON_SIZES = 4;
    public final int mMaxCachedWidth;
    public static final long FAILURE_RETRY_MILLISECONDS = 1200000L;
    private final ConcurrentHashMap<String, FaviconsForURL> mBackingMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, FaviconsForURL> mPermanentBackingMap = new ConcurrentHashMap();
    private final LinkedList<FaviconCacheElement> mOrdering = new LinkedList();
    private final AtomicInteger mCurrentSize = new AtomicInteger(0);
    private final int mMaxSizeBytes;
    private final AtomicInteger mOngoingReads = new AtomicInteger(0);
    private final Semaphore mTurnSemaphore = new Semaphore(1);
    private final Semaphore mReorderingSemaphore = new Semaphore(1);
    private final Semaphore mWriteLock = new Semaphore(1);

    private void startRead() {
        this.mTurnSemaphore.acquireUninterruptibly();
        this.mTurnSemaphore.release();
        if (this.mOngoingReads.incrementAndGet() == 1) {
            this.mWriteLock.acquireUninterruptibly();
        }
    }

    private void upgradeReadToWrite() {
        this.mTurnSemaphore.acquireUninterruptibly();
        if (this.mOngoingReads.decrementAndGet() == 0) {
            this.mWriteLock.release();
        }
        this.mWriteLock.acquireUninterruptibly();
    }

    private void finishRead() {
        if (this.mOngoingReads.decrementAndGet() == 0) {
            this.mWriteLock.release();
        }
    }

    private void startWrite() {
        this.mTurnSemaphore.acquireUninterruptibly();
        this.mWriteLock.acquireUninterruptibly();
    }

    private void finishWrite() {
        this.mTurnSemaphore.release();
        this.mWriteLock.release();
    }

    public FaviconCache(int n, int n2) {
        this.mMaxSizeBytes = n;
        this.mMaxCachedWidth = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailedFavicon(String string2) {
        block17: {
            if (string2 == null) {
                return true;
            }
            this.startRead();
            boolean bl = false;
            boolean bl2 = false;
            try {
                if (!this.mBackingMap.containsKey(string2)) {
                    boolean bl3 = false;
                    return bl3;
                }
                FaviconsForURL faviconsForURL = this.mBackingMap.get(string2);
                if (!faviconsForURL.mHasFailed) {
                    boolean bl4 = false;
                    return bl4;
                }
                long l = faviconsForURL.mDownloadTimestamp;
                long l2 = System.currentTimeMillis() - l;
                if (l2 > 1200000L) {
                    bl = true;
                    break block17;
                }
                boolean bl5 = true;
                return bl5;
            }
            catch (Exception exception) {
                this.finishRead();
                bl2 = true;
                Log.e((String)LOGTAG, (String)"FaviconCache exception!", (Throwable)exception);
                boolean bl6 = true;
                return bl6;
            }
            finally {
                if (!bl2) {
                    if (bl) {
                        this.upgradeReadToWrite();
                    } else {
                        this.finishRead();
                    }
                }
            }
        }
        try {
            this.recordRemoved(this.mBackingMap.get(string2));
            this.mBackingMap.remove(string2);
            boolean bl = false;
            return bl;
        }
        finally {
            this.finishWrite();
        }
    }

    public void putFailed(String string2) {
        this.startWrite();
        if (this.mBackingMap.containsKey(string2)) {
            this.recordRemoved(this.mBackingMap.get(string2));
        }
        FaviconsForURL faviconsForURL = new FaviconsForURL(0, true);
        this.mBackingMap.put(string2, faviconsForURL);
        this.finishWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getFaviconForDimensions(String string2, int n) {
        Bitmap bitmap;
        FaviconCacheElement faviconCacheElement;
        FaviconsForURL faviconsForURL;
        if (string2 == null) {
            Log.e((String)LOGTAG, (String)"You passed a null faviconURL to getFaviconForDimensions. Don't.");
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.startRead();
        try {
            int n2;
            faviconsForURL = this.mPermanentBackingMap.get(string2);
            if (faviconsForURL == null) {
                faviconsForURL = this.mBackingMap.get(string2);
                if (faviconsForURL == null) {
                    Bitmap bitmap2 = null;
                    return bitmap2;
                }
            } else {
                bl4 = true;
            }
            if ((n2 = faviconsForURL.getNextHighestIndex(n)) != -1) {
                faviconCacheElement = faviconsForURL.mFavicons.get(n2);
                if (faviconCacheElement.mInvalidated) {
                    Bitmap bitmap3 = null;
                    return bitmap3;
                }
                if (faviconCacheElement.mImageSize == n) {
                    this.setMostRecentlyUsed(faviconCacheElement);
                    Bitmap bitmap4 = faviconCacheElement.mFaviconPayload;
                    return bitmap4;
                }
            } else {
                n2 = faviconsForURL.mFavicons.size();
            }
            if ((faviconCacheElement = faviconsForURL.getNextPrimary(n2)) == null) {
                Bitmap bitmap5 = null;
                return bitmap5;
            }
            bl = true;
            Bitmap bitmap6 = faviconCacheElement.mFaviconPayload;
            int n3 = faviconCacheElement.mImageSize;
            if (n3 >= n) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap6, (int)n, (int)n, (boolean)true);
            } else if ((n3 *= 2) >= n) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap6, (int)n, (int)n, (boolean)true);
            } else {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap6, (int)n3, (int)n3, (boolean)true);
                bl2 = true;
            }
        }
        catch (Exception exception) {
            bl3 = true;
            this.finishRead();
            Log.e((String)LOGTAG, (String)"FaviconCache exception!", (Throwable)exception);
            Bitmap bitmap7 = null;
            return bitmap7;
        }
        finally {
            if (!bl3) {
                if (bl) {
                    this.upgradeReadToWrite();
                } else {
                    this.finishRead();
                }
            }
        }
        try {
            if (bl2) {
                faviconsForURL.ensureDominantColor();
            }
            faviconCacheElement = faviconsForURL.addSecondary(bitmap, n);
            if (!bl4) {
                this.setMostRecentlyUsed(faviconCacheElement);
                this.mCurrentSize.addAndGet(faviconCacheElement.sizeOf());
            }
        }
        finally {
            this.finishWrite();
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDominantColor(String string2) {
        this.startRead();
        try {
            FaviconsForURL faviconsForURL = this.mPermanentBackingMap.get(string2);
            if (faviconsForURL == null) {
                faviconsForURL = this.mBackingMap.get(string2);
            }
            if (faviconsForURL == null) {
                Log.w((String)LOGTAG, (String)("Cannot compute dominant color of non-cached favicon. Cache fullness " + this.mCurrentSize.get() + '/' + this.mMaxSizeBytes));
                this.finishRead();
                int n = 0xFFFFFF;
                return n;
            }
            int n = faviconsForURL.ensureDominantColor();
            return n;
        }
        finally {
            this.finishRead();
        }
    }

    private void recordRemoved(FaviconsForURL faviconsForURL) {
        if (faviconsForURL == null) {
            return;
        }
        int n = 0;
        for (FaviconCacheElement faviconCacheElement : faviconsForURL.mFavicons) {
            n += faviconCacheElement.sizeOf();
            this.mOrdering.remove(faviconCacheElement);
        }
        this.mCurrentSize.addAndGet(-n);
    }

    private Bitmap produceCacheableBitmap(Bitmap bitmap) {
        if (bitmap == Favicons.sDefaultFavicon || bitmap == null) {
            return null;
        }
        if (bitmap.getWidth() > this.mMaxCachedWidth) {
            return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.mMaxCachedWidth, (int)this.mMaxCachedWidth, (boolean)true);
        }
        return bitmap;
    }

    private void setMostRecentlyUsed(FaviconCacheElement faviconCacheElement) {
        this.mReorderingSemaphore.acquireUninterruptibly();
        this.mOrdering.remove(faviconCacheElement);
        this.mOrdering.offer(faviconCacheElement);
        this.mReorderingSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSingleFavicon(String string2, Bitmap bitmap) {
        Bitmap bitmap2 = this.produceCacheableBitmap(bitmap);
        if (bitmap2 == null) {
            return;
        }
        FaviconsForURL faviconsForURL = new FaviconsForURL(4);
        FaviconCacheElement faviconCacheElement = faviconsForURL.addPrimary(bitmap2);
        this.startWrite();
        try {
            this.setMostRecentlyUsed(faviconCacheElement);
            this.mCurrentSize.addAndGet(faviconCacheElement.sizeOf());
            FaviconsForURL faviconsForURL2 = this.mBackingMap.put(string2, faviconsForURL);
            this.recordRemoved(faviconsForURL2);
        }
        finally {
            this.finishWrite();
        }
        this.cullIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFavicons(String string2, Iterator<Bitmap> iterator, boolean bl) {
        FaviconsForURL faviconsForURL = new FaviconsForURL(20);
        int n = 0;
        while (iterator.hasNext()) {
            Bitmap bitmap = this.produceCacheableBitmap(iterator.next());
            if (bitmap == null) continue;
            FaviconCacheElement faviconCacheElement = faviconsForURL.addPrimary(bitmap);
            n += faviconCacheElement.sizeOf();
        }
        this.startRead();
        boolean bl2 = false;
        this.mReorderingSemaphore.acquireUninterruptibly();
        try {
            if (!bl) {
                for (FaviconCacheElement faviconCacheElement : faviconsForURL.mFavicons) {
                    this.mOrdering.offer(faviconCacheElement);
                }
            }
        }
        catch (Exception exception) {
            bl2 = true;
            this.mReorderingSemaphore.release();
            this.finishRead();
            Log.e((String)LOGTAG, (String)"Favicon cache exception!", (Throwable)exception);
            return;
        }
        finally {
            if (!bl2) {
                this.mReorderingSemaphore.release();
                this.upgradeReadToWrite();
            }
        }
        try {
            if (bl) {
                this.mPermanentBackingMap.put(string2, faviconsForURL);
            } else {
                this.mCurrentSize.addAndGet(n);
                this.recordRemoved(this.mBackingMap.put(string2, faviconsForURL));
            }
        }
        finally {
            this.finishWrite();
        }
        this.cullIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cullIfRequired() {
        Log.d((String)LOGTAG, (String)("Favicon cache fullness: " + this.mCurrentSize.get() + '/' + this.mMaxSizeBytes));
        if (this.mCurrentSize.get() <= this.mMaxSizeBytes) {
            return;
        }
        this.startWrite();
        try {
            while (this.mCurrentSize.get() > this.mMaxSizeBytes) {
                FaviconCacheElement faviconCacheElement = this.mOrdering.poll();
                this.mCurrentSize.addAndGet(-faviconCacheElement.sizeOf());
                faviconCacheElement.onEvictedFromCache();
                Log.d((String)LOGTAG, (String)("After cull: " + this.mCurrentSize.get() + '/' + this.mMaxSizeBytes));
            }
        }
        finally {
            this.finishWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() {
        this.startWrite();
        try {
            this.mCurrentSize.set(0);
            this.mBackingMap.clear();
            this.mOrdering.clear();
        }
        finally {
            this.finishWrite();
        }
    }
}

